/*
 * AdabasPort.c --
 *
 *
 * This file contains procedures, that are neccessary only on some specific
 * architectures. It also has some procs that make it possible, to use
 * the new (from version 8.0 upward) object commands of Tcl, even
 * with a Tcl version, that is older.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 * $Id: AdabasPort.c,v 1.4 1997/06/08 19:38:28 adabas Exp $
 */

#include <string.h>
#include <tcl.h>
#include "AdabasPort.h"

#ifndef HAS_TCL_OBJECTS

int
LAppendIntResult (interp, val)
     Tcl_Interp *interp;		/* Current interpreter. */
     long        val;			/* number to set as result. */
{
  char numBuf[80];

  sprintf (numBuf, "%ld", val);
  Tcl_AppendElement (interp, numBuf);
  return TCL_OK;
}

int
SetIntResult (interp, val)
     Tcl_Interp *interp;		/* Current interpreter. */
     long        val;			/* number to set as result. */
{
  char numBuf[80];

  sprintf (numBuf, "%ld", val);
  Tcl_ResetResult (interp);
  AppendResult (interp, numBuf);
  return TCL_OK;
}

int
GetIndexFromObj (interp, obj, tablePtr, msg, flags, indexPtr)
     Tcl_Interp *interp;		/* Current interpreter (or NULL). */
     Tcl_Obj    *obj;			/* Object to get index from. */
     char      **tablePtr;		/* Table of know keywords. */
     char       *msg;			/* What to look for (for error message). */
     int         flags;			/* ignore this. */
     int        *indexPtr;		/* Pointer to result. */
{
  int    index;
  int    lastHit  = -1;
  int    noOfHits = 0;
  char  *option;
  char **currOption;
  int    length;

  option = Tcl_GetStringFromObj (obj, &length);

  for (currOption = tablePtr, index = 0; *currOption; currOption++, index++) {
    if (!strcmp (option, *currOption)) {
      *indexPtr = index;
      return TCL_OK;
    } else if (!strncmp (option, *currOption, length)) {
      lastHit = index;
      noOfHits++;
    }
  }
  if (noOfHits == 1) {
    *indexPtr = lastHit;
    return TCL_OK;
  }

  /*
   * If flow of control reaches this point, no matching keyword was found.
   */

  if (interp) {
    Tcl_AppendResult (interp, "bad ", msg, " \"", obj, "\": must be ",
		      (char *) NULL);
    for (currOption = tablePtr; *currOption; currOption++, index--) {
      Tcl_AppendResult (interp, *currOption,
			index > 2 ? ", " : index == 2 ? ", or " : "",
			(char *) NULL);
    }
  }
  return TCL_ERROR;
}

void
WrongNumArgs (interp, objc, objv, message)
     Tcl_Interp *interp;		/* Current interpreter. */
     int         objc;			/* Number of arguments. */
     ConstObjPtr objv[]; 		/* Argument objects. */
     char        *message;		/* Error information. */
{
  int curr;				/* Index over objects. */
  Tcl_ResetResult (interp);
  AppendResult (interp, "wrong # args: should be \"");
  for (curr = 0; curr < objc; curr++) {
    AppendResult (interp, Tcl_GetStringFromObj (objv[curr], (int *) NULL));
    AppendResult (interp, " ");
  }
  AppendResult (interp, message);
  AppendResult (interp, "\"");
}

#endif /* HAS_TCL_OBJECTS */



