/*
 * AdabasPort.h --
 *
 * This file contains macros, that are neccessary only on some specific
 * architectures. It also defines macros that make it possible, to use
 * the new (from version 8.0 upward) object commands of Tcl, even
 * with a Tcl version, that is older.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 * $Id: AdabasPort.h,v 1.11 1997/06/14 13:54:49 adabas Exp $
 */

#ifndef _ADABAS_PORT
#define _ADABAS_PORT

/*
 * If we are on a Windows system, we have to set some defines here,
 * since there exists no configure.
 *
 * First of all: Do we have Tcl_Obj?
 * Since there are some incompatiblities and added feature from 8.0a1 or 8.0a2
 * to 8.0b1, the alpha versions are supported only without TclObjects.
 */

#ifdef __WIN32__
#  if TCL_MAJOR_VERSION >= 8
#    define HAS_TCL_OBJECTS 1
#    if TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION == 0 && TCL_RELEASE_LEVEL == 0
#      undef HAS_TCL_OBJECTS
#    endif
#  endif
#endif

/*
 * Not all systems have unistd.h (e.g. Windows).
 */

#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#else
   EXTERN long lseek _ANSI_ARGS_((int fd, long offset, int whence));
   EXTERN int  read  _ANSI_ARGS_((int fd, char *buf, size_t size));
   EXTERN int  write _ANSI_ARGS_((int fd, char *buf, size_t size));
   EXTERN int  close _ANSI_ARGS_((int fd));
#endif

/*
 * For calls of the procedure open() on windows32 systems the flag O_RAW,
 * which submits end of line translations, must be or'ed to the mode argument.
 * On systems, where this flag isn't defined, we are using 0 (noop) instead.
 */

#ifndef O_RAW
#define O_RAW 0
#endif

/*
 * Backward compatibility to Tcl7.x.
 *
 * It is better to ask an extra identifier here instead of asking the
 * Tcl version directly, since so we can (for test purpose) switch to
 * the old behavior even with a new Tcl version. This identifier has
 * to be set by configure (disabled with --without-tclobj).
 */

#ifdef HAS_TCL_OBJECTS

#define SetResult(interp,str) \
     (Tcl_SetStringObj (Tcl_GetObjResult (interp), (str), -1))
#define AppendResult(interp,str) \
     (Tcl_AppendToObj (Tcl_GetObjResult (interp), (str), -1))
#define LAppendStringResult(interp,str) \
     (Tcl_ListObjAppendElement ((interp), Tcl_GetObjResult (interp), \
				Tcl_NewStringObj ((str), -1)))
#define LAppendIntResult(interp,val) \
     (Tcl_ListObjAppendElement ((interp), Tcl_GetObjResult (interp), \
				Tcl_NewIntObj ((val))))
#define SetIntResult(interp,val) \
     (Tcl_SetIntObj (Tcl_GetObjResult (interp), (val)))

typedef Tcl_Obj *CONST ConstObjPtr;

#else /* HAS_TCL_OBJECTS */

#define Tcl_ObjCmdProc Tcl_CmdProc
#define Tcl_CreateObjCommand(interp,name,proc,data,delete) \
     Tcl_CreateCommand(interp,name,proc,data,delete)

#define objc    argc
#define objv    argv
#define Tcl_Obj char
typedef char *ConstObjPtr;

#define Tcl_GetStringFromObj(obj,lenPtr) \
     ((lenPtr) ? ((*(lenPtr) = strlen(obj)), (obj)) : (obj))
#define Tcl_GetBooleanFromObj Tcl_GetBoolean
#define SetResult(interp,str) ((interp)->result = (str))
#define AppendResult(interp,str) \
     (Tcl_AppendResult ((interp), (str), (char *) NULL))
#define LAppendStringResult(interp,str) \
     (Tcl_AppendElement ((interp), (str)))

#define Tcl_GetIntFromObj      Tcl_GetInt
#define Tcl_GetIndexFromObj    GetIndexFromObj
#define Tcl_ListObjGetElements Tcl_SplitList
#define Tcl_WrongNumArgs       WrongNumArgs

EXTERN int  LAppendIntResult _ANSI_ARGS_((Tcl_Interp *interp, long val));
EXTERN int  SetIntResult _ANSI_ARGS_((Tcl_Interp *interp, long val));
EXTERN int  GetIndexFromObj _ANSI_ARGS_((Tcl_Interp *interp, Tcl_Obj *obj,
	 	char **tablePtr, char *msg, int flags, int *indexPtr));
EXTERN void WrongNumArgs _ANSI_ARGS_((Tcl_Interp *interp, int objc,
		ConstObjPtr objv[], char *message));

#endif /* HAS_TCL_OBJECTS */

#ifdef TK_MAJOR_VERSION
#  if TK_MAJOR_VERSION < 8
#  define Tk_SafeInit ((Tcl_PackageInitProc *) NULL)
#  endif
#endif

#endif /* _ADABAS_PORT */
