/* -------------------------------------------------------------- */
/* $Id: AdabasRte.h,v 1.23 1997/04/17 21:11:08 adabas Exp $ */
/* -------------------------------------------------------------- */
/* Copyright (c) 1996-1997 Christian Krone. All rights reserved.  */
/* This program is free software; you can redistribute it and/or  */
/* modify it under the same terms as Tcl itself.                  */
/* See also licence.terms                                         */
/* -------------------------------------------------------------- */

/* ----------------- Type definitions --------------------------- */
typedef struct {
  nodeid  dbnode;
  dbname  dbname;
  service service;
  int4    reference;
#if ADABAS_VERSION >= 62
  /*
   * In pre 6.2 the application is responsible for the allocation of
   * the packet. But now we have to remember the packet, and it can have
   * different size depending on a xparam configuration variable.
   */
  int4    sqlPacketSize;
  void   *sqlPacketList[1];
#endif
} AdabasRteInfo;

/* ----------------- Exported procedure headings ---------------- */
extern void AdabasRteInit _ANSI_ARGS_(());
extern int AdabasRteConnect _ANSI_ARGS_((Tcl_Interp *interp,
					 AdabasRteInfo *vars, char *serverdb,
					 int serv));
extern int AdabasRteSend _ANSI_ARGS_((Tcl_Interp *interp, AdabasRteInfo *vars,
				      packet *sndPacket,packet **rcvPacket));
extern void AdabasRteClose _ANSI_ARGS_((AdabasRteInfo *vars));
extern void AdabasRteCancel _ANSI_ARGS_((AdabasRteInfo *vars));
extern void AdabasRteTermId _ANSI_ARGS_((char *result));
extern void AdabasRteVersion _ANSI_ARGS_((char *rteVersion));
extern int AdabasXUserClear _ANSI_ARGS_((Tcl_Interp *interp));
extern int AdabasXUserOpen _ANSI_ARGS_((Tcl_Interp *interp));
extern int AdabasXUserClose _ANSI_ARGS_((Tcl_Interp *interp));
extern int AdabasXUserIndex _ANSI_ARGS_((Tcl_Interp *interp, int userIndex,
					 xuser_record *userParams));
extern int AdabasXUserGet _ANSI_ARGS_((Tcl_Interp *interp, char *userKey,
				       xuser_record *user_params));
extern int AdabasXUserPut _ANSI_ARGS_((Tcl_Interp *interp,
				       xuser_record *user_params));
extern int AdabasXUserArgs _ANSI_ARGS_((Tcl_Interp *interp,
					xuser_record *userParams,
					char *givenPasswd));

/* ---------------------------------------------------------------------
 * Some stuff for editing with emacs...
 * ---------------------------------------------------------------------
 * Local Variables: 
 * mode: c
 * mode: font-lock
 * End: 
 */
