/*
 * AdabasSend.h --
 *
 *      This module contains procedures, which opens a connection (logon)
 *      to the database server, and sends commands to it.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 *  $Id: AdabasSend.h,v 1.33 1997/06/08 19:39:16 adabas Exp $
 */

#ifndef _ADABAS_SEND
#define _ADABAS_SEND

#define ADABAS_TCL_VERSION  1.0

#ifdef HAS_TCL_OBJECTS

#define AdabasMessages     AdabasMessagesObj
#define AdamsgVersion      AdamsgVersionObj
#define AdamsgNullvalue    AdamsgNullvalueObj
#define AdamsgSpecialnull  AdamsgSpecialnullObj
#define AdamsgTracefile    AdamsgTracefileObj
#define AdamsgHandle       AdamsgHandleObj
#define AdamsgErrorpos     AdamsgErrorposObj
#define AdamsgErrortxt     AdamsgErrortxtObj
#define AdamsgRows         AdamsgRowsObj
#define AdamsgIntoVars     AdamsgIntoVarsObj
#define AdamsgRc           AdamsgRcObj
#define AdamsgColtypes     AdamsgColtypesObj
#define AdamsgCollengths   AdamsgCollengthsObj
#define AdamsgColprecs     AdamsgColprecsObj
#define AdamsgColscales    AdamsgColscalesObj

EXTERN Tcl_Obj *AdabasMessagesObj;
EXTERN Tcl_Obj *AdamsgVersionObj;
EXTERN Tcl_Obj *AdamsgNullvalueObj;
EXTERN Tcl_Obj *AdamsgSpecialnullObj;
EXTERN Tcl_Obj *AdamsgTracefileObj;
EXTERN Tcl_Obj *AdamsgHandleObj;
EXTERN Tcl_Obj *AdamsgErrorposObj;
EXTERN Tcl_Obj *AdamsgErrortxtObj;
EXTERN Tcl_Obj *AdamsgRowsObj;
EXTERN Tcl_Obj *AdamsgIntoVarsObj;
EXTERN Tcl_Obj *AdamsgRcObj;
EXTERN Tcl_Obj *AdamsgColtypesObj;
EXTERN Tcl_Obj *AdamsgCollengthsObj;
EXTERN Tcl_Obj *AdamsgColprecsObj;
EXTERN Tcl_Obj *AdamsgColscalesObj;

/*
 * Access to the array "adamsg" should go only over this macros.
 */

#define AdabasSetMsgString(interp,index,str) \
    (Tcl_ObjSetVar2 ((interp), AdabasMessages, (index), \
		    Tcl_NewStringObj ((str), -1), TCL_GLOBAL_ONLY))

#define AdabasSetMsgInt(interp,index,val) \
    (Tcl_ObjSetVar2 ((interp), AdabasMessages, (index), \
		    Tcl_NewIntObj (val), TCL_GLOBAL_ONLY))

#define AdabasUnsetMsg(interp,indexObj) { \
  int dummyLength; \
  char *adamsg = Tcl_GetStringFromObj (AdabasMessages, &dummyLength); \
  char *index  = Tcl_GetStringFromObj ((indexObj),     &dummyLength); \
  Tcl_UnsetVar2 ((interp), adamsg, index, TCL_GLOBAL_ONLY); \
}

#define AdabasGetMsgString(interp,index,lenPtr) \
    (Tcl_GetStringFromObj (Tcl_ObjGetVar2 ((interp), \
                    AdabasMessages, (index), TCL_GLOBAL_ONLY), (lenPtr)))

#define AdabasGetMsgInt(interp,index,intPtr) \
    (Tcl_GetIntFromObj ((interp), Tcl_ObjGetVar2 ((interp), \
                    AdabasMessages, (index), TCL_GLOBAL_ONLY), (intPtr)))

#define AdabasLAppendMsgString(interp,index,value) \
    (Tcl_ObjSetVar2 ((interp), AdabasMessages, (index), \
		    Tcl_NewStringObj ((value), -1), \
		    TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT))

#define AdabasLAppendMsgInt(interp,index,value) \
    (Tcl_ObjSetVar2 ((interp), AdabasMessages, (index), \
		    Tcl_NewIntObj (value), \
		    TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT))

#else /* no HAS_TCL_OBJECTS */

/*
 * The name of the global array, where the results of the adasql
 * commands get stored, and its indexes.
 */

#define AdabasMessages     "adamsg"
#define AdamsgVersion      "version"
#define AdamsgNullvalue    "nullvalue"
#define AdamsgSpecialnull  "specialnull"
#define AdamsgTracefile    "tracefile"
#define AdamsgHandle       "handle"
#define AdamsgErrorpos     "errorpos"
#define AdamsgErrortxt     "errortxt"
#define AdamsgRows         "rows"
#define AdamsgIntoVars    "intoVars"
#define AdamsgRc           "rc"
#define AdamsgColtypes     "coltypes"
#define AdamsgCollengths   "collengths"
#define AdamsgColprecs     "colprecs"
#define AdamsgColscales    "colscales"

/*
 * Access to the array "adamsg" should go only over this macros.
 */

#define AdabasSetMsgString(interp,index,str) \
    Tcl_SetVar2 (interp, AdabasMessages, index, str, TCL_GLOBAL_ONLY)

#define AdabasSetMsgInt(interp,index,val) { \
    char numBuf[80]; sprintf (numBuf, "%d", (val)); \
    Tcl_SetVar2 ((interp), AdabasMessages, (index), numBuf, TCL_GLOBAL_ONLY); \
}

#define AdabasUnsetMsg(interp,index) \
    Tcl_UnsetVar2 (interp, AdabasMessages, index, TCL_GLOBAL_ONLY)

#define AdabasGetMsgString(interp,index,lenPtr) \
  ((lenPtr) ? ((*(lenPtr) = strlen (Tcl_GetVar2 ((interp), AdabasMessages,       \
						 (index), TCL_GLOBAL_ONLY))),    \
               Tcl_GetVar2 ((interp), AdabasMessages, (index), TCL_GLOBAL_ONLY)) \
            : (Tcl_GetVar2 ((interp), AdabasMessages, (index), TCL_GLOBAL_ONLY)))

EXTERN int AdabasGetMsgInt _ANSI_ARGS_((Tcl_Interp *interp, char *index,
					int *intPtr));

#define AdabasLAppendMsgString(interp,index,value) \
    Tcl_SetVar2 (interp, AdabasMessages, index, value, \
		 TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT)

#define AdabasLAppendMsgInt(interp,index,value) { \
    char numBuf[80]; sprintf (numBuf, "%ld", value); \
    Tcl_SetVar2 ((interp), AdabasMessages, (index), numBuf, \
		 TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT); \
}

#endif /* HAS_TCL_OBJECTS */

/*
 * In pre-6.2 we have no part kinds, so here we have to define our
 * own enumeration type. Of cource we only define the kinds, we
 * actually use. And since we try to make life easy, we define
 * this enum for 6.2, too...
 */

#define PART_KINDS 6
typedef enum {
  pkNil,
  pkCommand,
  pkData,
  pkResultcount,
  pkLongdata,
  pkParsid
} partKind;

typedef struct {
  char        *buf;
  char        *name;
  int          bufLength;
  DataEncoding subst;
} AdabasPartInfo;

/*
 * Note, that it is important to put the array of records at the top,
 * since else the compiler on an HP-UX generated code, that accesses
 * the wrong entries.
 */

typedef struct {
  AdabasPartInfo   partInfos[PART_KINDS];
  AdabasRteInfo    rteInfo;
  AdabasPacketInfo packetInfo;

#if ADABAS_VERSION >= 62
  /*
   * In 6.2 the packet is allocated by the rte, so all we have to do here
   * is remember the address of it. The address of the return packet we
   * store here too, even if it doesn't change for 6.1...
   */
  packet *sndPacket;
#else /* ADABAS_VERSION <= 61 */
  /*
   * In pre-6.2 we have to declare the space for the packet ourself.
   * This is exactly the right (and the only one) place for this...
   */
  packet sqlPacket;
#endif

  /*
   * The address of the return packet we store here too, even if it
   * doesn't change for 6.1...
   */

  packet *rcvPacket;

  /*
   * When we get a pointer to this structure via the API, we can't be sure,
   * that it points to an address, where a valid AdabasInfo resides. For this
   * we wrote here a magic number and delete it, when closing the connection.
   */

# define LOGON_MAGIC 14+10+1958
  int  magic;

  /*
   * The Api call of AdabasLogoff doesn't know the name of the logonHandle.
   * So we have to store it here.
   */

  char logonName[DBNAME+7];
} AdabasInfo;

/*
 * The macro, that prints the formatted version string into the given buffer.
 */

#define SET_VERSION(result)					\
sprintf (result, "AdabasTcl %.1f (for Adabas D %01d.%01d)",	\
	 ADABAS_TCL_VERSION, ADABAS_VERSION/10, ADABAS_VERSION%10)

/*
 * Declarations of all the procedures of AdabasSend.c
 */

EXTERN void AdabasSendInit _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int  AdabasOpenConnection _ANSI_ARGS_((Tcl_Interp *interp,
		int service, char *serverdb, char *name, AdabasInfo **vars));
EXTERN int  AdabasCloseConnection _ANSI_ARGS_((Tcl_Interp *interp, char *Name,
		AdabasInfo *vars));
EXTERN int  AdabasLogonHandle _ANSI_ARGS_((Tcl_Interp *interp, char *logonName,
		AdabasInfo **logon));
EXTERN int  AdabasFillPacket _ANSI_ARGS_((Tcl_Interp *interp,
		AdabasInfo *vars, AdabasPacketInfo *thisOptions));
EXTERN int  AdabasSendPacket _ANSI_ARGS_((Tcl_Interp *interp,
		AdabasInfo *vars));
EXTERN int  AdabasSend2PartPacket _ANSI_ARGS_((Tcl_Interp *interp,
		AdabasInfo *vars, int part1Kind, char *part1,
		int part1Int, int part2Kind, char *part2, int part2Int));
EXTERN int  AdabasSendCmdPacket _ANSI_ARGS_((Tcl_Interp *interp,
		AdabasInfo *vars, int withInfo, int massCnt, char *command));
EXTERN int  AdabasCheckLogon _ANSI_ARGS_((Tcl_Interp *interp,
		AdabasInfo *logon));

#ifdef HAS_TCL_OBJECTS
EXTERN Tcl_ObjType LogonObjType;

#define ConvertToLogon(interp,objPtr,logonPtr) \
    ((Tcl_ConvertToType ((interp), (objPtr), &LogonObjType) == TCL_OK) \
     ? (*(logonPtr) = (AdabasInfo *) (objPtr)->internalRep.otherValuePtr, TCL_OK) \
     : TCL_ERROR)
#else
#define ConvertToLogon AdabasLogonHandle
#endif

#endif /* _ADABAS_SEND */
