/*
 * AdabasUtil.h --
 *
 *      This module contains utility procedures.
 *      Mostly this are procedures for converting from one encoding style
 *      into another, but (for 6.2) there is also some unicode stuff.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 * $Id: AdabasUtil.h,v 1.19 1997/05/31 14:04:41 adabas Exp $
 */

#ifndef _ADABAS_UTIL
#define _ADABAS_UTIL

typedef enum {
  encNil,
  encBase64,
  encEscape,
  encHex
} DataEncoding;

EXTERN void         p2c _ANSI_ARGS_((char *c_out, char *p_in, int len));
EXTERN void         c2p _ANSI_ARGS_((char *p_out, char *c_in, int len));

EXTERN void         decodeSequence _ANSI_ARGS_((Tcl_Interp *interp, int encoding,
			Tcl_Obj *outObj, Tcl_DString *out, char *in, int length));
EXTERN int4         encodeSequence _ANSI_ARGS_((Tcl_Interp *interp, int encoding,
			char *what, Tcl_DString *out, char *in, int inPos,
			int length));
EXTERN int          decodeSequenceAppend _ANSI_ARGS_((Tcl_Interp *interp,
			int encoding, Tcl_Obj *outObj, Tcl_DString *out,
			char *in, int oldLength, int length));

EXTERN DataEncoding scanEncoding _ANSI_ARGS_((Tcl_Interp *interp,
			char *encoding));

#if ADABAS_VERSION >= 62
#define TO_UNICODE   0
#define FROM_UNICODE 1
EXTERN int          AdabasFromToUnicode _ANSI_ARGS_((Tcl_Interp *interp, char *src,
			int4 srcLen, char *dest, int4 *destLen, int *trunc,
			int dir));
#endif

#endif /* _ADABAS_UTIL */
