/*
 * adabas.h --
 *
 *      This module contains all the defines, that are determined
 *      by the Adabas D database system.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 * $Id: adabas.h,v 1.15 1997/06/29 11:10:14 adabas Exp $
 */

#ifndef _ADABAS
#define _ADABAS

typedef unsigned char boolean;
typedef short         int2;
typedef int           int4;

typedef  signed char int1;
typedef  int1        code_type;

#if ADABAS_VERSION >= 62
#define IDENTIFIER 64
#else /* ADABAS_VERSION <= 61 */
#define IDENTIFIER 18
#endif

#define  MOVEOBJ      8192000
#define  DBNAME            18
#define  ERRTEXT           40
#define  PARSID            12

#define MAXINT2         32767
#define MAXINT4    2147483647

#define UNDEF_BYTE 0xff
#define OFLW_BYTE  0xfe

typedef  char warningset[2];

typedef  char c2[2];
typedef  char c3[3] ;
typedef  char c4[4];
typedef  char c5[5];
typedef  char c8[8];
typedef  char c11[11];
typedef  char c18[18];
typedef  char c20[20];
typedef  char c24[24];
typedef  char c40[40];
typedef  char c64[64];
typedef  char c132[132];

typedef  c24  cryptpw;
typedef  char moveobj[ MOVEOBJ ];
typedef  c40  errtext;
typedef  c18  name;
typedef  c18  dbname;
typedef  c64  nodeid;
typedef  c11  resnum;
typedef  c18  termid;
typedef  c18  username61;
typedef  c64  username;
typedef  c18  xuserkey;
typedef  c64  vfilename;
typedef  c132 line;

#define  SW_DUMMY  0
#define  SW_NORMAL  1
#define  SW_FULL_SWAPPED  2
#define  SW_PART_SWAPPED  3
typedef  signed char swap_kind;

#define  DFIXED  0
#define  DFLOAT  1
#define  DCHA  2
#define  DCHE  3
#define  DCHB  4
#define  DROWID  5
#define  DSTRA  6
#define  DSTRE  7
#define  DSTRB  8
#define  DSTRDB  9
#define  DDATE  10
#define  DTIME  11
#define  DVFLOAT  12
#define  DTIMESTAMP  13
#define  DUNKNOWN  14
#define  DNUMBER  15
#define  DNONUMBER  16
#define  DDURATION  17
#define  DDBYTEEBCDIC  18
#define  DLONGA  19
#define  DLONGE  20
#define  DLONGB  21
#define  DLONGDB  22
#define  DBOOLEAN  23
#define  DUNICODE  24
#define  DDTFILLER1  25
#define  DDTFILLER2  26
#define  DDTFILLER3  27
#define  DDTFILLER4  28
#define  DSMALLINT  29
#define  DINTEGER  30
#define  DVARCHARA  31
#define  DVARCHARE  32
#define  DVARCHARB  33
#define  DSTRUNI  34
#define  DLONGUNI  35
typedef  signed char data_type;

#define  NUM_OK  0
#define  NUM_TRUNC  1
#define  NUM_OVERFLOW  2
#define  NUM_INVALID  3
#define  NUM_INCOMPATIBLE  4
#define  NUM_MISSING_ADDR  5
typedef  signed char num_error;

#define  SQLOK  0
#define  SQLNOTOK  1
#define  SQLTASKLIMIT  2
#define  SQLTIMEOUT  3
#define  SQLCRASH  4
#define  SQLSTART_REQUIRED  5
#define  SQLSHUTDOWN  6
typedef  signed char comm_error;

#define  SQL_USER  0
#define  SQL_ASYNC_USER  1
#define  SQL_UTILITY  2
typedef  signed char service;

#define  SQL_PRECOMPILER  0
#define  SQL_PC_RUNTIME  1
#define  SQL_EASY  2
#define  SQL_QUERY  3
#define  SQL_DIALOG  4
#define  SQL_APPL  5
#define  SQL_LOAD  6
#define  SQL_UTIL  7
#define  SQL_AUDIT  8
#define  SQL_USERX  9
#define  SQL_PARAM  10
typedef  signed char component;

typedef  struct args_options {
  int2      opt_filler1;
  boolean   opt_filler2;
  component opt_component;
  vfilename opt_runfile;
  name      opt_object_owner;
  name      opt_object_name1;
  name      opt_object_name2;
  line      opt_parameter;
  boolean   opt_append;
  boolean   opt_prompt;
  boolean   opt_codeonly;
  boolean   opt_utility_session;
  char      opt_filler3[106];
} args_options;

typedef  c5 sqlstate;
typedef  c8 sqlmode_name;

#define  SQLM_NIL    -1
#define  SQLM_ANSI    0
#define  SQLM_DB2     1
#define  SQLM_ORACLE  2
#define  SQLM_ADABAS  3
typedef  signed char ext_sqlmode;

typedef  struct xuser_record {
  xuserkey     xu_key;
  int2         xu_fill;
  nodeid       xu_servernode;
  dbname       xu_serverdb;
#if ADABAS_VERSION >= 62
  username61   xu_user61;
#else /* ADABAS_VERSION <= 61 */
  username61   xu_user;
#endif
  cryptpw      xu_password;
  sqlmode_name xu_sqlmode;
  int4         xu_cachelimit;
  int2         xu_timeout;
  int2         xu_isolation;
#if ADABAS_VERSION >= 62
  c18          xu_dblang61;
  username     xu_user;
  c64          xu_dblang;
#endif
} xuser_record;


#define  VM_DATAPART  0
#define  VM_ALLDATA  1
#define  VM_LASTDATA  2
#define  VM_NODATA  3
#define  VM_NO_MORE_DATA  4
#define  VM_LAST_PUTVAL  5
#define  VM_DATA_TRUNC  6
#define  VM_CLOSE  7
typedef  signed char valmode;

#define  LD_EX_TRIGGER  0
#define  LD_WITH_LOCK  1
#define  LD_NO_CLOSE  2
typedef  signed char ld_info;

#define  LD_USE_TERMCHAR  0
#define  LD_USE_CONVERSION  1
#define  LD_USE_MULTIBYTE  2
#define  LD_USE_TOASCII  3

#define  CSP_INFO_FIXED  '\x00'
#define  CSP_INFO_FLOAT  '\x01'
#define  CSP_INFO_CHAR  '\x02'
#define  CSP_INFO_BYTE  '\x03'
#define  CSP_INFO_DATE  '\x04'
#define  CSP_INFO_TIME  '\x05'
#define  CSP_INFO_STRING  '\x06'
#define  CSP_INFO_EXPRESSION  '\x07'
#define  CSP_INFO_TIMESTAMP  '\x08'
#define  CSP_INFO_DBYTE_ASCII  '\x09'
#define  CSP_INFO_DBYTE_EBCDIC  '\x0A'
#define  CSP_INFO_C_OLDLONG_CHAR  '\x0B'
#define  CSP_INFO_B_OLDLONG_BYTE  '\x0C'
#define  CSP_INFO_A_OLDLONG_ASCII_DBYTE  '\x0D'
#define  CSP_INFO_E_OLDLONG_EBCDIC_DBYTE  '\x0E'
#define  CSP_INFO_C_LONG_CHAR  '\x13'
#define  CSP_INFO_B_LONG_BYTE  '\x14'
#define  CSP_INFO_A_LONG_ASCII_DBYTE  '\x15'
#define  CSP_INFO_E_LONG_EBCDIC_DBYTE  '\x16'
#define  CSP_INFO_SMALLINT  '\x0F'
#define  CSP_INFO_INTEGER  '\x10'
#define  CSP_INFO_VARCHAR  '\x11'
#define  CSP_INFO_ESCAPE_CHAR  '\x12'
#define  CSP_INFO_BOOLEAN  '\x17'
#define  CSP_INFO_OTHERWISE  '\x18'
#define  CSP_INFO_MANDATORY  '\x00'
#define  CSP_INFO_OPTIONAL  '\x01'
#define  CSP_INFO_DEFAULT  '\x02'
#define  CSP_INFO_INPUT  '\x00'
#define  CSP_INFO_OUTPUT  '\x01'
#define  CSP_INFO_INOUT  '\x02'

/* ----------------------------------------------------------------------- */
/* So called shortfield infos (only program intern for < 6.2)              */
/* ----------------------------------------------------------------------- */
#define  OT_MANDATORY  0
#define  OT_OPTIONAL  1
#define  OT_DEFAULT  2
#define  OT_ESCAPE_CHAR  3
typedef signed char param_opt_type;
typedef signed char param_opt_set;

#define  IO_INPUT  0
#define  IO_OUTPUT  1
#define  IO_INOUT  2
typedef signed char param_io_type;

typedef struct {
  param_opt_set mode;
  param_io_type io_type;
  data_type     data_type;
  int1          frac;
  int2          length;
  int2          in_out_len;
  int4          bufpos;
} field_info;

/* ======================================================================= */
/*                Order packet for version 6.2 or newer                    */
/* ======================================================================= */
#if ADABAS_VERSION >= 62

#define  M_NIL  0
#define  M_DBS  2
#define  M_PARSE  3
#define  M_GETPARSE  4
#define  M_SYNTAX  5
#define  M_EXECUTE  13
#define  M_GETEXECUTE  14
#define  M_PUTVAL  15
#define  M_GETVAL  16
#define  M_LOAD  17
#define  M_UNLOAD  18
#define  M_HELLO  25
#define  M_UTILITY  27
#define  M_INCOPY  28
#define  M_OUTCOPY  30
#define  M_SWITCH  39
#define  M_SWITCHLIMIT  40
#define  M_BUFLENGTH  41
#define  M_MINBUF  42
#define  M_MAXBUF  43
typedef signed char cmd_mess_type;

typedef signed char intern_warning;
typedef signed char warningset_intern;

#define  PK_NIL  0
#define  PK_APPL_PARAMETER_DESCRIPTION  1
#define  PK_COLUMNNAMES  2
#define  PK_COMMAND  3
#define  PK_CONV_TABLES_RETURNED  4
#define  PK_DATA  5
#define  PK_ERRORTEXT  6
#define  PK_GETINFO  7
#define  PK_MODULNAME  8
#define  PK_PAGE  9
#define  PK_PARSID  10
#define  PK_PARSID_OF_SELECT  11
#define  PK_RESULTCOUNT  12
#define  PK_RESULTTABLENAME  13
#define  PK_SHORTINFO  14
#define  PK_USER_INFO_RETURNED  15
#define  PK_SURROGATE  16
#define  PK_BDINFO  17
#define  PK_LONGDATA  18
typedef signed char part_kind;

#define  PA_LAST_PACKET  0
typedef signed char part_attributes;
typedef signed char part_attr;

#define  PR_NIL  0
#define  PR_USER_CMD  1
#define  PR_INTERNAL_CMD  2
#define  PR_KERNEL  3
#define  PR_INSTALLATION  4
typedef signed char producer;

#define  SK_NIL  0
#define  SK_CMD  1
#define  SK_RETURN  2
typedef signed char segment_kind;

#define  SM_NIL  0
#define  SM_SESSION_SQLMODE  1
#define  SM_ADABAS  2
#define  SM_ANSI  3
#define  SM_DB2  4
#define  SM_ORACLE  5
typedef signed char int_sqlmode;

typedef struct {
  part_kind  part_kind;
  part_attr  attributes;
  int2       arg_count;
  int4       segm_offset;
  int4       buf_len;
  int4       buf_size;
} part_header;

typedef struct {
  part_header part_header;
  moveobj     buf;
} part;

typedef struct {
  union {
    struct {
      int4          segm_len;
      int4          segm_offset;
      int2          no_of_parts;
      int2          own_index;
      segment_kind  segm_kind;
      /* --- cmd segment header --- */
      cmd_mess_type mess_type;
      int_sqlmode   sqlmode;
      producer      producer;
      boolean       commit_immediately;
      boolean       ignore_costwarning;
      boolean       prepare;
      boolean       with_info;
      boolean       mass_cmd;
      boolean       parsing_again;
      c2            filler1;
      c8            filler2;
      c8            filler3;
    } cmd;
    struct {
      c8                space2;
      c4                space3;
      segment_kind      space4;
      /* --- return segment header --- */
      sqlstate          sqlstate;  /* 5 bytes */
      int2              returncode;
      int4              errorpos;
      warningset        extern_warning;
      warningset_intern intern_warning;
      int2              function_code;  /* csp1_.._fc */
      int2              filler1;
      c8                filler2;
    } ret;
  } kind;
} segment_header;

typedef struct {
  segment_header segm_header;
  part           part;
} segment;

typedef struct {
  code_type   mess_code;
  swap_kind   mess_swap;
  int2        filler1;
  c5          appl_version;
  c3          application;
  int4        varpart_size;
  int4        varpart_len;
  int2        filler2;
  int2        no_of_segm;

  c8          filler3;
} packet_header;

typedef struct {
  packet_header header;
  segment       segm;
} packet;

typedef struct {
  c8          descriptor;
  c8          tabid;
  c2          serverdb_no;
  boolean     replicated;
  signed char change;
  int4        intern_pos;
  ld_info     infoset;
  boolean     short_scol;
  int1        unused_1;
  valmode     valmode;
  int2        valind;
  int2        unused_2;
  int4        valpos;
  int4        vallen;
} long_descriptor;

/* ======================================================================= */
/*                Order packet for version 6.1 or older                    */
/* ======================================================================= */
#else /* if ADABAS_VERSION <= 61 */

#define  PACKETHEAD        40
#define  VARPART         8240

typedef  char varpart[ VARPART ] ;

typedef  c20 rte_header;

#define  M_NIL                  -1
#define  M_DBS                 0x0
#define  M_PARSE               0x1
#define  M_EXECUTE             0x2
#define  M_UTILITY             0x4
#define  M_INCOPY              0x5
#define  M_OUTCOPY             0x7
#define  M_HELLO               0x9
#define  M_FILE                0xA
#define  M_SYNTAX              0xB
#define  M_LOAD                0xE
#define  M_UNLOAD             0x10
#define  M_GETPARSE           0x12
#define  M_GETEXECUTE         0x13
#define  M_PUTVAL             0x1C
#define  M_GETVAL             0x1D

#define  M_DBSINFO             0x3
#define  M_ENDINCOPY           0x6
#define  M_ENDOUTCOPY          0x8
#define  M_DBSCOMMIT           0xC
#define  M_DBSINFOCOMMIT       0xD
#define  M_DBSCATALOG          0xF
#define  M_DBSANSI            0x14
#define  M_DBSDB2             0x15
#define  M_DBSORACLE          0x16
#define  M_DBSADABAS          0x17
#define  M_PARSEANSI          0x18
#define  M_PARSEDB2           0x19
#define  M_PARSEORACLE        0x1A
#define  M_PARSEADABAS        0x1B
#define  M_DBSCOMMIT_EXECUTE  0x1E
#define  M_REPLY            0x5000

#define  M_SWITCH              500
#define  M_SWITCHLIMIT         501
#define  M_BUFLENGTH           502
#define  M_MINBUF              503
#define  M_MAXBUF              504

typedef struct {
  rte_header rte_header;
  code_type  mess_code_type;
  swap_kind  mess_swap_kind;
  int2       mess_type;
  c8         senderid;
  int2       part1_length;
  int2       part2_length;
  int2       return_code;
  int2       error_code;
  varpart    var_part;
} packet;

typedef struct {
  name          fieldname;
  char          d_type;
  unsigned char length;
  union {
    struct {
      char          frac;
      unsigned char in_out_l;
      int2          bufpos;
    } s;
    struct {
      int2 longiolen;
      int2 bufpos_1;
    } l;
  } var;
} field_info61;

typedef struct {
  char          mode;
  char          io_type;
  char          d_type;
  unsigned char length;
  union {
    struct {
      char          frac;
      unsigned char in_out_l;
      int2          bufpos;
    } s;
    struct {
      int2 longiolen;
      int2 bufpos_1;
    } l;
  } var;
} sfield_info61;

typedef  struct long_descriptor {
  c8          descriptor;
  c8          tabid;
  c2          serverdb_no;
  boolean     replicated;
  signed char change;
  int4        intern_pos;
  ld_info     infoset;
  boolean     short_scol;
  int1        valind;
  valmode     valmode;
  int2        valpos;
  int2        vallen;
} long_descriptor;

#endif

/* ------------------ Unicode ----------------------------------------*/
#if ADABAS_VERSION >= 62
typedef void *encodings_ptr;

#define UNI_OK  0
#define UNI_NO_SUCH_ENCODING  1
#define UNI_NOT_TRANSLATABLE  2
#define UNI_DEST_TOO_SHORT  3
#define UNI_SRC_TOO_SHORT  4
#define UNI_IS_SINGLEBYTE  5
#define UNI_IS_MULTIBYTE  6
#define UNI_IS_INCOMPLETE  7
typedef signed char uni_error;

#define UNI_LOAD_OK  0
#define UNI_ENCODING_NOT_FOUND  1
#define UNI_NO_DBLANG_FOUND  2
#define UNI_CANNOT_OPEN_INFOFILE  3
#define UNI_CANNOT_OPEN_LOCALEFILE  4
#define UNI_CANNOT_OPEN_LONGCOLFILE  5
#define UNI_FILE_ERROR_LOCALEFILE  6
#define UNI_FILE_ERROR_LONGCOLFILE  7
#define UNI_MEMORY_ALLOC_FAILED  8
#define UNI_ENCODING_ALREADY_LOADED  9
#define UNI_BAD_LOCALEFILE  10
#define UNI_BAD_INFOFILE  11
typedef signed char uni_load_error;

#define UNI_CHANGE_TO_UPPER  0
#define UNI_FILLUP_FIELD  1
typedef char uni_opt_set[1];

#define UNICODE_SWAP 19
#define UNICODE      20

#endif /* ADABAS_VERSION >= 62 */

#endif /* _ADABAS */
