
#---------------------------------------------------------------------------
#  LAST EDIT: Mon Dec 23 15:00:26 1996 by Adabas D Database (gutamil.v12-berlin.de!adabas) 
#  $Id: adasql.tcl,v 1.16 1996/12/23 14:00:45 adabas Exp $
#---------------------------------------------------------------------------
# Copyright (c) 1996 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# --------------------------------------------------------------------------

proc _adafetch_all {cursorHandle count commands} {
    global _adasql_handle adamsg

    set rows [adafetch $cursorHandle -count $count]

    while {[string length $rows]} {
	set ix 0
	while {[string length [set row [lindex $rows $ix]]]} {

	    set cmdList [split $commands @]
	    set evalCmd [lindex $cmdList 0]
	    foreach cmdPart [lrange $cmdList 1 end] {
		if {[regexp {^([0-9]*)} $cmdPart number]} {
		    if {$number > [llength $row]} {
			error "$number too big for '$row'"
		    }
		    if {$number == 0} {
			append evalCmd [list $row]
		    } else {
			incr number -1
			append evalCmd [lrange $row $number $number]
		    }
		    regsub {^([0-9]*)} $cmdPart "" restPart
		    append evalCmd $restPart
		} else {
		    error "@ without number found"
		}
	    }
	    uplevel 1 $evalCmd

	    incr ix
	}

	if {$ix == $count} {
	    set rows [adafetch $cursorHandle -count $count]
	} else {
	    set rows ""
	}
    }
}

if $tcl_interactive {
    set sqlsh [file dirname [info script]]/sqlsh.tcl
    if {[catch {source $sqlsh} msg]} {
	puts "Error while initializing adabastclsh:\n$msg"
    }
}

# ---------------------------------------------------------------------
# Some stuff for editing with emacs...
# ---------------------------------------------------------------------
# Local Variables: 
# mode: tcl
# mode: font-lock
# End: 
