/* ----------------------------------------------------------------- */
/*  LAST EDIT: Thu Nov 14 23:40:01 1996 by Adabas D Database (gutamil.v12-berlin.de!adabas)  */
/*  $Id: sqlrte.h,v 1.18 1996/11/17 20:42:04 adabas Exp $ */
/* ----------------------------------------------------------------- */
/* Copyright (c) 1996 Christian Krone. All rights reserved.          */
/* This program is free software; you can redistribute it and/or     */
/* modify it under the same terms as Tcl itself.                     */
/* See also licence.terms                                            */
/* ----------------------------------------------------------------- */

/* ----------------- variables  of ptoc.h -------------------------- */
#ifdef __WIN32__
#define RTE_ARGC WinArgc
#define RTE_ARGV WinArgv
#else
#define RTE_ARGC _argc
#define RTE_ARGV _argv
#endif
extern int    RTE_ARGC;
extern char **RTE_ARGV;

/* ----------------- types      of libsqlrte.a --------------------- */
typedef          char SQL_PASSWORD[18];
typedef unsigned char xuser_set[2];

/* ----------------- variables  of libsqlrte.a --------------------- */
extern c40 SQLRTEVERSION;

/* ----------------- procedures of libsqlrte.a --------------------- */

extern void sqlinit _ANSI_ARGS_((c64      component,
				 boolean *canceladdr));

#if ADABAS_VERSION >= 62
extern void sqlaconnect _ANSI_ARGS_((int4        pid,
				     nodeid      servernode,
				     dbname      serverdb,
				     service     service,
				     int4        packet_cnt,
				     int4       *reference,
				     int4       *sql_packet_size,
				     void       *sql_packet_list[],
				     errtext     errtext,
				     comm_error *returncode));

extern void sqlarequest _ANSI_ARGS_((int4        reference,
				     void       *sql_packet_ptr,
				     int4        sql_packet_length,
				     errtext     errtext,
				     comm_error *returncode));

extern void sqlareceive _ANSI_ARGS_((int4        reference,
				     void      **res_packet_ptr,
				     int4       *res_packet_length,
				     errtext     errtext,
				     comm_error *returncode));

#else /* ADABAS_VERSION <= 61 */

extern void sqlaconnect _ANSI_ARGS_((int4        pid,
				     nodeid      servernode,
				     dbname      serverdb,
				     service     service,
				     int4       *reference,
				     errtext     errtext,
				     comm_error *returncode));

extern void sqlarequest _ANSI_ARGS_((int4        reference,
				     packet     *sql_packet,
				     int2        length,
				     errtext     errtext,
				     comm_error *returncode));

extern void sqlareceive _ANSI_ARGS_((int4        reference,
				     packet     *res_packet,
				     int2       *length,
				     errtext     errtext,
				     comm_error *returncode));

#endif

extern void sqlarelease _ANSI_ARGS_((int4 reference));

extern void sqlacancel _ANSI_ARGS_((int4 reference));

extern void sqltermid _ANSI_ARGS_((termid terminalid));

extern void sqlfinit _ANSI_ARGS_((int2     buffer_pool_size,
				  int4    *poolptr,
				  boolean *ok));

/* ----------------------------------------------------------------------- */

extern int  sqlclearuser   _ANSI_ARGS_((void));
extern void sqlputuser     _ANSI_ARGS_((xuser_record *user_params,
					errtext       errtext,
					boolean      *ok));
extern void sqlgetuser     _ANSI_ARGS_((xuser_record *user_params,
					errtext       errtext,
					boolean      *ok));
extern void sqlindexuser   _ANSI_ARGS_((int2          user_index,
					xuser_record  *user_params,
					errtext       errtext,
					boolean      *ok));
extern void sqlxuopenuser  _ANSI_ARGS_((errtext       errtext,
					boolean      *ok));
extern void sqlxucloseuser _ANSI_ARGS_((errtext       errtext,
					boolean      *ok));

/* ----------------------------------------------------------------------- */

extern void sqlarg3 _ANSI_ARGS_((xuser_record *user_params,
				 SQL_PASSWORD  password,
				 args_options *options,
				 xuser_set     xusertype,
				 c40           errtext,
				 boolean      *ok));

/* ----------------------------------------------------------------------- */

#if ADABAS_VERSION >= 62

extern void s82uni_fload _ANSI_ARGS_((encodings_ptr  *encodings,
				      int2           *encoding_cnt,
				      boolean         read_dblang_flag,
				      c18             iso_locale_str,
				      int2           *codeset,
				      uni_load_error *rc));
 
extern void s80uni_trans _ANSI_ARGS_((encodings_ptr   encodings,
				      int2            encoding_cnt,
				      void           *src_ptr,
				      int4            src_len,
				      int2            src_codeset,
				      void           *dest_ptr,
				      int4           *dest_len,
				      int2            dest_codeset,
				      uni_opt_set     trans_options,
				      uni_error      *rc,
				      int4           *err_char_no));

extern void s80uni_error      _ANSI_ARGS_((uni_error      rc, c40 msg));
extern void s82uni_load_error _ANSI_ARGS_((uni_load_error rc, c40 msg));

#endif /* ADABAS_VERSION >= 62 */

/* ----------------------------------------------------------------------- */

extern void s02applencrypt _ANSI_ARGS_((name    pw_clear,
					cryptpw pw_crypt));

extern void s40glint _ANSI_ARGS_((char      *buf,
				  int4       pos,
				  int        len,
				  int4      *dest,
				  num_error *res));

extern void s40glrel _ANSI_ARGS_((char      *buf,
				  int4       pos,
				  int        len,
				  double    *dest,
				  num_error *res));

extern void s41plint _ANSI_ARGS_((char      *buf,
				  int4       pos,
				  int        len,
				  int        frac,
				  int4       source,
				  num_error *res));

extern void s41plrel _ANSI_ARGS_((char      *buf,
				  int4       pos,
				  int        len,
				  int        frac,
				  double     source,
				  num_error *res));

/* ---------------------------------------------------------------------
 * Some stuff for editing with emacs...
 * ---------------------------------------------------------------------
 * Local Variables: 
 * mode: c
 * mode: font-lock
 * End: 
 */
