# ---------------------------------------------------------------------
#  $Id: LinuxHowTo.tcl,v 1.6 1997/07/04 21:23:03 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ---------------------------------------------------------------------

if {[info exists env(EDITION)] && ![string compare $env(EDITION) LE]} {
  set edition "Linux Edition"
  set ed      "LE"
  set edLinux "Linux Edition"
} else {
  set edition "Personal Edition"
  set ed      "PE"
  set edLinux "Personal Edition on Linux"
}

html {
  title "ADABAS D $edLinux - HowTo"
  body bgcolor=white {
    sec "ADABAS D $edLinux - HowTo"

    #    ==============
    ssec "Introduction"
    #    ==============

    switch $ed {
      PE {
	p "Adabas D is a fully relational database, distributed by Software AG.
           It is available for many Unix-Platforms as well as for Windows95/NT.
	   Although Adabas D is capable of handling gigabyte data volumes,
	   there are now free versions of Adabas D available for Windows and
	   Linux, limited to a data volume of 100 Megabytes."

	p "This HowTo tells you everything you should know to install the
	   $edition (from now on called $ed for short) on a Linux System.
	   If you find something important missing or if you know some hints
	   making life easier with Adabas D on Linux, send an email to
           the author (address see below), who will probably insert your
           notes into this paper."
      }
      LE {
	p "Adabas D is a fully relational database, distributed by Software AG.
           It is available for many Unix-Platforms as well as for Windows95/NT.
	   This HowTo tells you everything you should know to install the
	   $edition (from now on called $ed for short)."
      }
    }
    
    p "Here is an overview of the following sections."
    
    p "The first [ref ssec Requirements] describes the minimal equipment of
       your computer and the environment you should create on
       your system before installing the $ed."
    
    p "Then [ref ssec Installation] will describe the installation process and
       tries to give you some clues, what to do in the unlikely case it fails."
    
    p "After this, [ref ssec "Using the RDBMS"] tries to give some hints,
       what to do with the ready-installed database server,
       e.g. administration of the server,
       building an application, using the tools..."
    
    p "Finally, [ref ssec "Trouble shooting"] gives some hints what to do,
       if anything doesn't work the way it should."
    
    #    ==============
    ssec "Requirements"
    #    ==============
    
    p "The requirements to install the $ed successfully are:"
    bullet_list {
        li "You must have a CD-ROM player and the ability to mount the
	    filesystem of the CD."
        li "You should create a special database user and database group"
        li "The environment of all users who want to use the $ed must have
            set the environment variables DBROOT and PATH appropriately."
        li "The upper limit of the size of a shared memory segment must be
            high enough (not a problem for Linux 2.0 or greater)."
    }
    
    #     --------
    sssec "CD-ROM"
    #     --------
    
    p "First of all you need a CD-ROM player.
       Your Linux kernel must have the iso9660
       file system built into or available as a loadable module.
       If you have an empty directory ([path /cdrom], [path /mnt], or the like)
       and the device for your CD-ROM is e.g. [path /dev/scd0] (for a
       SCSI player), then after inserting the Adabas D $ed CD-ROM there should
       be no problem to mount it with
       [br][keyboard "mount -t iso9660 /dev/scd0 /cdrom"][br]
       Perhaps you must be root to do this."

    p "You can do the mount as an ordinary user if there is a line in
       [path /etc/fstab] for your CD-ROM device with the [path user] option.
       Note that turning on the [path user] option automatically sets
       [path noexec]. So be sure to explicitly add the [path exec] option
       for your CR-ROM device or use the [keyboard "-o exec"] option as
       command line argument, to allow execution of programs from this
       file system."
    
    #     ---------------
    sssec "Database user"
    #     ---------------
    
    p "There has to be a user and a group to whom all the installed
       executables and data devices belong. This account cannot be the
       root account, since the database kernel refuses to start if run
       with userid 0."
    
    p "For a single user desktop system it is sufficient to use the
       normal user account and group you always login in. Nevertheless it is
       recommended that you create a user [path adabas] and a group
       [path database]
       (these names aren't fixed, but used everywhere throughout this HowTo).
       Since you must be able to login using this account, you should give
       it a login shell and DBROOT (see below) as home directory."
    
    p "Later on during installation you have to enter the name of the user and
       group into the installation program, which will set the ownership of all
       installed files to this user. (you could as well change the user and
       group owner later using chown, but that's is not the preferred method)"
    
    #     --------
    sssec "DBROOT"
    #     --------
    
    p "You must have a certain amount of free space on your hard disk before
       installing the $ed.
       The minimum disk usage if about 60 MB, as the CD cover says;
       if you want to install the preconfigured database with its data size of
       100MB, (and this is what we recommend), your destination directory must
       be on a partition with at least 130 MB of free disk space."
    
    p "This directory will become the root directory of your Adabas D database;
       we will call it [path DBROOT] from now on.
       For examples in this HowTo we will use [path /usr/local/adabas]
       as [path DBROOT]."
    
    p "To use the database, you must have set the environment variable DBROOT
       pointing to this directory.
       You can add the following line to the file [path /etc/profile]:
       [br][keyboard "DBROOT=/usr/local/adabas; export DBROOT"][br]
       Then for all users this variable is set automatically. If you don't want
       to fiddle with [path /etc] files, you can add this line to the file
       [path .profile] in the homedirectory of every user using Adabas D
       respectively."
    
    #     ------
    sssec "PATH"
    #     ------
    
    p "While we are talking about environment variables, there is one more to
       modify: [path PATH]. All the executable files are stored in the
       subdirectory [path bin] of [path DBROOT], so we recommend to add the
       following line to [path /etc/profile] or [path .profile] (see above):
       [br][keyboard "PATH=[dollar]PATH:[dollar]DBROOT/bin"][br]
       It is much better to put the new directory to the end of the list, since
       this way the X11 program [path /usr/X/bin/xload] will be called instead
       of the database import/export tool [path [dollar]DBROOT/bin/xload] and so
       it won't break existing startup files. The database tool can still be called
       with its second name [path xdbload]."
    
    #     ---------------
    sssec "Shared memory"
    #     ---------------
    
    p "For a Linux system the upper limit of shared data is built into the
       kernel and can't be adjusted within a running system or by means
       of the configuration dialog. It is defined
       as a constant [keyboard SHMMAX] in the kernel sources. The default
       value of [keyboard SHMMAX] and the path of the include file containing
       its definition depends on the Linux kernel version."

    p "For a Linux System prior to 2.0 it is defined in 
       [path /usr/src/linux/include/linux/shm.h] and its value is
       0x400000. Since Adabas needs a litte more even for a system with
       only five users and normal-sized caches, you have to increase
       this limit."

    p "For newer Linux Systems (2.0 or later) it is defined in 
       [path /usr/src/linux/include/asm/shmparam.h] and its value is
       0x1000000. A properly configured database for five users will hardly
       need more than 16MB, so you can live with this default.
       But be aware of the fact that you still have to adjust some
       parameters during the
       installation of an own new database, since the default values
       require more than 16MB (see [ref sssec "Creating your own database"])."

    p "If you have to increase the constant, edit the include file and
       look for a row that starts with [keyboard "[hash]define SHMMAX"].
       Replace the number by e.g. 0x1000000."
    
    p "Creating a new Linux kernel depends on the distribution you use.
       If you are booting with LILO, a call of [keyboard "make zlilo"]
       is all you need. Otherwise a call of [keyboard "make zImage"]
       will create a compressed kernel and you have to install it manually
       after this."
    
    #    ==============
    ssec "Installation"
    #    ==============
    
    p "If your Linux box fulfills all the requirements mentioned above,
       the CD-ROM is mounted, DBROOT and PATH are set, and you know
       the name and password of the database user and the password of the
       [path root] account, you can start to install right now."
    
    p "For installation you should be logged in as the database user (in our
       examples [keyboard adabas]). If you are logged in as a different user,
       you should become the database user by means of the
       [keyboard su] command.
       If you are sitting in front of an X display, you have to allow other
       accounts to connect to your X server by typing the following command
       before issuing the [keyboard su]:[br]
       [keyboard "xhost +[variable myHostName]"]"
    
    p "The installation with a graphical interface can be started by
       [br][keyboard /cdrom/install[amp]][br]
       First you should select the packages to install;
       the default choice (the database software itself and the preconfigured
       example database MYDB) is a good point to start with.
       Then click through the five points in order."
    
    p "Note that there is a small inconvenience in the file selection dialogs,
       you will get into in the first two points. They allow only a selection
       of files (and not directories), so that you can't push the
       [keyboard Okay] button if your [path DBROOT] directory is still empty
       (and probably it is!). You can avoid this by calling [keyboard install]
       with two parameters ([emphasis "source dir"] and [path DBROOT]) like
       this:
       [br][keyboard "/cdrom/install  /cdrom  [dollar]DBROOT[amp]"]"
    
    p "If for any reason no X display is available, you have to issue the
       following commands instead:[br]
       [keyboard /cdrom/install.lnx][br]
       [keyboard x[us]install][br]"
    
    #     ------------------------
    sssec "Creating your own database"
    #     ------------------------
    
    p "Note that if you have installed the preconfigured database MYDB,
       you can skip this section."
    
    p "If you don't want to install the preconfigured database MYDB or if you
       want to create another database, you can do this with the DBA tool
       [path xcontrol]."
    
    p "There are two parameters you must adjust, since the default values
       are of little value."
    bullet_list {
      li "[path DATA[us]CACHE[us]PAGES]: The default of 5000 pages is probably
          overconfigured for a desktop system. The data cache will reside in
          shared memory and 5000 pages are 20MB. The limit for shared memory
	  (SHMMAX) in an unmodified Linux kernel is 4MB or 16MB (see also
	  [ref sssec "Shared memory"]), so you have to decrease this value
          or rebuild your Linux kernel.[br]
	  You can shrink it down to a value of 200, but if you have
	  enough RAM and SHMMAX is big enough, a value between 1000 and
          2000 seems to be better (more cache is always better!)."

      li "[path OPMSG1]: Since there is virtually no linux system with the
          device [path /dev/syscon], you better fill in the name of an
	  existing device or file here (like [path /dev/null] or
	  [path /dev/console])."
    }
    
    #    =================
    ssec "Using the RDBMS"
    #    =================
    
    #     ----------------------------
    sssec "State of a database server"
    #     ----------------------------
    
    p "At every point in time the database server is in one of the following three
       states:"
    definition_list {
      term [bold offline]
      term_definition "The database kernel is not running at all; no resources
                       are occupied. An application trying to connect will
                       answer [path "database not running"]"
      term [bold cold]
      term_definition "The database kernel is running, but will not respond to
                       the normal SQL commands; only some maintenance commands
                       are allowed (notably [keyboard RESTART]). An application
                       trying to open a normal user connection will get the
                       error -8000 ([path "database must be restarted"])."
      term [bold warm]
      term_definition "The database kernel is running, and will respond to the
                       normal SQL commands."
    }
    
    p "The following lines show the Bourne and Tcl shell scripts, you can use to
       start/stop your database, if your database is called [path MYDB], DBROOT
       points to [path /usr/local/adabas] and the control user/password
       combination is [path control,control]."
    p "start.sh:"
    preformatted {
      #!/bin/sh
      x_start MYDB
      xutil -d MYDB -u control,control restart
    }
    p "stop.sh:"
    preformatted {
      #!/bin/sh
      xutil -d MYDB -u control,control shutdown
      x_stop MYDB
    }
    
    p "start.tcl:"
    preformatted {
      #!/usr/local/adabas/bin/adabastclsh
      exec x_start MYDB
      set l [adalogon control,control -serverdb MYDB -service utility]
      adautil   $l restart
      adalogoff $l
      }
    
    p "stop.tcl:"
    preformatted {
      #!/usr/local/adabas/bin/adabastclsh
      set l [adalogon control,control -serverdb MYDB -service utility]
      adautil   $l shutdown
      adalogoff $l
      exec x_stop MYDB
    }
    
    p "Although the tcl solutions are a more keystrokes to type, I prefer
       them, since there are less unix processes used.
       Also you can ask the current state of the database with the tcl command
       [keyboard "adautil [dollar]l state"] and react accordingly to the answer."

    p "The following is an init script for use with the S.u.S.E boot concept
       (starting with version 4.4.3).
       You can put the following lines into a file [path /sbin/init.d/adabas]
       and make soft links to e.g. [path /sbin/init.d/rc3.d/S25adabas] and
       [path /sbin/init.d/rc3.d/K15adabas]. Then the database kernel will get
       automatically started and stopped when you switch into or out of
       runlevel 3."

    preformatted {
#! /bin/sh

. /etc/rc.config

[ -z "$DBROOT" -o -z "$DBUSER" -o \
  -z "$DBNAME" -o -z "$DBCONTROL" ] && exit

export DBROOT DBUSER DBNAME DBCONTROL

case "$1" in
    start)
        echo "Starting Adabas D."
        su $DBUSER -c $DBROOT/bin/adabastclsh << 'EndOfScript'

# ------------- BEGIN StartScript BEGIN -----------------
if [catch {exec $env(DBROOT)/bin/x_start $env(DBNAME)} msg] {
    puts $msg
    exit
}
if [catch {adalogon $env(DBCONTROL) \
              -serverdb $env(DBNAME) -service utility} l] {
    puts $l
    exit
}
if [catch {adautil $l restart} msg] {
    puts $msg
    exit
}
adalogoff $l
# --------------  END  StartScript  END  ----------------

EndOfScript
;;
    stop)
        echo -n "Shutting down Adabas D:"
        su $DBUSER -c $DBROOT/bin/adabastclsh << 'EndOfScript'
    
# -------------- BEGIN StopScript  BEGIN ----------------
if [catch {adalogon $env(DBCONTROL) \
              -serverdb $env(DBNAME) -service utility} l] {
    puts "\n$l"
    exit
}
catch {adautil $l shutdown}
adalogoff $l

if [catch {exec $env(DBROOT)/bin/x_stop $env(DBNAME)} msg] {
    puts "\n$msg"
    exit
}
puts " stopped."
# --------------  END  StopScript   END  ----------------

EndOfScript
;;

      *)
            echo "Usage: $0 {start|stop}"
            exit 1
esac
}

    p "You also have to put something like the following at the end of
       [path /etc/rc.config:]"

    preformatted "
#
# Adabas D $edition (Software AG)
#
# If you want to start Adabas D, the relational database system,
# automatically on system reboot, give values to DBROOT, DBNAME
# DBUSER and DBCONTROL.
#
# DBROOT: The top directory of the Adabas D installation.
#
DBROOT=/usr/local/adabas
#
# DBNAME: The name of the database you want to start at
#         system boottime.
#
DBNAME=MYDB
#
# DBUSER: The name of the unix account, to whom all the
#         Adabas files belong.
#
DBUSER=adabas
#
# DBCONTROL: The connect string of the adabas control user in the
#            form <name>,<password> or ,<userkey>.
#            Example for MYDB: control,control
#
DBCONTROL=control,control
#
    "
    #     ---------------
    sssec "The User file"
    #     ---------------
    
    p "There are at least three users existing in every single database:"
    bullet_list {
      li "The system DBA (data base administrator), the only user who can
          create other users with DBA access. In the preconfigured MYDB
          the user/password combination is [path superdba,admin]."
      li "The control user, who can call the administration tools [path xcontrol],
          [path x[us]param], [path xutil] and [path panel]. In MYDB it is
          [path control,control]."
      li "The domain user, who owns all the system tables and views.
          There should be no need to connect as domain user;
          in MYDB it is [path domain,domain]."
    }
    
    p "The unix user accounts are not related to the database users. But you
       can build a file available only to your unix account containing
       short keys for all the database users you normally use. This file
       is called [path .XUSER], resides in your home directory,
       and can be edited by [path xuser] or [path tkuser]."
    
    p "My user file contains the following entries:[br]
       Userkey DEFAULT for [path krischan,geheim][br]
       Userkey c for [path control,control][br]
       Userkey demo for [path demo,demo][br]
       Userkey sys for [path superdba,admin]"
    
    p "Having this file I can call the tools with the
       [keyboard "-U"] option as shown in the
       following examples. Note, that the last two examples
       are actually the same thing."
    preformatted {
      panel   -Uc
      xquery  -Usys
      fotos   -Udemo
      tkquery -UDEFAULT
      tkquery
    }
    
    #     -----------------------------------------------
    sssec "Embedded SQL in C (for Web Applications, too)"
    #     -----------------------------------------------
    
    p "Every program, that connects to the Adabas database server, needs the
       environment variable [path DBROOT] set. A compiled C program with
       embedded SQL will terminate with the following message on standard error
       when executing the CONNECT statement, if [path DBROOT] is not set:"
preformatted {
sqlinit: DBROOT must be set !!!
}
    p "When a cgi script is called by Apache (or any another Web server),
       there are only a few environment variables available.
       Notably [path DBROOT] isn't in the set of variables, specified by the
       http protocol. You can configure Apache in its http.conf file to
       set an additional variable by means of the [keyboard SetEnv] directive."
preformatted {
SetEnv DBROOT /usr/local/adabas
}

    #     ------
    sssec "ODBC"
    #     ------
    
    p "More to come..."

    #     -----
    sssec "Tcl"
    #     -----
    
    p "More to come..."

    #    ==================
    ssec "Trouble shooting"
    #    ==================
    
    #     -------------------------------------
    sssec "The program install doesn't execute"
    #     -------------------------------------
    
    p "Be sure to mount the CD-ROM with execution of programs from this
       device enabled (by explicitly mentioning the [keyboard "-o exec"]
       option
       or by adding the exec option to the line in [path /etc/fstab].
       See also [ref sssec CD-ROM]."

    switch $ed {
      PE {
	#     ----------------------------------------------------------
	sssec "The graphical install program hangs while extracting the archives"
	#     ----------------------------------------------------------

	p "After starting step 3 of the installation (extraction of
	   the software archives), a window with the progress display
	   pops up, but its value stays at [keyboard 0[pct]] all the time."

	p "The problem occurs, if your [keyboard tar] program gives the
	   date of a file in the form [keyboard yyyy-mm-dd] and not separated
	   by blanks. This seems to be the case in newer Caldera systems.
	   There is no workaround; you have to use [keyboard install.lnx]
	   and [keyboard x[us]install] (see [ref ssec "Installation"])."
      }
    }

    #     ---------------------------
    sssec "Cannot read param file..."
    #     ---------------------------

    p "The configuration parameters are stored in a directory tree, starting
       at [path /usr/spool/sql]. This directory seems to be missing.
       Maybe you moved your database from one computer to another be simply
       copying [path [dollar]DBROOT], maybe you removed the directory by
       means of the [keyboard rm] command. Most probably step 4 of the
       installation process (call of the postinstallation script
       [path x[us]install]) wasn't finished properly.
       This is a hard to see, since the xterm closes immediately,
       when the installation script terminates,
       so that an error message is visible only a very short time."

    p "To fix this problem, simply call [keyboard x[us]install] as superuser."

    #     ------------------------------
    sssec "Cannot create rundirectory 0"
    #     ------------------------------
    
    p "This is a problem of unix user permissions. The configuration parameters
       are stored in [path /usr/spool/sql/config]; this file must be readable by
       the program reporting this error (probably [path xcontrol], [path panel]
       or [path x[us]start])."
    
    p "The program which investigates one configuration parameter
       ([path [dollar]DBROOT/pgm/getparam]) simply returns [path 0],
       if it can't find or read this file.
       But you can't create a directory [path 0]..."
    
    p "The bottom line is that you should call these programs only as the user
       who was mentioned to [path x[us]install] during installation.
       See also [ref sssec "Database user"]."
    
    #     ---------------------------------------------
    sssec "sqlinit: cannot find user name for uid xxx!"
    #     ---------------------------------------------
    
    p "If all the programs of Adabas D report this error, there is an error
       in your [path /etc/passwd] (most probably a missing colon).
       Note that the invalid line doesn't have to be the database user or the
       current login; any error in any line will get Adabas to complain."

    p "If your account is registered in the yellow pages of the NIS service,
       you will get the same error. Currently there seems to be no
       workaround other than to insert your account into the local
       [path /etc/passwd]."

    #     -------------------------
    sssec "Cannot open /dev/syscon"
    #     -------------------------
    
    p "This isn't really an error. Whenever you create a new database, the
       default value for the kernel parameter [path OPMSG1] is set to
       [path /dev/syscon]. If the file can't be opened, the messages wouldn't
       be printed. Since they go into the kernel diag file anyway, this isn't
       that bad (see also [ref sssec "Creating your own database"])."
    
    p "To avoid this message, enter [path /dev/null] as [path OPMSG1],
       in the [keyboard "Install Serverdb"] or
       [keyboard "Configuration/Alter Parameters/Kernel"] dialog."
    
    #     ---------------------------------
    sssec "The kernel dies while starting."
    #     ---------------------------------
    
    p "Please look at the kernel diagnose file (in Panel with F2, or with
       a normal text editor at e.g. [path /usr/local/adabas/wrk/MYDB/knldiag]).
       There should be a message about the reason of the abort a few lines
       above the end of the file."
    
    p "Most probably your shared memory has a limit that is smaller than the
       wanted segment size (see [ref sssec "Shared memory"] for this)."

    p "If there is a line in [path knldiag] complaining about a too small
       value of shareddynpool, most probably something went wrong with
       [keyboard x[us]param] during the configuration of the new database
       (see [ref sssec "param dumps core"] below)."

    switch $ed {
      PE {
	#     ---------------------------------------------
	sssec "unknown service 'sql30' (see /etc/services)"
	#     ---------------------------------------------
    
	p "One limitation of the Personal Edition is that you can't access
	   databases on remote hosts. You need some additional software for
	   this, i.e. a server listening to port [path sql30].
	   So there is no use in adding a line to [path /etc/services]."

	p "To avoid this error, be sure to give no [path -n] option, don't put
	   a hostname into the [path -d] option and leave the
	   [path "server node"] entry in the user file empty."
      }
    }
    
    #     ----------------------------------------
    sssec "The GUI tools terminate with an error."
    #     ----------------------------------------
    
    p "There are (at least) three reasons for these programs to fail."
    bullet_list {
      li "The [path DISPLAY] variable is not or incorrectly set;
	  set the environment variable [path DISPLAY] to contain the name
          of your computer followed by [keyboard :0]."

      li "The access to the display isn't granted. Use the [path xhost]
          program to allow access from your computer."
    
      li "The [path PATH] variable must contain [path [dollar]DBROOT/bin]
          (see [ref sssec PATH]).
          It isn't sufficient to call the tools with an absolute path name
          without setting the [path PATH], since they internally call
          an interpreter program located in [path [dollar]DBROOT/bin]."
    }

    #     -----------------------------------------
    sssec "Error -8000 while loading system tables"
    #     -----------------------------------------

    p "This error seems to occur only on newly installed Caldera Systems.
       When you create a new database with [keyboard xcontrol], this error
       may occur during the loading of the system tables. Simply enter
       [path xcontrol] again, select [keyboard Operation../Restart../Warm]
       and finally start [keyboard "Configuration../Load System Tables"]."
       
    #     ------------------
    sssec "param dumps core"
    #     ------------------

    p "The section title is a little misleading: this error also
       occurs when you don't call [keyboard x[us]param] yourself, since
       [keyboard xcontrol] starts [keyboard x[us]param] behind the scenes
       while installing the configuration parameters."

    p "When you create a new database with [keyboard xcontrol] and choose
       the [keyboard Stepwise] option, a screen with some values for e.g.
       SHMMAX should appear after the installation of the parameters.
       If instead a nearly blank screen will be displayed,
       [keyboard x[us]param] didn't finish its work.
       Although [keyboard xcontrol] gives you the option to continue, you
       should cancel the installation, since the database kernel will
       refuse to start anyway with a line in knldiag saying something like:[br]
       [keyboard "WARNING: shareddynpool too small in XPARAM"]."

    p "As it seems this error only occurs when [keyboard xcontrol]
       was started in in a shell with a huge environment (i.e. there are
       lots of environment variables with long values).
       To prevent this error inspect your environment by means of the
       unix command [keyboard env] and unset some environment variables
       with e.g. [keyboard "unset TERMCAP"]."

    #    =============
    ssec "Bug reports"
    #    =============

    switch $ed {
      PE {
        link krischan krischan@cs.tu-berlin.de mailto:krischan@cs.tu-berlin.de
	link adalux   adalux@sql.de            mailto:adalux@sql.de
	link adanews  comp.databases.adabas    news:comp.databases.adabas

	p "Comments, suggestions, etc. concerning this HowTo should be mailed
           to [br][link krischan]"

	p "Everything concerning the Adabas D Personal Edition on Linux itself
	   should be posted to [link adanews] if of general enough nature.
	   You can send an email to [link adalux] if you have a special question.
	   But note that due to its cost-free nature the Personal Edition is not
	   supported by Software AG."

	p "Have fun, Krischan"

	p "Christian Krone[br][link krischan]"
      }
      LE {
	link sag http://www.sag.de/linux1.htm http://www.sag.de/linux1.htm

	p "Should you encounter serious problems, please see [link sag]
	   to order support and upgrade service."
      }
    }
  }
}
