# ---------------------------------------------------------------------
#  $Id: README.tcl,v 1.9 1997/07/06 22:03:15 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ---------------------------------------------------------------------

html_start
title "AdabasTcl 1.0 - TCL interface to the ADABAS D database server"

#    ====================
ssec "What is AdabasTcl?"
#    ====================

p "AdabasTcl is an extension to TCL (Tool Command Language), that
   provides access to an ADABAS D database server of Software AG.
   AdabasTcl adds additional Tcl commands that connect to a database,
   pass SQL code, read results, etc.
   AdabasTcl was inspired by similar extensions for other database
   servers, notably oratcl by Tom Poindexter."

p "There are also four TK (ToolKit) applications, that provide the
   access to the database in the X11 environment with the motif look
   and feel. You can run them on a windows system, too."
definition_list {
  term [bold panel]
  term_definition "A tool for driving the database server (the traffic light)."
  term [bold tkquery]
  term_definition "A tool for interactive SQL queries."
  term [bold tkuser]
  term_definition "A tool for setting default attributes for user keys."
  term [bold fotos]
  term_definition "A application to demonstrate the capability to display
                   pictures out of LONG columns."
}
p "These applications can be started as Tclets inside the Netscape
   brower, too."

p "Last but not least there is an extension module for perl, which makes
   it possible to access Adabas D from Perl."

p "Copyright (c) 1996-1997 Christian Krone. All rights reserved.[br]
   This program is free software; you can redistribute it and/or
   modify it under the same terms as Tcl itself.[br]
   See also licence.terms"

#    =============================
ssec "What's new in this release?"
#    =============================
bullet_list {
  li "lots of bug fixes;"
  li "smoother installation on more Unix systems and on Windows 95/NT;"
  li "compatiblitiy with Tcl8.0 (inclusive use of the new Tcl objects!);"
  li "the perl extension is not so hidden anymore;"
  li "Netscape plugin support;"
  li "visible improvements in TkQuery:"
      bullet_list {
	li "A new resizer handle between the sql window and the result window."
	li "New tree widget for selecting stored commands."
	li "New [dq "explorer like"] DB Objects window, where on the left the user
	    can navigate in a tree with all objects, and on the right
            details of the selected objects are displayed."
      }
}
p "See the file [path changes] for details."

#    ==============
ssec "Requirements"
#    ==============

set  tclFtp ftp://ftp.smli.com/pub/tcl
link ftpTcl7.6 $tclFtp/tcl7.6p2.tar.gz   $tclFtp/tcl7.6p2.tar.gz
link ftpTk4.2  $tclFtp/tk4.2p2.tar.gz    $tclFtp/tk4.2p2.tar.gz
link sunscript http://sunscript.sun.com/ http://sunscript.sun.com/

p "Since AdabasTcl is an extension to TCL, you should already have TCL,
   or be prepared to get it via ftp.
   To use the feature of dynamically loading the AdabasTcl extension
   into the TCL interpreter (tclsh), you must have TCL version 7.5.
   The tk applications need the installed TK widget set version 4.1."
definition_list {
  term Tcl7.6; term_definition [link ftpTcl7.6]
  term Tk4.2;  term_definition [link ftpTk4.2]
}
p "It will work also with Tcl7.5/Tk4.5 or Tcl/Tk8.0"

p "Of course, you must also have access to an ADABAS D databaser server.  
   AdabasTcl must be linked with the Adabas D precompiler libraries.
   I've linked and tested it with a server version 6.1 and version 6.2
   on different flavours of Unix (mostly Linux, Unixware, Sun and HP9)
   and on Windows 95 and NT/4.0."

p "If you want to work with the perl extension, you must have perl5.003
   installed. For using the Tclets, you must have the Tcl plugin version
   2.0a2 (or above?) and Tcl/Tk version 8.0a2 (or above) installed.
   All this (and more!) you can get at [link sunscript]."

#    ==============
ssec "Installation"
#    ==============

p "To configure, compile and install AdabasTcl, you have to go through
   the following approximately 3 steps."
number_list {
  li "First start [keyboard ./configure] in this directory.
      You have a good chance, that this will work out all the options
      for your machine correctly.
      If it stops or determines invalid values for some of its
      variables, you can tune it with options on its command line;
      here are some examples:[br]
      [keyboard "./configure --with-tclinclude=/usr/local/include"][br]
      [keyboard "./configure --with-adabas=6.1 --without-x"][br]
      An extensive list of all options is available by
      [keyboard "./configure --help"].
      After this you could (but don't have to) inspect the Makefiles;
      the most important one is located in the extension subdirectory.
      See also Porting Notes below."

  li "If you want to compile the perl extension, be sure to give the
      [keyboard --with-perl] option."

  li "Then a call of [keyboard make] should build all targets in all the
      subdirectories. If something went wrong, most likely some
      variables in the Makefile needs more attention. Again, see Porting
      notes below."

  li "It is important to have the environment variable [path LD[us]LIBRARY[us]PATH]
      point to [path [dollar]DBROOT/lib], if there are shared libraries of
      Adabas D (e.g. [path libsqlrte.so] or [path libsqlptc.so])."

  li "There exists a [keyboard "make test"] target in the [path extension] and
      [path perl/Adabas] subdirectories, which (after building the extension)
      calls a test file and displays the result."

  li "If all went well, a call of [keyboard "make install"] installs
      the extension plus the applications and their help pages."

  li "How to use the Tclets from inside Netscape, can be read as the
      following URL: [path file:[cgi_variable DBROOT]/tcl/plugin/index.html]."
}

#    ===============
ssec "Porting Notes"
#    ===============

p "This package has been compiled and tested on the following platforms:"
definition_list {
  term Linux
  term_definition "With ELF Kernel it should compile out of the box
                   (one of the development platforms). This is currently
                   the only platform, where the perl extension is
                   tested."
  term "Unixware 2.1"
  term_definition "Without any problem (the other development platform)."
  term "SCO V4.2"
  term_definition "No dynamic loading and no X, but adabastclsh runs okay
                   (former development platform)."
  term "DEC Unix 3.2"
  term_definition "No problems."
  term HP-UX
  term_definition "I had to use the following call of make to get it
                   compiled.[br]
                   [keyboard "make CC=c89"][br]
		   With earlier version a loading of Adabastcl.sl wasn't
                   possible, because there was not enough memory
                   (that's, what the loader said!). So there should be
                   the [keyboard --disable-load] option present in the call of
                   [keyboard configure]. This bug doesn't occur lately, but I
                   don't know, if it is gone forever..."
  term "SUN[us]OS 5.5.1"
  term_definition "I had to set the LIBS variable to [keyboard -lcurses] to get
		   configure running."
  term Windows95/NT
  term_definition "See section Windows below."
}

#    =========
ssec "Windows"
#    =========

p "For configuration, compilation and installation you can call the
   Tk program [path makeVC.tcl]. There you can customize the mentioned
   configuration variables. After this a click of the button [keyboard Make]
   should build and install everything."
p "It is tested with VC++ (not Borland!). If you have the precompiled
   version of Tcl/Tk, you need the vc libs, which should be available at
   the same ftp sides, where you got Tcl/Tk. In Tcl8.0b1 or later they
   are part of the normal distribution as [path .../TCL/lib/tcl80vc.lib]
   and [path .../TCL/lib/tk80vc.lib]. This are the locations, where they are
   expected even with older versions."
p "You have to create icons and/or shortcuts for the tk appls in
   [keyboard [dollar]DBROOT/bin] manually."
p "With the Windows95 PE 6.1 there is a bug, that every application
   reports an invalid instruction on exiting."

#    =============
ssec "Bug reports"
#    =============

link krischan mailto:krischan@cs.tu-berlin.de mailto:krischan@cs.tu-berlin.de
link adanews  news:comp.databases.adabas      news:comp.databases.adabas
link tclnews  news:comp.lang.tcl              news:comp.lang.tcl

p "Comments, suggestions, bugs reports, et.al., should be mailed to me
   [link krischan] or posted to [link tclnews] or
   [link adanews] if general enough nature."

p "Please always include:"
bullet_list {
  li "version of AdabasTcl"
  li "version of Tcl and Tk"
  li "version of Adabas D server"
  li "version of your operating system"
  li "samples of SQL or AdabasTcl code causing problems"
  li "relevant database table definitions, views, procedures"
  li "version of perl, (if you have a problem with the perl extension)"
}

p "Have fun, Krischan"

p "Christian Krone[br]
   Varziner Str. 12[br]
   D-12161 Berlin[br]
   [link krischan]"

html_end
