
# ---------------------------------------------------------------------
# $Id: cgi2plain.tcl,v 1.3 1997/06/08 20:51:54 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ---------------------------------------------------------------------

# Here we have to reimplement all these procs, that generate
# output directly...

proc cgi_html_start {} {
  global _cgi
  if [info exists _cgi(html_in_progress)] return
  set _cgi(html_in_progress) 1
}

proc cgi_html_end {} {
  global _cgi
  unset _cgi(html_in_progress)
}

proc cgi_anchor_name {name} {
}
proc cgi_url {display args} {
  return $display
}
proc cgi_br {args} {
  return "\n"
}

proc cgi_p {args} {
  regsub -all "\n *\n" [lindex $args end] "\n" line
  puts "   $line\n"
}

proc cgi_li {args} {
  global _cgi

  if ![string compare $_cgi(enumerator) -] {
    set enum -
  } else {
    set enum [incr _cgi(enumerator)].
  }
  regsub -all "\n *\n" [lindex $args end] "\n" line
  puts "   $enum $line"
}

proc cgi_number_list {args} {
  global _cgi

  set _cgi(enumerator) 0

  puts ""
  cgi_close_proc_push {puts ""}

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_bullet_list {args} {
  global _cgi

  set _cgi(enumerator) "-"

  puts ""
  cgi_close_proc_push {puts ""}

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_term {s} {
    global _cgi_termDef

    append s :
    set _cgi_termDef(term,[incr _cgi_termDef(cnt)]) $s
    set thisLen [string length $s]
    if $thisLen>$_cgi_termDef(termLen) {set _cgi_termDef(termLen) $thisLen}
}
proc cgi_term_definition {s} {
    global _cgi_termDef

    regsub -all "\n *\n" $s "\n" _cgi_termDef(def,$_cgi_termDef(cnt))
}
proc cgi_definition_list {args} {
    global _cgi_termDef

    set _cgi_termDef(cnt)     0
    set _cgi_termDef(termLen) 0

    uplevel [lindex $args end]

    for {set i 1} {$i <= $_cgi_termDef(cnt)} {incr i} {
	cgi_put [format "   %-*s " $_cgi_termDef(termLen) \
				   $_cgi_termDef(term,$i)]
	puts $_cgi_termDef(def,$i)
    }
    puts ""
}

proc cgi_preformatted {s} {
  puts [string trim $s]
}

proc cgi_lt {} {return "<"}
proc cgi_gt {} {return ">"}

proc cgi_bold	    {s} {return "$s"}
proc cgi_italic     {s} {return "$s"}
proc cgi_underline  {s} {return "$s"}
proc cgi_typewriter {s} {return "'$s'"}
proc cgi_emphasis   {s} {return "$s"}
proc cgi_strong	    {s} {return [bold $s]"}
proc cgi_sample     {s} {return [typewriter $s]}
proc cgi_keyboard   {s} {return [typewriter $s]}
proc cgi_variable   {s} {return [emphasis   $s]}

proc h1 {s} {regsub -all . $s * line; puts "\n   $s\n   $line\n"}
proc h2 {s} {regsub -all . $s = line; puts   "   $s\n   $line\n"}
proc h3 {s} {regsub -all . $s - line; puts   "   $s\n   $line\n"}
proc h4 {s} {puts "$s\n"}

proc cgi_figure {args} {
}

proc cgi_img {name} {
}

proc cgi_title {title} {
}

rename puts fprint
proc puts {args} {
  if {![string compare [lindex $args 0] -nonewline]} {
    set newline ""
    set args [lrange $args 1 end]
  } else {
    set newline "\n"
  }
  set text [lindex $args end]
  regsub -all  $text ae text
  regsub -all  $text oe text
  regsub -all  $text ue text
  regsub -all  $text Ae text
  regsub -all  $text Oe text
  regsub -all  $text Ue text
  regsub -all  $text ss  text
  fprint -nonewline "$text$newline"
}

proc cgi_table {args} {
  uplevel [lindex $args end]
}

proc cgi_caption {args} {
  global _cgi
  set _cgi(caption) [lindex $args end]
}

proc cgi_table_row args {
  global _cgi

  set _cgi(tabCol#)   0
  set _cgi(tabIsHead) 0

  cgi_close_proc_push {
    global _cgi
    puts \\\\
    if {$_cgi(tabIsHead)} {
      cgi_put \\hline
    }
  }
  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_table_head args {
  global _cgi

  foreach a [lrange $args 0 [expr [llength $args]-2]] {
    regexp "^colspan=(.*)" $a dummy colspan
  }
  if {$_cgi(tabCol#)} {
    cgi_put &&
  }
  incr _cgi(tabCol#)
  set _cgi(tabIsHead) 1

  if {[info exists colspan]} {
    cgi_put "\\multicolumn{$colspan}{|l|}{\\textbf{"
    cgi_close_proc_push "puts }}"
  } else {
    cgi_put "\\textbf{"
    cgi_close_proc_push "puts }"
  }
  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_table_data args {
  global _cgi

  foreach a [lrange $args 0 [expr [llength $args]-2]] {
    regexp "^colspan=(.*)" $a dummy colspan
  }
  if {$_cgi(tabCol#)} {
    cgi_put &&
  }
  incr _cgi(tabCol#)
  if {[info exists colspan]} {
    cgi_put "\\multicolumn{$colspan}{l|}{"
    cgi_close_proc_push "puts }"
  } else {
    cgi_close_proc_push ""
  }
  uplevel [lindex $args end]
  cgi_close_proc
}
