
# ---------------------------------------------------------------------
#  LAST EDIT: Mon Nov 11 21:13:01 1996 by Adabas D Database (gutamil.v12-berlin.de!adabas) 
# $Id: cgi2tex.tcl,v 1.8 1997/06/08 20:52:41 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1996 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ---------------------------------------------------------------------

# Here we have to reimplement all these procs, that generate
# output directly...

proc cgi_html_start {} {
  global _cgi _cgi_lang
    
  if [info exists _cgi(html_in_progress)] return
  set _cgi(html_in_progress) 1

  puts "\\documentclass\[11pt,titlepage,twoside]{article}"
  if ![string compare $_cgi_lang deu] {
    puts "\\usepackage\[germanb]{babel}"
    puts "\\selectlanguage{german}"
  }
  puts "\\usepackage\[dvips]{epsfig}"
  puts "\\parindent0mm \\textheight230mm \\textwidth155mm "
  puts "\\oddsidemargin0cm \\evensidemargin0cm \\voffset-2cm"
  puts "\\renewcommand{\\bottomfraction}{0.6}"
  puts "\\setcounter{secnumdepth}{2}\\setcounter{tocdepth}{2}"
  puts "\\begin{document}"
}

proc cgi_html_end {} {
  global _cgi
  unset _cgi(html_in_progress)

  puts "\\end{document}"
}

proc cgi_anchor_name {name} {
  puts "\\label{$name}"
}
proc cgi_url {display args} {
  set buf "\\ref{[lindex $args 0]}"
  return "$buf ($display)"
}
proc cgi_br {args} {
  return "\\\\"
}

proc cgi_p {args} {
  if {[llength $args] > 1} {
    switch [lindex $args 0] {
      align=center {
	puts "\\begin{center}"
	cgi_close_proc_push "puts \\\\end{center}"
      }
      align=right {
	puts "\\begin{flushright}"
	cgi_close_proc_push "puts \\\\end{flushright}"
      }
      align=left {
	puts "\\begin{flushleft}"
	cgi_close_proc_push "puts \\\\end{flushleft}"
      }
      default {
	cgi_close_proc_push "puts {}"
      }
    }
  } else {
    cgi_close_proc_push "puts {}"
  }
  puts [lindex $args end]
  cgi_close_proc
}

proc cgi_body {args} {
    uplevel [lindex $args end]
}

proc cgi_li {args} {
  puts "\\item [lindex $args end]"
}

proc cgi_number_list {args} {
  puts "\\begin{enumerate}"
  cgi_close_proc_push "puts \\\\end{enumerate}"

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_bullet_list {args} {
  puts "\\begin{itemize}"
  cgi_close_proc_push "puts \\\\end{itemize}"

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_term            {s} {puts "\\item\[$s]"}
proc cgi_term_definition {s} {puts "$s "}
proc cgi_definition_list {args} {
  puts "\\begin{description}"
  cgi_close_proc_push "puts \\\\end{description}"

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_preformatted {s} {
  puts "\\begin{verbatim}$s\\end{verbatim}"
}

proc cgi_lt     {} {return "\\ensuremath{<}"}
proc cgi_gt     {} {return "\\ensuremath{>}"}
proc cgi_amp    {} {return "\\&"}
proc cgi_dollar {} {return "\\$"}
proc cgi_us     {} {return "\\_"}
proc cgi_hash   {} {return "\\#"}
proc cgi_pct    {} {return "\\%"}

proc cgi_bold	    {s} {return "\\textbf{$s}"}
proc cgi_italic     {s} {return "\\textit{$s}"}
proc cgi_underline  {s} {return "\\underline{$s}"}
proc cgi_typewriter {s} {return "\\texttt{$s}"}
proc cgi_emphasis   {s} {return "\\emph{$s}"}
proc cgi_strong	    {s} {return [bold $s]"}
proc cgi_sample     {s} {return [typewriter $s]}
proc cgi_keyboard   {s} {return [typewriter $s]}
proc cgi_variable   {s} {return [emphasis   $s]}

proc h1 {s} {puts "\\chapter{$s}"}
proc h2 {s} {puts "\\newpage\\section{$s}"}
proc h3 {s} {puts "\\subsection{$s}"}
proc h4 {s} {puts "\\subsubsection{$s}"}

proc cgi_figure {args} {
  foreach a [lrange $args 0 [expr [llength $args]-2]] {
    regexp "^caption=(.*)" $a dummy caption
    regexp "^label=(.*)"   $a dummy label
  }
  puts "\\begin{figure}\[htb]"
  puts [lindex $args end]
  if {[info exists caption]} {
    puts "\\caption{$caption}"
  }
  if {[info exists label]} {
    puts "\\label{$label}"
  }
  puts "\\end{figure}"
}

proc cgi_img {name} {
  return "\\begin{center}\\epsfig{figure=$name}\\end{center}"
}

proc cgi_title {title} {
  puts "\\vspace{2cm}"
  puts "\\begin{center}\\Huge $title\\end{center}"
  puts "\\vspace{2cm}"
}

proc cgi_toc {} {
  puts "\\newpage\\tableofcontents"
}

rename puts fprint
proc puts {args} {
  if {![string compare [lindex $args 1] -nonewline]} {
    set newline ""
    set args [lrange $args 1 end]
  } else {
    set newline "\n"
  }
  set text [lindex $args end]
  regsub -all  $text "{\\\"a}" text
  regsub -all  $text "{\\\"o}" text
  regsub -all  $text "{\\\"u}" text
  regsub -all  $text "{\\\"A}" text
  regsub -all  $text "{\\\"O}" text
  regsub -all  $text "{\\\"U}" text
  regsub -all  $text "{\\ss}"  text
  regsub -all {\\&\\&}  $text {\&}   text
  fprint -nonewline "$text$newline"
}

proc cgi_table {args} {

  cgi_put "\\begin{table}\\begin{center}\\begin{tabular}{|l|l|l|l|l|}\\hline"
  cgi_close_proc_push {
    puts \\hline\\end{tabular}
    global _cgi
    if {[info exists _cgi(caption)]} {
      puts $_cgi(caption)
      unset _cgi(caption)
    }
    puts \\end{center}\\end{table}
  }

  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_caption {args} {
  global _cgi
  set _cgi(caption) "\\caption{[lindex $args end]}"
}

proc cgi_table_row args {
  global _cgi

  set _cgi(tabCol#)   0
  set _cgi(tabIsHead) 0

  cgi_close_proc_push {
    global _cgi
    puts \\\\
    if {$_cgi(tabIsHead)} {
      cgi_put \\hline
    }
  }
  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_table_head args {
  global _cgi

  foreach a [lrange $args 0 [expr [llength $args]-2]] {
    regexp "^colspan=(.*)" $a dummy colspan
  }
  if {$_cgi(tabCol#)} {
    cgi_put &&
  }
  incr _cgi(tabCol#)
  set _cgi(tabIsHead) 1

  if {[info exists colspan]} {
    cgi_put "\\multicolumn{$colspan}{|l|}{\\textbf{"
    cgi_close_proc_push "puts }}"
  } else {
    cgi_put "\\textbf{"
    cgi_close_proc_push "puts }"
  }
  uplevel [lindex $args end]
  cgi_close_proc
}

proc cgi_table_data args {
  global _cgi

  foreach a [lrange $args 0 [expr [llength $args]-2]] {
    regexp "^colspan=(.*)" $a dummy colspan
  }
  if {$_cgi(tabCol#)} {
    cgi_put &&
  }
  incr _cgi(tabCol#)
  if {[info exists colspan]} {
    cgi_put "\\multicolumn{$colspan}{l|}{"
    cgi_close_proc_push "puts }"
  } else {
    cgi_close_proc_push ""
  }
  uplevel [lindex $args end]
  cgi_close_proc
}
