# -------------------------------------------------------------------------
#  $Id: fotos.tcl,v 1.11 1997/07/06 22:04:06 adabas Exp $
# -------------------------------------------------------------------------
# Copyright (c) 1996 - 1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# -------------------------------------------------------------------------

html {

title "Fotos - displaying pictures out of LONG columns"

#   ----------
sec "Synopsis"
#   ----------

p [path "fotos \[-n [variable dbnode]\] \[-d [variable dbname]\] \
               \[-u [variable user],[variable passwd]\] \
               \[-U [variable xuserKey]\]"]

#   ---------
sec "Options"
#   ---------

definition_list {
  term [path -n]
  term_definition "database node (default=local);"
  term [path  -d]
  term_definition "database name (default=DBNAME);"
  term [path  -u]
  term_definition "name and password of user;"
  term [path  -U]
  term_definition "name of xuser key."
}

#   --------------
sec "Introduction"
#   --------------

p "When starting up the application, the user have to give the connect data
   by filling in the forms of the connect window or using the command line
   options. If every thing is ok, a small window called Fotos is displayed.
   At the top of the window is a title, which shows the name of the picture.
   The most space is occupied by the picture itself, at the bottom there is
   a row with five buttons to control the application."

definition_list {
  term [keyboard [lt][lt]]
  term_definition "Show first picture    (also [keyboard Home]        key)."
  term [keyboard [lt]]
  term_definition "Show previous picture (also [keyboard "Page Up"]   key)."
  term [keyboard Quit]
  term_definition "Terminate application (also [keyboard F3]          key)."
  term [keyboard [gt]]
  term_definition "Show next picture     (also [keyboard "Page Down"] key)."
  term [keyboard [gt][gt]]
  term_definition "Show last picture     (also [keyboard End]         key)."
}

p "By pressing the right mouse button anywhere above the picture, you get
   a popup menu with some additional commands and options to choose."

p "[func Help] creates a window of its own, in which you can read
   this manual. This function is also available by pressing F1."

p "The four command [func Select], [func Import], [func Export] and
   [func Delete] are for maintaining the [path fotos] table."

bullet_list {
  li "[func Select] pops up a scollable list containing the names of all
      stored pictures. You can select a name by moving the active element
      with your up and down arrow keys or by clicking on a name with
      your mouse pointer. A click on [func Okay] or a double click of the
      left mouse button starts the displaying of the associated picture."

  li "[func Import] pops up a file selection box, where you can select
      a file (which should contain GIF or PPM data). It has an
      additional entry [screen "Name of picture"], where you can put the
      title of the picture. If you omit this name, the basename of the
      imported file will become the title of the picture."

  li "[func Export] pops up a file selection box, where you can select
      a name of the file, into which the GIF data should be stored."

  li "[func Delete] deletes the current picture, not after asking the
      user for confirmation."
}

p "While the red square near the [func DiaShow] button is activated (red),
   every once in a while a new picture is automatically displayed.
   The time span, before the next picture is loaded, is adjustable by
   the [func Refresh] cascade menu."

#   -------
sec "Notes"
#   -------

p "The connected user must have access to a table [path fotos] with the
   following definition:"
preformatted {
  CREATE TABLE fotos (
    name CHAR(20) KEY,
    foto LONG BYTE
  )
}

p "The LONG column must contain valid GIF or PPM data."

p "If the tables doesn't exist, the user will be asked, if it should be
   created and filled with a first picture (the waving Adabas D man)."

#   -----------------------
sec "Environment variables"
#   -----------------------

definition_list {
  term [path SERVERDB]
  term_definition "The default Adabas D server name. If not set, the
                   variable [path DBNAME] is inspected also."
  term [path ADABASTCL[us]DIR]
  term_definition "The directory to look for the startup scripts;
                   also the init value for the global Tcl variable
                   [path adabastcl[us]library]."
}

#   -------
sec "Files"
#   -------

definition_list {
  term [path [dollar]HOME/.XUSER]
  term_definition or
  term [path [dollar]HOME/.XUSER.62]
  term_definition "The xuser file to look for connect parameters."
}

#   ------
sec "Bugs"
#   ------

bullet_list {
  li "There should be a command to drop the whole table."
}

#   --------
sec "Author"
#   --------

p "Christian Krone, Berlin. Version 1.0, July 1997."
p [path krischan@cs.tu-berlin.de]

}
