# ---------------------------------------------------------------------
#  $Id: panel.tcl,v 1.13 1997/07/06 22:04:15 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ---------------------------------------------------------------------

html {

title "Panel - A small tool for driving an Adabas D Server"

#   ----------
sec "Synopsis"
#   ----------

p [path "panel \[-n [variable dbnode]\] \[-d [variable dbname]\] \
               \[-u [variable user],[variable passwd]\] \
               \[-U [variable xuserKey]\]"]

#   ---------
sec "Options"
#   ---------

definition_list {
  term [path -n]
  term_definition "database node (default=local);"
  term [path  -d]
  term_definition "database name (default=[dollar]SERVERDB);"
  term [path  -u]
  term_definition "name and password of user;"
  term [path  -U]
  term_definition "name of xuser key."
}

#   --------------
sec "Introduction"
#   --------------

p "When starting up the application, the user have to give the connect data
   by filling in the forms of the connect window or using the command line
   options. If every thing is ok, a small window called Panel is displayed.
   In its center there is the picture of a traffic light and each of the
   bulbs of it corresponds to a state of the database server."

definition_list {
  term RED
  term_definition "database server is offline."
  term YELLOW
  term_definition "database server is cold."
  term GREEN
  term_definition "database server is warm."
}

p "The current state of the Adabas Server is tested and the traffic light
   will show the corresponding color."

p "To interact with the panel, the user can click on any of the bulbs or
   on the area (in the bottom right corner), where the words [screen Info],
   [screen Help] or [screen Quit] are displayed."

p "When clicking on a light, the database server will change its current
   state into the state, which corresponds to the clicked light.
   When clicking on [screen Info], the [dq "Info Sheet"] pops up
   (see [ref ssec "Info Sheet"]).
   When clicking on [screen Help], a window pops up, in which you can read
   this manual. This function is also available by pressing [func F1].
   When clicking on [screen Quit], the panel terminates after asking the user,
   if the database server should be stopped, too."

p "If the database server reports an error, while changing its state from offline
   into cold, the error messages are displayed in the top left corner of the
   panel. If there is additional information in the kernel diagnose file,
   the word [screen Info] will be replaced by the blinking word [screen Diag].
   A mouse click on the word will bring up a window containing the
   kernel diagnose file. You can read this file at any time (even if no error
   occured) by pressing [func F2]."

p "By pressing the right mouse button anywhere above the picture you get a
   popup menu with some additional commands and options to choose."

#    ------------
ssec "Info Sheet"
#    ------------

p "The menu entry [func "Info Sheet"] (or a click on the [screen Info]
   region of the panel) creates an own window, that displays statistics
   about the serverdb in a [prog control] like manner. There are three
   [dq thermometers] for data pages, log pages and user sessions and below
   some numbers like [screen "Logical Reads"]. The displayed values will
   get updated every once in a while, the user can adjust the time span
   by means of the cascade menu [func Refresh]."

#   -------
sec "Notes"
#   -------

p "Panel can only connect to a local database; it is not a tool for
   driving a remote database server."

p "There should be an option to start a slow or quick database kernel."

#   -----------------------
sec "Environment variables"
#   -----------------------

definition_list {
  term [path SERVERDB]
  term_definition "The default Adabas D server name. If not set, the
                   variable [path DBNAME] is inspected also."
  term [path ADABASTCL[us]DIR]
  term_definition "The directory to look for the startup scripts."
}

#   -------------
sec "X-Resources"
#   -------------

p "While starting, the X resource database is read, so that the text
   of the subtitle of Adabas D can be custumized by the user."

p "The resources can be set via the [prog xrdb] command (highest priority)
   or mentioned in the file [path [dollar]HOME/.Xdefaults].
   The default values, if no resource assignment can be found,
   can bee seen in the following excerpt from a resource file."

preformatted {
  *panel.edition:      Database Server
  *panel.netscapeHelp: False
}

#   -------
sec "Files"
#   -------

definition_list {
  term [path [dollar]HOME/.XUSER]
  term_definition or
  term [path [dollar]HOME/.XUSER.62]
  term_definition "The xuser file to look for connect parameters."
}

#   ------
sec "Bugs"
#   ------

bullet_list {
  li "It would be fine, if only the control user can start the panel.
      Instead any user can start it; only if the state of the database
      server should be changed, the connect dialog pops up, claiming, that
      no valid control user is connected."
  li "When determining, if [prog panel] really connects to a local serverdb,
      currently [screen servernode] must be emtpy. It would be fine, if the
      actual name of the local host or even [path localhost] would be
      accepted, too." 
}

#   --------
sec "Author"
#   --------

p "Christian Krone, Berlin. Version 1.0, July 1997."
p [path krischan@cs.tu-berlin.de]

}
