# -----------------------------------------------------------------------
#  $Id: plugin.tcl,v 1.1 1997/07/06 14:58:22 adabas Exp $
# -----------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# -----------------------------------------------------------------------

# -----------------------------------------------------------------------
# First of all the procedure to write to a specific file given as parameter.
# The problem here is, that the cgi library writes to stdout, so we have
# to redefine puts to write to our file.
# -----------------------------------------------------------------------
proc writeFile {file commands} {
    global _cgi_outFile

    rename puts fprint
    if [catch {open $file w} _cgi_outFile] {
	return -code error "Cannot open $file for writing: $_cgi_outFile"
    }

    proc puts {args} {
	global _cgi_outFile
	if {[string match [lindex $args 0]* -nonewline]} {
	    if {[llength $args] > 2} {
		eval fprint $args
	    } else {
		fprint -nonewline $_cgi_outFile [lindex $args 1]
	    }
	} else {
	    if {[llength $args] > 1} {
		eval fprint $args
	    } else {
		fprint $_cgi_outFile [lindex $args 0]
	    }
	}
    }

    uplevel $commands

    rename puts {}
    rename fprint puts
    close $_cgi_outFile
}

# -----------------------------------------------------------------------
# Now two small wrapper for writeFile to generate html and/or tcl files.
# -----------------------------------------------------------------------
proc htmlFile {title file body} {
    writeFile [file join plugin $file.html] {
	html {
	    title   $title
	    uplevel $body
	}
    }
}
proc tclFile {title file body} {
    global env

    regsub -all %DBROOT% $body $env(DBROOT) body
    writeFile [file join plugin $file.tcl] {
	puts $body
    }
}

# -----------------------------------------------------------------------
# The contents of the html files start right now below this...
# -----------------------------------------------------------------------

#        =================
htmlFile "Adabas D Tclets" index {
#        =================

  sec "Adabas D Tclets"

  p "There are four Tcl applications for Adabas D available as Tclets:"
  bullet_list {
    li [link tkquery TkQuery tkquery.html]
    li [link panel   Panel   panel.html]
    li [link fotos   Fotos   fotos.html]
    li [link tkuser  TkUser  tkuser.html]
  }

  link plugin http://sunscript.sun.com/plugin/    http://sunscript.sun.com/plugin/
  link tcltk  http://sunscript.sun.com/TclTkCore/ http://sunscript.sun.com/TclTkCore/

  p "But before you click on any of the above links, you better make sure,
     that your system fulfills the following requirements:"
  number_list {
    li "The Tcl plugin must be installed, and it has to have version 2.0a2
        or above. Note: It's avaiable at [link plugin]."
    li "The Tcl/Tk interpreter has to be installed on your system, and it
        has to have version 8.0a2 or above. Note: It's avaiable at [link tcltk]."
    li "You have to set the environment variable [keyboard TCL[us]PLUGIN[us]WISH]
        to point to the full path of the Tk interpreter
        (e.g. [path /usr/local/bin/wish8.0]) before calling Netscape."
    li "This page must be accessed via the [keyboard http:] protocol.
        It doesn't work with the [keyboard file:] protocol![br]
        You can achieve this by making a soft link in your html directory pointing
        to [keyboard [dollar]DBROOT]/tcl/plugin"
    li "There must be a line in the Trusted policy data file
        (e.g. [keyboard ~/.tclplug/2.0/tcl8.0/policies/trusted.data]),
        saying that tcl scripts below this base URL have the right to access the
        Trusted policy."
  }
}

#        ==========================
htmlFile "Adabas D Tclets: TkQuery" tkquery {
#        ==========================

  cgi_center {
    table {} {
      table_row {
	table_head {put TkQuery}
      }
      table_data {
	embed AdabasTclet.tcl 600x535 application=tkquery
      }
    }
  }
}

#        ========================
htmlFile "Adabas D Tclets: Fotos" fotos {
#        ========================

  cgi_center {
    table {} {
      table_row {
	table_head {put Fotos}
      }
      table_data {
	embed AdabasTclet.tcl 390x320 application=fotos arguments="-u demo,demo"
      }
    }
  }
}

#        ========================
htmlFile "Adabas D Tclets: Panel" panel {
#        ========================

  cgi_center {
    table {} {
      table_row {
	table_head {put Panel}
      }
      table_data {
	embed AdabasTclet.tcl 470x310 application=panel arguments="-u control,control"
      }
    }
  }
}

#        =========================
htmlFile "Adabas D Tclets: TkUser" tkuser {
#        =========================

  cgi_center {
    table {} {
      table_row {
	table_head {put TkUser}
      }
      table_data {
	embed AdabasTclet.tcl 620x400 application=tkuser
      }
    }
  }
}

#       ===============
tclFile "Adabas Tclets" AdabasTclet {
#       ===============

    # If the Trusted policy isn't available, stop with a nice label.
    # Better use no error dialog, since this may be unavailable, too!

    if [info exists embed_args] {
	if [catch {package require Trusted}] { 
	    text .t -borderwidth 2 -relief ridge
	    .t insert 1.0 \
		    "This applet is only functional with the Trusted policy.\n\
		    You or your system administration have to adjust \
		    the list of trusted applets in .../policies/trusted.data.\n\
		    Note, that you also need at least version 2 of the Tcl plugin."
	    .t configure -state disabled
	    pack .t -fill both -expand 1
	    return
	}
    }

    set env(DBROOT) "%DBROOT%"
    if [info exists embed_args(arguments)] {
	set argv $embed_args(arguments)
    }
    source [file join $env(DBROOT) bin $embed_args(application)]
}