# -----------------------------------------------------------------------
#  $Id: tkquery.tcl,v 1.13 1997/07/06 22:04:36 adabas Exp $
# -----------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# -----------------------------------------------------------------------

html {

title "Tkquery - A tool for interactive SQL queries"

#   ----------
sec "Synopsis"
#   ----------

p [path "tkquery \[-n [variable dbnode]\] \[-d [variable dbname]\] \
                 \[-u [variable user],[variable passwd]\] \
                 \[-U [variable xuserKey]\] \[ -S [variable sqlmode]\]"]

#   ---------
sec "Options"
#   ---------

definition_list {
  term [path -n]
  term_definition "database node (default=local);"
  term [path  -d]
  term_definition "database name (default=[dollar]SERVERDB);"
  term [path  -u]
  term_definition "name and password of user;"
  term [path  -U]
  term_definition "name of xuser key."
  term [path  -S]
  term_definition "name of sqlmode (default=adabas)."
}

#   --------------
sec "Introduction"
#   --------------

p "When starting up the application, the user has to give the connect data
   by filling in the forms of the connect window or using the command line
   options. If everything is ok, a window called TkQuery is displayed."

p "The window consists mainly of five parts, which are described here from
   top to bottom."

#   -----------
ssec "Menu bar"
#   -----------

p "By means of the menu bar the user can start all the functionality
   that tkquery offers. The most important functions can be called also by
   pressing a function key; for the list of possible keys see
   [ref sec "Keyboard shortcuts"] below."

sssec "The SQL menu"

p "The top most entries of the [func SQL] menu are for navigate through
   the history of your sql queries. [func New] clears the SQL window,
   while [func Prev] and [func Next] cycles through the history. How
   many queries are stored, can be customized with the resource
   [path history] (see [ref sec X-Resources])."

p "Below the separator there are four entries to store and retrieve
   the queries in the database (beneath the title [screen "Stored commands"]).
   These functions store the queries in the same system tables and in the same
   format as [prog xquery] (the classic query tool of Adabas D) does;
   so you can exchange queries between these both tools via the database."

bullet_list {
  li "[func Get...] pops up a window containing a tree with all users of the
      database, having granted at least one stored query to you.
      You can select a query by clicking on the name of a
      query with your mouse pointer.[br]
      A click of the left mouse button starts the reading of the selected
      query in the database, which would then be displayed in the SQL window.[br]
      You can list all the queries of a user by clicking on the user name or the
      [func +] sign in front of the user image.[br]
      The window stays open until you press the [func Dismiss] button or
      the [func F3] key."

  li "[func Replace] only works, if you already connected your query with
      a stored command by [func Get...] or [func Insert...]. Then it
      updates the query in the system tables with the query, that is
      displayed in the SQL window."

  li "[func Insert...] pops up a dialog with an text entry, where you can
      determine the name of the query to store."

  li "[func Delete...] pops up a list similar to [func Get...], and after
      selecting a stored command it is deleted in the system tables."
}

p "The three entries [func Open...], [func Save] and [func "Save as..."]
   are to store and retrieve the queries from the local file system.
   They pop up a file selection box, where the user can give a filename."

p "The bottom most entry in [func SQL] menu is for quitting the program."

sssec "The Execute menu"

p "The menu [func Execute] has two groups of entries: At the top there are
   the commands [func Execute], [func Cancel] and [func Continue];
   at every time at least one of these are disabled.
   Normally only the [func Execute] command is available. If a SELECT command
   is currently executed, the [func Cancel] command is activated and will
   terminate the subsequent fetches. After the cancel of a SELECT statement
   the [func Execute] command is activated again, and the [func Continue]
   command to continue fetching more rows is available, too.
   The bottom most commands [func "Commit now"] and [func "Rollback now"]
   are only enabled, if autocommit (see [ref sssec "The Options menu"])
   is switched off.
   They commit (or rollback) all the sql commands entered since
   the last call of these commands or since the disabling of autocommit."

sssec "The Results menu"

p "The menu [func Results] is for handling of the result window
   (see [ref ssec "Results window"]).
   Here you can clear the result window ([func Clear])
   or save its content into a file ([func Save...]).
   You can activate the protocol, then every query together with its
   results are appended to the file [path tkquery.prot]."

p "The [func Configure...] command will pop up a window, containing a check box
   for every currently selected columnname. Here you can decide, if the
   values of the column should be displayed in the result. You can also
   switch off the displaying of a column with a right mouse button click
   at its column heading."

p "The output depends on the [func Style] cascade menu of the
   [func Options] menu. It can be a table in plain text or in HTML
   or LaTeX format. If the output style is plain, you can call
   [func Preview...] and a window with the results formatted in
   plain style will pop up. If the output style is HTML and
   [prog netscape] is running on the same machine and display as
   [prog tkquery], [prog netscape] will display the results."

sssec "The Options menu"

p "The [func Options] menu is mostly for customize personal preferences.
   All options can be configured via resources at startup time of
   [prog tkquery] (see [ref sec X-Resources])."

sssec "The DB objects menu"

p "By means of the menu [func "DB objects"] you can look at all data base objects
   (tables, columns, views and indexes), that are accessible to you."

p "After clicking on a menu entry a window pops up, that displays in its left half
   a tree with all users of the database as well as all their tables, views and
   indexes, that are visible to you."

p "You can navigate in the tree by opening and closing subtrees with a click on
   the [func +] or [func -] signs."

p "If you click on a table name, the right window will display
   information about the columns of this table.[br]
   If you click on a view name, the right window will display
   the definition text of this view.[br]
   If you click on an index name, the right window will display
   information about the columns of this index."

sssec "The Help menu"

p "The right most [func "Help"] menu offers you some helpful text (e.g. this one).
   You can read also an introduction to AdabasTcl, a Tcl extension to connect to
   the Adabas D serverdb."

p "With the check button [func "With balloon help"] you can toggle the helpful
   labels popping up, if the mouse pointer rests over on of the tool buttons
   (see [ref ssec "Toolbar buttons"])."

p "With the check button [func "Use Netscape"] you can configure, if Netscape as
   external browser should be used to display the help texts."

#    ------------------
ssec "Toolbar buttons"
#    ------------------

p "Below the menubar there is a window consisting of buttons for the most
   important functions of TkQuery."

p "If the cursor moves over one of these buttons, the status line at the bottom
   will display a description of the function associated with this button.
   If the cursor resides more than a half second over the button, a small
   rectangle containing an even shorter description will pop up (a so called
   balloon help, which can be disabled in the [screen Help] menu, see
   [ref sssec "The Help menu"])."

p "User, who dislike the colorful button bar, can disable it in the 
   [screen Option] menu (see [ref sssec "The Options menu"])."

#    -------------
ssec "Sql window"
#    -------------

p "In this window the user can enter a SQL statement.
   No special formatting is neccessary (Layout will be ignored).
   The motif or emacs like control sequences are activ (e.g. [keyboard C-a]
   for move to beginning of line). The user can start the entered query by
   a click on the [screen Execute] button or by a press of the
   [keyboard F5] key."

p "If the SQL statement is syntactically incorrect, the insert cursor is
   placed at the point, where the database server detected the error."

p "The user can scroll the SQL window with the attached scrollbar, can clear
   it and even switch to the previos or next entered SQL statement."

p "The sql window can actually contain a little more than blank sql.
   Before the sql statement there can be a layout specification, which
   must be framed by [keyboard LAYOUT] and [keyboard ENDLAYOUT].
   This layout specifies the content of a window, which will pop up, if the
   user executes the SQL statement.
   You can denote entry fields with the [keyboard [amp]] sign, followed by
   a number; the value of this entry (entered by the user) will be substituted
   for the corresponding [keyboard [amp]] sign in the sql-statement.
   A default value for the entry field can be given by a pascal like assignment
   followed by the value. To let the default value contain blanks, you have
   to surround it with quotes. An example follows."
preformatted {
    LAYOUT
      Name: &1
      City: &2 := 'Berlin *'
    ENDLAYOUT
    SELECT * FROM address WHERE name = '&1' AND city LIKE '&2'
}

p "After the statement you can specify some of the aspects of the output.
   It must be introduced by the [keyboard REPORT] symbol at the beginning of
   a line, and can contain [keyboard NAME], [keyboard EXCLUDE] and
   [keyboard INCLUDE] statement. An example follows."
preformatted {
    SELECT TIMESTAMP, DATE, TIME FROM dual
    REPORT
      EXCLUDE 1
      NAME    2 'Date' 
      NAME    3 'Time'
}

p "You can list more than one sql-statement separated by a line beginning
   with either a [keyboard /] or a [keyboard *]. This is nice, if you want
   to update some values and then select the updated values (e.g. for a
   price increasing)."

p "If there is a selected area in the sql window, only the text of this area
   is executed. This way you can enter more than one sql statement and can
   execute them one at a time by selecting only parts of the text."

#    -----------------
ssec "Results window"
#    -----------------

p "The results of an executed select statement are displayed in this window.
   If there are more results than fit into the window, you can scroll
   in every direction with the scrollbars, that are attached to the right
   and bottom of the window (or with [keyboard "Page Up"],
   [keyboard "Page Down"], [keyboard F10] and [keyboard F11]) or the arrows
   of the toolbar."

p "You can exclude a column from displaying by clicking its name with the
   right mouse button. This is a shortcut for the [func Configure...]
   entry in the [func Results] menu (see [ref sssec "The Results menu"]).
   There you can reinclude a column, too."

p "The results can be printed together with the query into a file by
   means of the function [func Print...] in the menu [func Results].
   All queries together with their results are printed in a file called
   [path tkquery.prot], if the checkbutton [func Protocol] is activated.
   The format of the printing, which can be either plain text, latex or html,
   can be selected in the [func Options] menu."

p "Also in the [func Options] menu there is the possibility to select a font
   for the results window."

#    --------------
ssec "Status line"
#    --------------

p "In this line there is the message returned from the last executed command
   or any other help message. To the right there is a label containing the
   name of the connected user."

#    --------------------
sec "Keyboard shortcuts"
#    --------------------

definition_list {
  term [keyboard F1]
  term_definition "A window with this help text pops up."
  term [keyboard F2]
  term_definition "The SQL window and the result window will be cleared."
  term [keyboard F3]
  term_definition "If currently a query is in work, it will be cancelled and
                   tkquery will fetch no more additional rows. If no query
                   is at work, the program will be terminated."
  term [keyboard F5]
  term_definition "The query in the SQL window will be executed, and in the
                   case of a SELECT statement, the resulting rows are
                   displayed in the result window."
  term [keyboard F6]
  term_definition "The next SQL statement will be shown in the SQL window."
  term [keyboard F9]
  term_definition "The previous SQL statement will be shown in the SQL window."
  term [keyboard F10]
  term_definition "The result window will scroll a page to the left,
                   if possible."
  term [keyboard F11]
  term_definition "The result window will scroll a page to the right,
                   if possible."
  term "Movement keys"
  term_definition "The input cursor of the SQL window will move in the
                   corresponding direction."
  term "[keyboard "Page Up"], [keyboard "Page down"]"
  term_definition "The result window will scroll up (or down) a page,
                   if possible."
}

#    -----------------------
sec "Environment variables"
#    -----------------------

definition_list {
  term [path SERVERDB]
  term_definition "The default Adabas D server name. If not set, the
                   variable [path DBNAME] is inspected also."
  term [path ADABASTCL[us]DIR]
  term_definition "The directory to look for the startup scripts."
}

#    -------------
sec "X-Resources"
#    -------------

p "While starting, the X resource database is read, so that the startup
   state of some check or radio buttons can be custumized by the user."

p "The resources can be set via the [prog xrdb] command (highest priority)
   or mentioned in the file [path [dollar]HOME/.Xdefaults].
   The default values, if no resource assignment can be found,
   can bee seen in the following excerpt from a resource file."

preformatted {
  *tkquery.fontFamily:   helvetica
  *tkquery.fontSize:     12
  *tkquery.fontStyle:    bold
  *tkquery.autoCommit:   True
  *tkquery.dateFormat:   internal
  *tkquery.outputStyle:  plain
  *tkquery.withProt:     False
  *tkquery.history:      10
  *tkquery.nullValue:
  *tkquery.specialNull:	 ***
  *tkquery.withToolBar:  True
  *tkquery.netscapeHelp: False
  *tkquery.balloonHelp:  True
  *tkquery.errorPopup:   False
}

#    -------
sec "Files"
#    -------

definition_list {
  term [path [dollar]HOME/.XUSER]
  term_definition or
  term [path [dollar]HOME/.XUSER.62]
  term_definition "The xuser file to look for connect parameters."
}

#    ------
sec "Bugs"
#    ------

bullet_list {
  li "The [screen Cancel] button works only while fetching,
      and not for long time running sql statements."
  li "If you delete lot of ascending rows from a table, the status line
      says, that -1 rows are afftected."
}

#    -------
sec "Notes"
#    -------

bullet_list {
  li "Stored commands of query plus should be handled, too."
  li "There should be no dependency from environment variable
      [path ADABASTCL[us]DIR], but only from [path DBROOT]."
}
#    ---------
sec "Credits"
#    ---------

p "Tkquery is deeply inspired by and build upon [path wosql] 
   (Windowing Oracle SQL) by Tom Poindexter"

#    --------
sec "Author"
#    --------

p "Christian Krone, Berlin. Version 1.0, July 1997."
p [path krischan@cs.tu-berlin.de]

}
