
# ----------------------------------------------------------------------------
# $Id: test.pl,v 1.3 1997/06/08 16:46:47 adabas Exp $
#
# Copyright (c) 1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ----------------------------------------------------------------------------

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

# Take connect data from the environment...
$Serverdb = $ENV{SERVERDB} || "MYDB";
$Account  = $ENV{ACCOUNT}  || "demo";
$Password = $ENV{PASSWORD} || "demo";

######################### We start with some black magic to print on failure.
BEGIN {print "1..24\n";}
END {print "not ok 1\n" unless $loaded;}
use Adabas;
$loaded = 1;
print "ok 1\n";
######################### End of black magic.

sub checkError {
    my ($wantedPos, $wantedRc, $wantedMsg, $ok) = @_;

    my $errtxt = Adabas::errortxt;
    if ($errtxt !~ /$wantedMsg/) {
	warn "Strange errortext: <$errtxt> wanted: <$wantedMsg>";
    }
    my $errpos = Adabas::errorpos;
    if ($errpos != $wantedPos) {
	warn "Strange errorpos: $errpos";
    }
    my $rc = Adabas::rc;
    if ($rc != $wantedRc) {
	warn "Strange returncode: $rc";
    }
    print "ok $ok\n";
}

# The following line should be activated when debugging Adabastcl.so;
# in the pause you can give your debugger the needed commands to read in
# the freshly loaded library (in gdb: sharedlib).
# print "Press return key to continue\n"; getc;

my $version = Adabas::version or die "Oops, Adabas::version didn't succeed???";
print "<$version>\nok 2\n";

# test of Adabas::logon and Adabas::logoff...
my $logon1 = Adabas::logon("$Account,$Password", $Serverdb);
if (!$logon1) {
    print <<EndOfMessage;
The first attempt in this test to connect to serverdb '$Serverdb' failed.
This may have its reason in the fact, that the Adabas D server has
a different name on your machine. Another reason may be, that there
exists no account '$Account' with the password '$Password'.
To customize this connect data, set some environment variables:
SERVERDB, ACCOUNT and PASSWORD
Or you can call this test like the following:
  make test SERVERDB=v12 ACCOUNT=krischan PASSWORD=geheim
The following line is the error message from the database server:
EndOfMessage

    die Adabas::errortxt;
}
if ($logon1 !~ /^AdabasInfoPtr=SCALAR\(0x[0-9a-f]*\)$/ ) {
    warn "Strange looking logon handle: <$logon1>";
}
Adabas::logoff($logon1);
print "ok 3\n";

my $logon2 = Adabas::logon("$Account,$Password",$Serverdb, "oracle")
    or die Adabas::errortxt;
if ($logon1 !~ /^AdabasInfoPtr=SCALAR\(0x[0-9a-f]*\)$/) {
    warn "Strange looking logon handle: <$logon1>";
}
Adabas::logoff($logon2);
print "ok 4\n";

my $logon3 = Adabas::logon("$Account,$Password", $Serverdb, "informix");
if (defined $logon3) {
    die "Oops, do we get a sqlmode informix in the meantime???";
}
my $errtxt = Adabas::errortxt;
if ($errtxt !~ /unknown sqlmode "informix"/) {
    warn "Strange errortext: <$errtxt>";
}
print "ok 5\n";

# test of Adabas::open and Adabas::close...
my $logon = Adabas::logon("$Account,$Password", $Serverdb) or die Adabas::errortxt;

my $cursor1 = Adabas::open($logon) or die Adabas::errortxt;
if ($cursor1 !~ /^CursorInfoPtr=SCALAR\(0x[0-9a-f]*\)$/) {
    warn "Strange looking cursor handle: <$cursor1>";
}
Adabas::close($cursor1);
print "ok 6\n";

my $cursor2 = Adabas::open($logon) or die Adabas::errortxt;
my $cursor3 = Adabas::open($logon) or die Adabas::errortxt;
if ($cursor2 !~ /^CursorInfoPtr=SCALAR\(0x[0-9a-f]*\)$/ ||
    $cursor3 !~ /^CursorInfoPtr=SCALAR\(0x[0-9a-f]*\)$/ ||
    $cursor2 eq $cursor3) {
    warn "Strange looking cursor handles: <$cursor1,$cursor2>";
}
Adabas::close($cursor2);
Adabas::close($cursor3);
print "ok 7\n";

Adabas::sql($cursor2,"select * from dual")
    or warn "No error, if selecting from a dead cursor???";
my $errtxt = Adabas::errortxt;
if ($errtxt ne "No valid cursor handle: cursor1") {
    warn "Strange errortext: <$errtxt>";
}
print "ok 8\n";

Adabas::logoff($logon);
my $cursor4 = Adabas::open($logon);
if (defined $cursor4) {
    die "Oops, cursor handle out of a dead logon???";
}
my $errtxt = Adabas::errortxt;
if ($errtxt !~ /Invalid logonHandle /) {
    warn "Strange errortext: <$errtxt>";
}
print "ok 9\n";

# test of Adabas::sql and Adabas::fetch...
my $logon  = Adabas::logon("$Account,$Password", $Serverdb) or die Adabas::errortxt;
my $cursor = Adabas::open($logon) or die Adabas::errortxt;

Adabas::sql($cursor, "create table pt (a char(20))")
    and die  Adabas::rc, " at pos ", Adabas::errorpos, ": ", Adabas::errortxt;
print "ok 10\n";
Adabas::sql($cursor, "create table pt (a char(20))")
    or warn "No error, when creating the same table twice???";
checkError (14, -6000, "DUPLICATE TABLE NAME:PT", 11);

Adabas::sql($cursor, "select sysdate from dual", "informix")
    or die "Oops, do we get a sqlmode informix in the meantime???";
my $errtxt = Adabas::errortxt;
if ($errtxt !~ /unknown sqlmode "informix"/) {
    warn "Strange errortext: <$errtxt>";
}
print "ok 12\n";

Adabas::sql($cursor, "select sysdate from dual", "ansi")
    or warn "No error, when forgetting INTO clause in ANSI mode???";
checkError (16, -3008, "INVALID KEYWORD OR MISSING DELIMITER", 13);

Adabas::sql($cursor, "select sysdate from dual", "oracle")
    and die  Adabas::rc, " at pos ", Adabas::errorpos, ": ", Adabas::errortxt;
print "ok 14\n";

my ($sysdate) = Adabas::fetch ($cursor) or die  Adabas::errortxt;
if ($sysdate !~ /^[0-9]{20}$/) {
    warn "Strange looking timestamp: <$sysdate>";
}
print "ok 15\n";

Adabas::sql($cursor, "select sysdate datum, user benutzer from dual", "oracle")
    and die  Adabas::rc, " at pos ", Adabas::errorpos, ": ", Adabas::errortxt;
print "ok 16\n";

my ($sysdate, $user) = Adabas::fetch ($cursor) or die  Adabas::errortxt;
if ($sysdate !~ /^[0-9]{20}$/) {
    warn "Strange looking timestamp: <$sysdate>";
}
if ($user ne "\U$Account") {
    warn "Strange looking user name: <$user>";
}
print "ok 17\n";

Adabas::sql($cursor, "select sysdate datum, user benutzer from dual", "oracle")
    and die  Adabas::rc, " at pos ", Adabas::errorpos, ": ", Adabas::errortxt;
print "ok 18\n";

my @resultList = Adabas::fetch ($cursor,"","oracle")
    or die Adabas::errortxt;
if ("@resultList" !~ /[0-9]{20} $Account/i) {
    warn "Strange looking result list: <@resultList>";
}
print "ok 19\n";

my @resultList = Adabas::fetch ($cursor);
if (defined @resultList) {
    die "Returning result, when all is fetched???";
}
print "ok 20\n";

my @resultList = Adabas::fetch ($cursor,"1")
    or die Adabas::errortxt;
if ("@resultList" !~ /[0-9]{20} $Account/i) {
    warn "Strange looking result list: <@resultList>";
}
print "ok 21\n";

my @resultList = Adabas::fetch ($cursor,"adabas");
if (defined @resultList) {
    die "Oops, it seems that adabas is a legal fetch position!!!";
}
print "ok 22\n";

my %resultHash = Adabas::fetchHash ($cursor, "1")
    or die Adabas::errortxt;
if (! grep /DATUM/, keys %resultHash
    or !grep /BENUTZER/, keys %resultHash) {
    warn "Strange column names: <", keys(%resultHash), ">";
}
print "ok 23\n";

if ($resultHash{DATUM} !~ /^[0-9]{20}$/
    || $resultHash{BENUTZER} ne "\U$Account") {
    warn "Strange looking result list: <", values %resultHash, ">";
}
print "ok 24\n";

Adabas::rollback($logon)      and die Adabas::errortxt;
Adabas::commit($logon)        and die Adabas::errortxt;
Adabas::autocommit($logon, 1) and die Adabas::errortxt;
Adabas::autocommit($logon, 0) and die Adabas::errortxt;

Adabas::close($cursor);
Adabas::logoff($logon);

