#include <stdio.h>
#include <math.h>
#include <tcl.h>
#include "hli.h"

#ifdef FRB
#include "hliutils.h"
#endif

#define TclProc(a) static int a(ClientData clientData, Tcl_Interp *interp, \
                     int argc, char *argv[])
#define err(a) { interp->result=a; return TCL_ERROR; }
#define errnum(b,a) { char x[255]; interp->result=sprintf(x,"%d %s",a,b); return TCL_ERROR; }
#define errn(a) { char x[255]; interp->result=sprintf(x,"%d",a); return TCL_ERROR; }
#define result_int(a) { Tcl_SetResult(interp, \
             (char*)sprintf((char*)malloc(255),"%d",a),TCL_DYNAMIC); }

#define newcmd(a) Tcl_CreateCommand(interp,"a",a, \
                  (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL) 

void free();

#include "fametcl.h"

static int Tcl_famestart();
static int Tcl_famestop();
static int Tcl_fameopen();
static int Tcl_fameclose();
static int Tcl_famegetinfo();
static int Tcl_fameread();
static int Tcl_famewrite();
static int Tcl_cfmgatt();
static int Tcl_cfmsatt();

char *getvalstr(char *x,void *v,int elem,int typ);

extern int errno;

TclProc(Tcl_famestart)
{
  int retval;
  if (argc != 1) err("usage: famestart");
  cfmini(&retval);
  result_int(retval);
  return TCL_OK;
}

TclProc(Tcl_famestop)
{
  int retval;
  if (argc != 1) err("usage: famestop");
  cfmfin(&retval);
  result_int(retval);
  return TCL_OK;
}

TclProc(Tcl_fameopen)
{
  int status;
  int retval;
  char *path;
  char *name;
  int mode;

  if (argc < 2 || argc > 3) err("usage: fameopen $filename $mode");

  name=argv[1];

  if (argc == 2) { mode=HRMODE; }
  else { mode=atoi(argv[2]); }

#ifdef FRB
  (void)famedbpath(name,&path);
  if (*path!=NULL&&*path!='\n') name=path;
  if (name[strlen(name)-1]=='\n') name[strlen(name)-1]='\0';
#endif

  cfmopdb(&status,&retval,name,mode);
  if (status!=HSUCC) errnum("open failed",status);
  result_int(retval);

#ifdef FRB
  free(path);
#endif
  return TCL_OK;
}

TclProc(Tcl_fameclose)
{
  int retval;

  if (argc != 2) err("usage: fameclose $dbkey");
  cfmcldb(&retval,atoi(argv[1]));
  result_int(retval);
  if (retval == HSUCC) return TCL_OK;
  else return TCL_ERROR;
}

TclProc(Tcl_famegetinfo)
{
  char x[255];
  int p[16];
  char *p1;
  char *p2;
  int i,d1,d2;

  if (argc != 3) err("usage: famegetinfo $dbkey $objnam");

  cfmdlen(&p[0],atoi(argv[1]),argv[2],&d1,&d2);
  d1++; d2++;
  p1=(char*) malloc(d1*sizeof(char));
  p2=(char*) malloc(d2*sizeof(char));
  for(i=0;i<d1;i++) { p1[i]=' '; } p1[d1-1]='\n'; p1[d1]=0;
  for(i=0;i<d2;i++) { p2[i]=' '; } p2[d2-1]='\n'; p2[d2]=0;

  cfmwhat(&p[0],atoi(argv[1]),argv[2],&p[1],&p[2],&p[3],&p[4],&p[5],&p[6]
  ,&p[7],&p[8],&p[9],&p[10],&p[11],&p[12],&p[13],&p[14],&p[15],p1,p2);

  if (p[0] != HSUCC) { result_int(p[0]); return TCL_ERROR; }

  for (i=1;i<=15;i++) {
    Tcl_AppendElement(interp,(char*)sprintf(x,"%d",p[i]));
  }
  Tcl_AppendElement(interp,p1);
  Tcl_AppendElement(interp,p2);
  return TCL_OK;
}

TclProc(Tcl_fameread)
{
  int retval;
  int i;
  int dbkey;
  char *series;
  int freq,typ,num=-1,range[3];
  int sy,sp,ey,ep;
  int sz;
  void *valary;
  float* mistt;
  char x[255];

  if (argc < 6 || argc > 7) 
    err("usage: fameread $db $obj [$r1 $r2 $r3] | [$sy $sp $ey $ep]");
  dbkey=atoi(argv[1]);
  series=argv[2];
  freq=famegetfreq(dbkey,series);
  typ=famegettype(dbkey,series);
  if (freq==-1||typ==-1) errnum("Read failure",errno);

  if (argc == 7) {
    sy=atoi(argv[3]);
    sp=atoi(argv[4]);
    ey=atoi(argv[5]);
    ep=atoi(argv[6]);
    cfmsrng(&retval,freq,&sy,&sp,&ey,&ep,range,&num);
    if (retval!=HSUCC) errnum("Range set failure",retval);
  }
  else {
    range[0]=atoi(argv[3]);
    range[1]=atoi(argv[4]);
    range[2]=atoi(argv[5]);
  }

  switch(typ) {
    case HNUMRC: sz=sizeof(float); break;
    case HBOOLN: sz=sizeof(int); break;
    case HPRECN: sz=sizeof(double); break;
    case HSTRNG:
    case HNAMEL: sz=1024; break;
    case HUNDFT: sz=0; break;
    default: sz=0;
  }
  if (sz==0) err("Invalid data type");
  valary=(void*)malloc(num*sz);
  cfmrrng(&retval,dbkey,series,range,valary,HNTMIS,mistt);

  if (retval!=HSUCC) {
    free(valary);
    errnum("Can't read data or series not found",retval);
  }

  for (i=0;i<num;i++) {
    Tcl_AppendElement(interp,(char*)getvalstr(x,valary,i,typ));
  }
  free(valary);

  return TCL_OK;
}

/* get a string value in x for v[elem] or type typ */
char *
getvalstr(char *x,void *v,int elem,int typ)
{
  float *pf;
  double *pd;
  int *pi;
  char *ps;

  pf=(float *)v;
  pd=(double *)v;
  pi=(int *)v;
  ps=(char *)v;

    switch(typ) {
      case HNUMRC: 
        if (pf[elem]==FNUMNC) strcpy(x,"NC");
        else if (pf[elem]==FNUMND) strcpy(x,"ND");
        else if (pf[elem]==FNUMNA) strcpy(x,"NA");
        else sprintf(x,"%f",pf[elem]);
        break;
      case HBOOLN:
        if (pi[elem]==FBOONC) strcpy(x,"NC");
        else if (pi[elem]==FBOOND) strcpy(x,"ND");
        else if (pi[elem]==FBOONA) strcpy(x,"NA");
        else sprintf(x,"%f",pi[elem]);
        break;
      case HPRECN:
        if (pd[elem]==FPRCNC) strcpy(x,"NC");
        else if (pd[elem]==FPRCND) strcpy(x,"ND");
        else if (pd[elem]==FPRCNA) strcpy(x,"NA");
        else sprintf(x,"%f",pd[elem]);
        break;
      case HNAMEL:
      case HSTRNG:
        if (memcmp(ps,FSTRNC,HSMLEN)==0) strcpy(x,"NC");
        else if (memcmp(ps,FSTRND,HSMLEN)==0) strcpy(x,"ND");
        else if (memcmp(ps,FSTRNA,HSMLEN)==0) strcpy(x,"NA");
        else strcpy(x,ps);
        break;
    }
  return x;
}

/* put a FAME value in v[i] of type typ using
   source string ss */
int
putval(void *v,int i,int typ,char *ss)
{
  float *pf;
  double *pd;
  int *pi;
  char *ps;

  pf=(float *)v;
  pd=(double *)v;
  pi=(int *)v;
  ps=(char *)v;

  switch(typ) {
    case HNUMRC: 
      if (ss[0]=='N') {
        if (strcmp(ss,"NC")==0) pf[i] = FNUMNC;
        else if (strcmp(ss,"ND")==0) pf[i] = FNUMND;
        else if (strcmp(ss,"NA")==0) pf[i] = FNUMNA;
        else pf[i]=(float)atof(ss);
      }
      else pf[i]=(float)atof(ss);
      break;
    case HBOOLN:
      if (ss[0]=='N') {
        if (strcmp(ss,"NC")==0) pi[i] = FBOONC;
        else if (strcmp(ss,"ND")==0) pi[i] = FBOOND;
        else if (strcmp(ss,"NA")==0) pi[i] = FBOONA;
        else pi[i]=(int)atoi(ss);
      }
      else pi[i]=(int)atoi(ss);
      break;
    case HPRECN:
      if (ss[0]=='N') {
        if (strcmp(ss,"NC")==0) pd[i] = FPRCNC;
        else if (strcmp(ss,"ND")==0) pd[i] = FPRCND;
        else if (strcmp(ss,"NA")==0) pd[i] = FPRCNA;
        else pd[i]=(double)atof(ss);
      }
      else pd[i]=(double)atof(ss);
      break;
    case HNAMEL:
    case HSTRNG:
      if (ss[0]=='N') {
        if (strcmp(ss,"NC")==0) memcpy(ps,FSTRNC,HSMLEN);
        else if (strcmp(ss,"ND")==0) memcpy(ps,FSTRND,HSMLEN);
        else if (strcmp(ss,"NA")==0) memcpy(ps,FSTRND,HSMLEN);
        else strcpy(ps,ss);
      }
      else strcpy(ps,ss);
      break;
    default: return 0;
  }
  return 1;
}

TclProc(Tcl_famewrite)
{
  int retval;
  int dbkey;
  char *series;
  int sy, sp, ey=-1, ep=-1;
  int range[3];
  int numobs,freq,typ;
  char **v;
  float *mistt;
  int sz;
  void *buff;
  int i;

  if (argc != 6) err("usage: famewrite $db $obj $year $period $list");
  dbkey=atoi(argv[1]);
  series=argv[2];
  sy=atoi(argv[3]);
  sp=atoi(argv[4]);

  freq=famegetfreq(dbkey,series);
  typ=famegettype(dbkey,series);

  Tcl_SplitList(interp,argv[5],&numobs,&v);
  cfmsrng(&retval,freq,&sy,&sp,&ey,&ep,range,&numobs);
  if (retval != HSUCC) errnum("Error setting range",retval);

  switch(typ) {
    case HNUMRC: sz=sizeof(float); break;
    case HBOOLN: sz=sizeof(int); break;
    case HPRECN: sz=sizeof(double); break;
    case HSTRNG:
    case HNAMEL: sz=1024; break;
    case HUNDFT: sz=0; break;
    default: sz=0;
  }
  if (sz==0) err("Invalid data type");

  buff=(void*)malloc(sz*numobs);

  for (i=0;i<numobs;i++) {
    if (!putval(buff,i,typ,v[i])) {free(buff);errnum("Invalid observation",i);}
  }
  mistt=(float*)malloc(sz*3);
  cfmwrng(&retval,dbkey,series,range,buff,HNTMIS,mistt);
  free(buff);
  free(mistt);
  if (retval != HSUCC) errnum("Error writing range",retval);

  if (numobs-i>1) result_int(-1)
  else result_int(i+1)
  return TCL_OK;
}

TclProc(Tcl_cfmgatt)
{
  int status;
  int dbkey;
  char *objnam;
  int atttyp;
  char *attnam;
  char *value;
  int len;
  double *pd;
  int *pi;
  float *pf;
  char x[512];
  char *p;
  

  if (argc != 7) err("usage: cfmgatt status $dbkey objnam atttyp attnam value");
  dbkey=atoi(argv[2]);
  objnam=Tcl_GetVar(interp,argv[3],0);
  atttyp=atoi(Tcl_GetVar(interp,argv[4],0));
  attnam=Tcl_GetVar(interp,argv[5],0);

  switch(atttyp) {
    case HNUMRC: value=(char*)malloc(sizeof(float)); break;
    case HBOOLN: value=(char*)malloc(sizeof(int)); break;
    case HPRECN: value=(char*)malloc(sizeof(double)); break;
    case HSTRNG: value=(char*)malloc(1024); break;
#ifdef HLI75
    case HNAMEL: cfmlatt(&status,dbkey,objnam,atttyp,attnam,&len);
                 value=(char*)malloc(sizeof(char)*(len+1));
                 break;
#else
    case HNAMEL: value=(char*)malloc(1024); break;
#endif
    default: p="undefined"; break;
  }
  (void)cfmgatt(&status, dbkey, objnam, &atttyp, attnam, value);

  p=getvalstr(x,value,0,atttyp);

  Tcl_SetVar(interp,argv[6],p,0);
  Tcl_SetVar(interp,argv[1],sprintf(x,"%d",status),0);
  Tcl_SetVar(interp,argv[3],objnam,0);
  Tcl_SetVar(interp,argv[4],sprintf(x,"%d",atttyp),0);
  Tcl_SetVar(interp,argv[5],attnam,0);

  free(value);
  result_int(status);
  return TCL_OK;
}

TclProc(Tcl_cfmsatt)
{
  int status;
  int dbkey;
  char *objnam;
  int atttyp;
  char *attnam;
  char *str;
  char value[128];
  char x[512];
  void *p=value;
  
  if (argc != 7) err("usage: cfmsatt status $dbkey objnam atttyp attnam value");
  dbkey=atoi(argv[2]);
  objnam=Tcl_GetVar(interp,argv[3],0);
  atttyp=atoi(argv[4]);
  attnam=Tcl_GetVar(interp,argv[5],0);
  str=argv[6];

  switch(atttyp) {
    case HNUMRC: *((float *)p)=(float)atof(str); break;
    case HBOOLN: *((int *)p)=atoi(str); break;
    case HPRECN: *((double *)p)=(double)atof(str); break;
    case HSTRNG:
    case HNAMEL: p=(char*)malloc(strlen(str)+1); strcpy((char *)p,str); break;
    default: err("Undefined atttyp in cfmsatt");
  }

  (void)cfmsatt(&status, dbkey, objnam, atttyp, attnam, p);
  Tcl_SetVar(interp,argv[1],sprintf(x,"%d",status),0);
  Tcl_SetVar(interp,argv[3],objnam,0);
  Tcl_SetVar(interp,argv[4],sprintf(x,"%d",atttyp),0);
  Tcl_SetVar(interp,argv[5],attnam,0);
  Tcl_SetVar(interp,argv[6],p,0);

  result_int(status);
  return TCL_OK;
}

#include "fameval.i"
#include "fameset.i"

int 
Fame_Init(Tcl_Interp *interp) 
{
  Tcl_CreateCommand(interp,"famestart",Tcl_famestart, (ClientData)NULL, 
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"famestop",Tcl_famestop, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"fameopen",Tcl_fameopen, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"fameclose",Tcl_fameclose, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"famegetinfo",Tcl_famegetinfo, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"fameread",Tcl_fameread, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"famewrite",Tcl_famewrite, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"cfmgatt",Tcl_cfmgatt, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp,"cfmsatt",Tcl_cfmsatt, (ClientData)NULL,
                    (Tcl_CmdDeleteProc *)NULL);

  #include "fameinit.i"

  return TCL_OK;
}
