share p q xmin xmax ymin ymax maxiter
share next_row n_columns n_rows deltax deltay
share julia_lock

set thread_count 2
set julia_lock [mutex create]

set p -0.74356
set q 0.11135
set xmin -2.0 ; set xmax 2.0
set ymin -2.0 ; set ymax 2.0
set maxiter 256

set n_columns 100 ; set n_rows 100
set next_row 0

set deltax [expr ($xmax-$xmin)/($n_columns-1)]
set deltay [expr ($ymax-$ymin)/($n_rows-1)]

frame .julia
canvas .julia.c -width [expr int($n_columns*1.25)] \
		-height [expr int($n_rows*1.25)]
pack .julia.c
pack .julia

image create photo julia-pic -height $n_rows -width $n_columns
julia-pic blank
.julia.c create image 75 75 -image julia-pic

proc julia_next {} {
    share next_row n_rows julia_lock

    mutex lock $julia_lock
    if {$next_row>$n_rows} {mutex unlock $julia_lock ; return done}
    set row $next_row
    incr next_row
    mutex unlock $julia_lock
    return $row
}

proc julia_calc {} {
    share p q xmin ymin maxiter
    share deltax deltay n_columns

    for {set r 0} {$r<16} {incr r} {
	set color($r) [format "#%x%x%x" $r 0 [expr 15-$r]]
    }
    while {[catch {thread nextmsg 0}]} {
	if {[set row [julia_next]] == "done"} {break}
	set x $xmin
	set y [expr $ymin + $row * $deltay]
	set data {}
	for {set xpix 0} {$xpix<$n_columns} {incr xpix} {
	    set k [julia $x $y $p $q $maxiter]
	    if {$k=="max"} {
		lappend data #000
	    } else {
		lappend data $color([expr $k%16])
	    }
	    set x [expr $x+$deltax]
	}
	thread post thread1 "julia-pic put [list [list $data]] \
		-to 0 $row [expr $n_columns-1] [expr $row+1]"
    }
}

# The threads are created "bound" so that compute resources are
# pre-allocated and reserved.

for {set t 0} {$t<$thread_count} {incr t} {
    thread create -bound -detached julia_calc
}

