share p q xmin xmax ymin ymax maxiter
share n_columns n_rows deltax deltay
share next_row julia_lock

set p -0.74356
set q  0.11135
set xmin -2.0 ; set xmax 2.0
set ymin -2.0 ; set ymax 2.0
set maxiter 256

set n_columns 100 ; set n_rows 100
set next_row 0

set deltax [expr ($xmax-$xmin)/($n_columns-1)]
set deltay [expr ($ymax-$ymin)/($n_rows-1)]

# Used to keep track of threads and synchronize access to next_row 
set thread_count 0
set threads {}
set julia_lock [mutex create]

frame .p
label .p.label -text p
entry .p.entry -textvariable p
frame .q
label .q.label -text q
entry .q.entry -textvariable q

frame .threads
label .threads.label -text Threads
entry .threads.entry -state disabled -width 3 -textvariable thread_count
button .threads.add -text Add -command add_thread
button .threads.remove -state disabled -text Remove -command remove_thread

frame .julia
canvas .julia.c -width 150 -height 150

pack .p.label .p.entry -side left
pack .q.label .q.entry -side left
pack .threads.label .threads.entry .threads.add .threads.remove -side left
pack .julia.c
pack .p .q .threads .julia

image create photo julia-pic -height $n_rows -width $n_columns
julia-pic blank
.julia.c create image 75 75 -image julia-pic

# Returns row of picture needing calculation.  Returns "done" when
# there are no more rows.
proc julia_next {} {
    share next_row n_rows julia_lock

    mutex lock $julia_lock
    if {$next_row>$n_rows} {mutex unlock $julia_lock ; return done}
    set row $next_row
    incr next_row
    mutex unlock $julia_lock
    return $row
}

# The procedure each threads runs to draw Julia set.
proc julia_calc {} {
    share p q xmin ymin maxiter deltax deltay n_columns

    for {set r 0} {$r<16} {incr r} {
	set color($r) [format "#%x%x%x" $r 0 [expr 15-$r]]
    }

# Draw until we get a message or the picture is done.
    while {[thread nextmsg 0 0 msg] == 0} {
	if {[set row [julia_next]] == "done"} {break}
	set x $xmin
	set y [expr $ymin + $row * $deltay]
	set data {}
	for {set xpix 0} {$xpix<$n_columns} {incr xpix} {
	    set k [julia $x $y $p $q $maxiter]
	    if {$k=="max"} {
		lappend data #000
	    } else {
		lappend data $color([expr $k%16])
	    }
	    set x [expr $x+$deltax]
	}
	thread post thread1 "julia-pic put [list [list $data]] \\
		-to 0 $row [expr $n_columns-1] [expr $row+1]"
    }

# Send a message when thread terminates so GUI can be updated.
# Also avoids need to use thread join.
    thread post thread1 "thread_return [thread self]"
}

# Threads are created detached so they don't have to be joined and
# bound so so they aren't starved for processing time.  The command
# thread setconcurrency could be used to accomplish the same thing.
proc add_thread {} {
    global threads thread_count next_row
    if {$thread_count == 0 && $next_row == 0} {julia-pic blank}
    lappend threads [thread create -detached -bound julia_calc]
    incr thread_count
    .threads.remove configure -state normal
}

# Send a message to make a Julia thread terminate.
proc remove_thread {} {
    global threads
    catch {thread post [lindex $threads 0] return}
}

# Invoked from a message sent by thread before it terminates.
# Updates the GUI.
proc thread_return {tid} {
    global threads thread_count next_row n_rows
    set index [lsearch -exact $threads $tid]
    if {$index != -1} {
	set threads [lreplace $threads $index $index]
	incr thread_count -1
	if {$thread_count == 0 && $next_row>$n_rows} {
	    .threads.remove configure -state disabled
	    set next_row 0
	}
    }
}
