share serverRoot mimeType
set serverRoot [pwd]
source mime.types

# Threads start here to handle a request.
proc handleRequest {socket} {
    if {[catch {processHTTP $socket} err]} {
	threaderror $err
    }
    close $socket
}

# Parse the request and deliver the data.  The implementation is
# pretty simplistic so may not correctly parse all requests.
proc processHTTP {socket} {
    share serverRoot mimeType

    if {[gets $socket request] == -1} {return}
    flush $socket

    set method [lindex $request 0]
    if {$method != "GET"} {return}

    set url [lindex $request 1]
    set filename "${serverRoot}$url"
    if {[regexp {/$} $url]} {
	set filename "${filename}index.html"
    }
    set ext [string range $filename \
	[expr [string last . $filename]+1] end]
    if {[catch {set mimeType($ext)} contentType]} {
	set contentType ""
    }

    set file [open $filename r]
    set contentLength [blob read $file [thread self]]
    close $file
    set header "HTTP/1.0 200 OK"
    puts $socket $header
    puts $socket "Content-length: $contentLength"
    if {$contentType != ""} {puts $socket "Content-type: $contentType"}
    puts $socket ""
    blob write $socket [thread self]
}

# Create thread to accept connections.  Each request is processed by
# a new thread.  Threads are created detached so they don't need to
# be joined.
set serverThread [thread create {
  set serverSocket [socket server 8000]
  while {1} {
    set clientSocket [socket accept $serverSocket]
    thread create -detached "handleRequest $clientSocket"
  }
}]

# Block until server thread terminates.  This will only happen if the
# server thread gets an error.
thread join $serverThread
