# Create synchronization variables and put philosophers in
# the thinking state.

share phil_mutex cond_var state
set phil_mutex [mutex create]
for {set p 0} {$p<5} {incr p}  {
    set cond_var($p) [cond create]
    set state($p) thinking
}

proc pickup {p} {
    share phil_mutex cond_var state
    mutex lock $phil_mutex
    set state($p) hungry
    try_to_eat $p
    while {$state($p) != "eating"} {
	cond wait $cond_var($p) $phil_mutex
    }
    mutex unlock $phil_mutex
}
proc putdown {p} {
    share phil_mutex cond_var state
    mutex lock $phil_mutex
    set state($p) thinking
    try_to_eat [expr ($p+4)%5]
    try_to_eat [expr ($p+1)%5]
    mutex unlock $phil_mutex
}
proc try_to_eat {p} {
    share cond_var state
    set l [expr ($p+4)%5]
    set r [expr ($p+1)%5]
    if {($state($l) != "eating") && ($state($p) == "hungry") &&
	($state($r) != "eating")} {
	set state($p) eating
	cond signal $cond_var($p)
    }
}

# Each philosopher thread starts here.
proc philosopher {p} {
    while {1}  {
	pickup $p
	putdown $p
    }
}

# Ensure there are enough thread resources to run 5 threads.
# Without this, the first philosopher thread would use all the
# program processing time and leave no time to create more
# threads.  This is a subtlety of Solaris which only applies
# to compute intensive threads.
thread setconcurrency 5

for {set p 0} {$p<5} {incr p}  {
    thread create "philosopher $p"
}

# Display the state of all philosophers every two seconds.
while {1}  {
    thread sleep 2
    mutex lock $phil_mutex
    for {set p 0} {$p<5} {incr p}  {
	puts -nonewline "$state($p) "
    }
    puts ""
    mutex unlock $phil_mutex
}
