entry .file -textvariable filename
bind .file <Return> add_file
focus .file
text .text -yscrollcommand ".scroll set"
scrollbar .scroll -command ".text yview"
pack .file -fill x
pack .scroll -side right -fill y
pack .text -fill x

# Threads are create with -detached so they don't need to be joined.
proc add_file {} {
    global filename
    set file [open $filename r]
    thread create -detached "tail_file $file $filename"
    .text insert end "Adding tail of file $filename ...\n"
    set filename {}
}

# Each thread runs this procedure
proc tail_file {file filename} {
    seek $file 0 end
    while {1} {
	while {[gets $file line] != -1} {
	    thread post thread1 ".text insert end [list $line\n]
				.text yview -pickplace end"
	}
	thread sleep 1
    }
}
