/*
 * Copyright (c) 1995 Sun Microsystems, Inc.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL SUN MICROSYSTEMS, INC. BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 * OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN
 * MICROSYSTEMS, INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * SUN MICROSYSTEMS, INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED
 * HEREUNDER IS ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS, INC. HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 */

#include "tcl_thread.h"

extern int Socket_tcl_Init( Tcl_Interp *interp);
extern int Julia_tcl_Init( Tcl_Interp *interp);

main( int argc, char *argv[])
{
    Tcl_Main(argc, argv, Tcl_AppInit);
    return 0;
}
 
int
extclsh_Init( Tcl_Interp *interp)
{
    if ( Socket_tcl_Init( interp) == TCL_ERROR)
        return TCL_ERROR;
    if ( Julia_tcl_Init( interp) == TCL_ERROR)
        return TCL_ERROR;
    return TCL_OK;
}


int
Tcl_AppInit( Tcl_Interp *interp)
{
    if (Tcl_Init(interp) == TCL_ERROR)
        return TCL_ERROR;
 
    if ( Tcl_thread_Init( interp) == TCL_ERROR)
        return TCL_ERROR;
    if ( extclsh_Init( interp) == TCL_ERROR)
        return TCL_ERROR;
 
    MTtcl_SetThreadInitFunc( extclsh_Init);
 
    return TCL_OK;
}

