/* 
 * julia.c --
 *
 *      Tcl command to calculate Julia set membership.
 *
 *  Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tcl.h"

Tcl_CmdProc JuliaCmd;

int
Julia_tcl_Init( Tcl_Interp *interp)
{
    Tcl_CreateCommand( interp, "julia", JuliaCmd, 0, 0);
    return TCL_OK;
}

int
JuliaCmd(
    ClientData  clientData,
    Tcl_Interp *interp,
    int         argc,
    char      **argv
)
{
    double x, y, p, q, r;
    double xkp1, ykp1, ya;
    int k, maxiter;

    if ( Tcl_GetDouble( interp, argv[1], &x) == TCL_ERROR)
	return TCL_ERROR;
    if ( Tcl_GetDouble( interp, argv[2], &y) == TCL_ERROR)
	return TCL_ERROR;
    if ( Tcl_GetDouble( interp, argv[3], &p) == TCL_ERROR)
	return TCL_ERROR;
    if ( Tcl_GetDouble( interp, argv[4], &q) == TCL_ERROR)
	return TCL_ERROR;
    if ( Tcl_GetInt( interp, argv[5], &maxiter) == TCL_ERROR)
	return TCL_ERROR;

    k= 0;
    do  {
        xkp1 = (x+y)*(x-y) + p;
        ya   = x*y;
        ykp1 = ya + ya + q;
        r    = xkp1*xkp1 + ykp1*ykp1;
        k++;
	if ( r > maxiter)  {
	    sprintf( interp->result, "%d", k);
	    return TCL_OK;
	}
	if ( k >= maxiter)  {
	    interp->result= "max";
	    return TCL_OK;
	}
	x= xkp1;
	y= ykp1;
    } while (1);
}

