#!./extclsh
#
# Multi-threaded http server
#
# Copyright (c) 1995 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

share serverRoot mimeType
set serverRoot [pwd]
source mime.types

proc handleRequest {socket} {
    if {[catch {processHTTP $socket} err]} {
	threaderror $err
    }
    socket shutdown $socket
    close $socket
}

proc processHTTP {socket} {
    share serverRoot mimeType

    if {[gets $socket request] == -1} {return}
    flush $socket

    set method [lindex $request 0]
    if {$method != "GET"} {return}

    set url [lindex $request 1]
    set filename "${serverRoot}$url"
    if {[regexp {/$} $url]} {
	set filename "${filename}index.html"
    }
    set ext [string range $filename \
	[expr [string last . $filename]+1] end]
    if {[catch {set mimeType($ext)} contentType]} {
	set contentType ""
    }

    set file [open $filename r]
    set contentLength [blob read $file [thread self]]
    close $file
    set header "HTTP/1.0 200 OK"
    puts $socket $header
    puts $socket "Content-length: $contentLength"
    if {$contentType != ""} {puts $socket "Content-type: $contentType"}
    puts $socket ""
    blob write $socket [thread self]
}

set serverThread [thread create -bound {
  set serverSocket [socket server 8000]
  while {1} {
    set clientSocket [socket accept $serverSocket]
    thread create -detached "handleRequest $clientSocket"
  }
}]
thread join $serverThread
