#!./exwish -f
#
# Perform tail(1) like operation on multiple files.
#
# Copyright (c) 1995 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

entry .file -textvariable filename
bind .file <Return> {add_file}
focus .file
text .text -yscrollcommand ".scroll set"
scrollbar .scroll -command ".text yview"
pack .file -fill x
pack .scroll -side right -fill y
pack .text -fill x

proc add_file {} {
    global filename
    set file [open $filename r]
    thread create -detached "tail_file $file $filename"
    .text insert end "Adding tail of file $filename ...\n"
    set filename {}
}
proc tail_file {file filename} {
    seek $file 0 end
    while {1} {
	while {[gets $file line] != -1} {
	    thread post thread1 ".text insert end [list $line\n]
				.text yview -pickplace end"
	}
	thread sleep 1
    }
}
