'\"
'\" Copyright (c) 1994,1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.so mttcl.macros
.HS cond MTtcl
.BS
.SH NAME
cond \- condition variables
.SH SYNOPSIS
\fBcond create\fR
.br
\fBcond destroy \fIcond-id\fR
.br
\fBcond wait \fIcond-id mutex-id\fR
.br
\fBcond signal \fIcond-id\fR
.br
\fBcond broadcast \fIcond-id\fR
.br
\fBcond timedwait \fIcond-id mutex-id seconds \fR?\fInano-seconds\fR?
.BE
 
.SH DESCRIPTION
.PP
A condition variable enables threads to atomically block until
a condition is satisfied.
The condition is tested under the protection of a mutual exclusion lock
(mutex).  When the condition is false, a thread typically blocks on a
condition variable and atomically releases the mutex waiting for the
condition to change.  When another thread changes the condition, it may
signal the associated condition variable to cause one or more waiting
threads to wake up, reacquire the mutex, and re-evaluate the
condition.
.LP
Condition variables can be used to synchronize threads in this process
and other processes if they are allocated in memory that is writable
and shared among the cooperating processes (see \fBmmap\fR(2))
and have been created for this behavior.  This feature is not
directly available with MTtcl condition variables.
.LP
\fBcond create\fR initializes a new condition variable with the
given count and returns its \fIcond-id\fR.  The condition variable
can only be used in this process; type is \fBUSYNC_THREAD\fR.
.LP
\fBcond destroy\fR destroys the given condition variable.
.LP
\fBcond wait\fR atomically releases the given mutex and causes the
calling thread to block on the given condition variable.  The
blocked thread may be awakened by \fBcond signal\fR,
\fBcond broadcast\fR, or when interrupted by delivery of a signal or
an \fBexec\fR.  Any change in value of a condition associated with
the condition variable cannot be inferred by the return of \fBcond wait\fR
and any such condition must be re-evaluated.
.LP
\fBcond signal\fR unblocks one thread that is blocked on the
given condition variable.
.LP
\fBcond broadcast\fR unblocks all threads that are blocked on the
given condition variable.
.LP
If no threads are blocked on the condition variable then
\fBcond signal\fR and \fBcond broadcast\fR have no effect.
.LP
Both functions should be called under the protection of the same
mutex that is used with the condition variable being signalled.
Otherwise the condition variable may be signalled between the test of the
associated condition and blocking in \fBcond wait\fR.  This can
cause an infinite wait.
.LP
\fBcond timedwait\fR is similar to \fBcond wait\fR, except that
the calling thread will not block past the time specified.  If
\fB-absolute\fR is specified the time is the seconds since
00:00:00 UTC, January 1, 1970.  Otherwise the time is taken to
be a time-out from the current time.  If the time of day becomes
greater than the specified time, then \fBcond timedwait\fR
returns with an error.
.SH COND IDS
The \fIcond-ids\fR are formed by appending the memory address of
the condition variable to the string ``cond''.
.SH SEE ALSO
mutex(n), signal(2), exec(n)
.SH BUGS
Using the memory address in the \fIcond-id\fR is a cheap hack
.sp
There seems to be a minimum sleep time of 10 milli-seconds in
Solaris 2.
.SH EXAMPLE
\fBcond wait\fR is normally used in a loop testing some condition;
.DS
mutex lock $mutex
while {$something == 0}  {
    cond wait $cond $mutex
}
mutex unlock $mutex
.DE
