'\"
'\" Copyright (c) 1994,1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so mttcl.macros
.HS mutex MTtcl
.BS
.SH NAME
mutex \- mutual exclusion locks
.SH SYNOPSIS
\fBmutex create\fR
.br
\fBmutex destroy \fImutex-id\fR
.br
\fBmutex lock \fImutex-id\fR
.br
\fBmutex unlock \fImutex-id\fR
.br
\fBmutex trylock \fImutex-id\fR
.BE
 
.SH DESCRIPTION
.PP
Mutual exclusion locks (mutexes) are used to serialize the execution
of Tcl threads.  They are typically used to ensure that only one
thread executes a critical section of code at any one time (mutual
exclusion).
.LP
Mutexes can be used to synchronize threads in this process and
other processes if they are allocated in memory that is writable
and shared among the cooperating processes (see \fBmmap\fR(2))
and have been created for this behavior.  This feature is not
directly available with MTtcl mutexes.
.LP
\fBmutex create\fR initializes a new mutex and returns its
\fImutex-id\fR.  The mutex can only be used in this process; type
is \fBUSYNC_THREAD\fR.
.LP
\fBmutex destroy\fR destroys the given mutex.
.LP
\fBmutex lock\fR locks the given mutex.  If the mutex is already locked,
the calling thread blocks until the mutex becomes available.  When
\fBmutex lock\fR returns, the mutex is locked and the calling thread
is the owner.
.LP
\fBmutex trylock\fR attempts to lock the given mutex.  If the mutex is
already locked it returns with an error.  Otherwise the mutex
is locked and the calling thread is the owner.
.LP
\fBmutex unlock\fR unlocks the given mutex.  The mutex must be locked
and the calling thread must be the one that last locked the mutex (the
owner).  If any other threads are waiting for the mutex to become
available, one of them is unblocked.
.SH MUTEX IDS
The \fImutex-ids\fR are formed by appending the memory address of
the mutex to the string ``mutex''.
.SH SEE ALSO
cond(n)
.SH BUGS
Using the memory address in the \fImutex-id\fR is a cheap hack
