'\"
'\" Copyright (c) 1994,1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so mttcl.macros
.HS rwlock MTtcl
.BS
.SH NAME
rwlock \- multiple readers, single writer locks
.SH SYNOPSIS
\fBrwlock create\fR
.br
\fBrwlock destroy \fIrwlock-id\fR
.br
\fBrwlock read \fIrwlock-id\fR
.br
\fBrwlock write \fIrwlock-id\fR
.br
\fBrwlock unlock \fIrwlock-id\fR
.br
\fBrwlock tryread \fIrwlock-id\fR
.br
\fBrwlock trywrite \fIrwlock-id\fR
.BE
 
.SH DESCRIPTION
.PP
Multiple readers, single writer (readers/writer) locks allow many
threads to have simultaneous read-only access to data while allowing
only one thread to have write access at any given time.
They are typically used to protect data that is searched more
frequently than it is changed.
.LP
Readers/writer locks can be used to synchronize threads in this process
and other processes if they are allocated in memory that is writable
and shared among the cooperating processes (see \fBmmap\fR(2))
and have been created for this behavior.  This feature is not
directly available with MTtcl readers/writer locks.
.LP
\fBrwlock create\fR initializes a new readers/writer lock and returns its
\fIrwlock-id\fR.  The lock can only be used in this process; type
is \fBUSYNC_THREAD\fR.
.LP
\fBrwlock destroy\fR destroys the given readers/writer lock.
.LP
\fBrwlock read\fR acquires a read lock on the given readers/writer lock.
If the readers/writer lock is already locked for writing,
the calling thread blocks until the write lock is released.
More than one thread may hold a read lock on a readers/writer lock
at any one time.
.LP
\fBrwlock write\fR acquires a write lock on the given readers/writer lock.
If the readers/writer lock is already locked for reading or writing,
the calling thread blocks until all the read locks and write locks are
released.
Only one thread may hold a write lock on a readers/writer lock
at any one time.
.LP
\fBrwlock tryread\fR attempts to acquire a read lock on the given
readers/writer lock.  If the readers/writer lock is already locked for
writing, it returns an error.  Otherwise the read lock is acquired.
.LP
\fBrwlock trywrite\fR attempts to acquire a write lock on the given
readers/writer lock.  If the readers/writer lock is already locked
for reading or writing, it returns an error.
.LP
\fBrwlock unlock\fR unlocks the given readers/writer lock.  The
readers/writer lock must be locked and the calling thread must hold the
lock either for reading or writing.  If any other threads are waiting
for the readers/writer lock to become available, one of them is
unblocked.
.SH RWLOCK IDS
The \fIrwlock-ids\fR are formed by appending the memory address of
the readers/writer lock to the string ``rwlock''.
.SH BUGS
Using the memory address in the \fIrwlock-id\fR is a cheap hack
.sp
\fBrwlock tryread\fR actually works like \fBrwlock read\fR.  This is
a bug in Solaris 2.
