'\"
'\" Copyright (c) 1994,1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so mttcl.macros
.HS share MTtcl
.BS
.SH NAME
share \- Share variables between Tcl threads
.SH SYNOPSIS
\fBshare \fR?\fB-global\fR? \fIvariable \fR?\fIvariable ...?\fR
.BE
 
.SH DESCRIPTION
.PP
The \fBshare\fR command allows variables to be shared between
Tcl threads.  The named variables are entered into the current
scope linked to a shared representation of the variable.  All
threads that share the same variable, share a common value for
the variable.
.LP
If \fB-global\fR is specified, the variable is entered into the
global scope as well as the current scope.
.LP
Use of shared variables is reference counted.  For each thread
and scope that shares a given variable, its reference count is
incremented.  When a scope exits or a thread terminates, the
reference count of variables shared therein are decremented.
When \fB-global\fR is used, the reference count is incremented
once for the entry in the current scope and once for the entry
in the global scope.  Care should be taken when using \fBshare\fR
in procedures.
.SH MT PROGRAMMING
Shared variables are not protected from simultaneous access
from multiple threads.  Use the synchronization facilities of
MTtcl to serialize access to critical variables.
.SH SEE ALSO
mutex(n), sema(n), cond(n), rwlock(n), thread(n)
.SH BUGS
Can't list the shared variables
.sp
The semantics of \fBshare\fR can be surprising
.sp
Can't share arrays
