/* 
 * tcl_thread.h --
 *
 *	This file describes the Tcl threads "C" API.
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TCL_THREAD_H
#define _TCL_THREAD_H

#include "tcl.h"

EXTERN int	Tcl_thread_Init _ANSI_ARGS_(( Tcl_Interp *interp));
EXTERN int	Tk_thread_Init _ANSI_ARGS_(( Tcl_Interp *interp));
EXTERN void	MTtcl_SetThreadInitFunc _ANSI_ARGS_((
			int (*init_func)( Tcl_Interp *)));
EXTERN int	MTtcl_MessageNotifier _ANSI_ARGS_(( Tcl_Interp *,
			char *tcl_thread_id, int fd[2]));

EXTERN int	MTtcl_MessageCount _ANSI_ARGS_((void));
EXTERN int	MTtcl_NextMessage _ANSI_ARGS_(( Tcl_Interp *interp,
			char **message));
EXTERN int	MTtcl_PostMessage _ANSI_ARGS_(( Tcl_Interp *interp,
			char *tcl_thread_id, char *message));

#define MTTCL_OK                        0
#define MTTCL_INVALID_THREAD            1
#define MTTCL_UNKNOWN_THREAD            2

#endif
