/*
 * synch.c --
 *
 *      This file contains the internal data structures and APIs of
 *	Tcl threads.
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _H_TCL_THREADP
#define _H_TCL_THREADP

#include <thread.h>

/*
 * There is a Tcl_Thread for every thread created with thread create.
 * The struct is freed when the thread is joined via thread join.
 */

typedef struct {
    Tcl_Interp *interp;
    thread_t tid;
    mutex_t lock;
    char *script;
    char *thr_name;
    int eval_rc;
    int evaluating;
    char *status;
    char *result;
    char **messages;
    unsigned int msg_array_max;
    unsigned int msg_array_len;
    unsigned int msg_array_next;
    cond_t msg_cond;
    int msg_notifier_pipe[2];
    Tcl_CmdInfo proc_info;
    Tcl_CmdInfo rename_info;
    Tcl_CmdInfo info_info;
    unsigned int flags;
} Tcl_Thread;

int InitSharedProcTable( Tcl_Thread *first_thread);
void InitProcSharing( Tcl_Thread *tcl_thread);
extern int tcl_thread_count;

#endif

