/* 
 * tk_thread.c --
 *
 *	Simple extension which connects Tcl thread messaging to the
 *	Tk event processor.
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tcl_thread.h"
#include "tk.h"
#include <errno.h>
#include <sys/types.h>
#include <fcntl.h>

static void MessageReady( ClientData clientData, int mask);

static char *tk_default_error_handler= 
"proc threaderror {err} {\n"
"    global errorInfo\n"
"    set errinfo {}\n"
"    if {![catch {set errorInfo}]} {\n"
"        set errinfo \"set errorInfo [list [set errorInfo]]\"\n"
"    }\n"
"    set msg \"$errinfo ; tkerror [list [list [thread self] $err]]\"\n"
"    thread post thread1 $msg\n"
"}";

int
Tk_thread_Init( Tcl_Interp * interp)
{
    if ( Tcl_thread_Init( interp) == TCL_ERROR)
	return TCL_ERROR;

    if ( thr_self() == 1)  {
	int fd[2];
	if ( pipe( fd) == -1)  {
	    Tcl_AppendResult( interp, "Tk threads could not init notifier; ",
		strerror( errno), NULL);
	    return TCL_ERROR;
	}
	fcntl( fd[0], F_SETFD, 1);	/* set close-on-exec bit */
	fcntl( fd[1], F_SETFD, 1);
	Tk_CreateFileHandler( fd[0], TK_READABLE, MessageReady, interp);
	MTtcl_MessageNotifier( interp, "thread1", fd);
	if ( Tcl_GlobalEval( interp, tk_default_error_handler) == TCL_ERROR)
	    fprintf( stderr, "tk_default_error_handler %s\n", interp->result);
    }
    return TCL_OK;
}

void
MessageReady( ClientData clientData, int mask)
{
    Tcl_Interp *interp= (Tcl_Interp *) clientData;
    int rc;
    char *message;

    if ( MTtcl_NextMessage( interp, &message) == TCL_ERROR)
	return;
    rc= Tcl_GlobalEval( interp, message);
    free( message);
    if (rc != TCL_OK) {
        Tcl_AddErrorInfo(interp, "\n    (\"thread post\" script)");
        Tk_BackgroundError(interp);
	return;
    }
}

/*
void
MessageReady( ClientData clientData, int mask)
{
    Tcl_Interp *interp= (Tcl_Interp *) clientData;
    int rc, count;
    char *message;

    count= MTtcl_MessageCount();
    while ( count > 0)  {
	if ( MTtcl_NextMessage( interp, &message) == TCL_ERROR)
	    return;
	rc= Tcl_GlobalEval( interp, message);
	free( message);
	if (rc != TCL_OK) {
            Tcl_AddErrorInfo(interp, "\n    (\"thread post\" script)");
            Tk_BackgroundError(interp);
	    return;
	}
	count--;
    }
}
*/
