### Examples for tclProp.tcl v2.0. Requires OAT and TkOAT
### extensions.

set top .top
catch {destroy $top}
toplevel $top
set canv $top.c
catch {destroy $canv}
catch {trace wdelete $top -width w  {TP_objPropChange widget}}
catch {trace cdelete $canv rect -fill w {TP_citemPropChange widget}}

pack [canvas $canv]
$canv create rect 10 10 100 50 -fill red -tag rect; 
$canv create rect 10 60 100 100 -fill blue -tag rect1;
#$canv itemconf rect -width 5
#pack forget .top.c

proc InitFormulas { } {
  global top canv

  set TP_evalMode "eager"
  foreach trace $TP_dirtySrcList { TP_genPropChange $trace }
#  foreach trace $TP_dirtySrcList { TP_genPropChange $tracevariable $var {} "w"}

  ### Formula with Tcl variable as the destination, and an object (Tk widget) 
  ### attribute as the source.
  ### Source object attribute is referenced in the code via a tag.
  TP_formula \
    a \
    [list [list topwidth [list widget $top -width]]] \
    {expr 2*$topwidth}

  ### Formula with object (Tk widget) attribute as a destination AND source.
  ### Source object attribute is referenced in the code via a tag.
  TP_formula \
    [list widget $top -height] \
    [list \
       [list topwidth [list widget $top -width]] \
       [list topbdwidth [list widget $top -borderwidth]]] \
    {expr $topwidth - $topbdwidth}

  # Testing propagagion...
  #for {set i 0} {$i < 200} {incr i} {$top conf -width $i; update}

  ### Formula with canvas item attribute as source, Tcl variable
  ### as destination. Source canvas item accessed via a tag.
  TP_formula \
    rectwidth \
    [list \
       [list rectwidth [list citem $canv rect -width]]] \
    {quote $rectwidth}

  ### Formula with canvas item attribute as source. Source has no tag.
  TP_formula \
    rectwidth \
    [list \
       [list citem $canv rect -width]] \
    {$canv itemcget rect -width}

  ### Formulas with canvas item attribute as destination AND source.
  TP_formula \
    [list rect1width [list citem $canv rect1 -width]] \
    [list \
       [list rectwidth [list citem $canv rect -width]]] \
    {quote $rectwidth}

  TP_formula \
    [list citem $canv rect1 -width] \
    [list \
       [list rectwidth [list citem $canv rect -width]]] \
    {quote $rectwidth}

  TP_formula \
    [list citem $canv rect1 -width] \
    [list \
       [list citem $canv rect -width]] \
    {$canv itemcget rect -width}

  ### Formula with canvas item attribute as a destination,
  ### Tcl variable ``d'' as a source.
  TP_formula [list citem $canv rect1 -width] {d} {set d}
}

set objType  "widget"
set objName  "$top"
set attrName "-width"
set tag "topwidth"
set code {expr 2*$topwidth}
