.TH "TP_formula" n "August 3, 1995" "TclProp 1.1" "TclProp 1.1 Commands"
.SH NAME
TP_formula - create a TclProp formula 
.SH SYNOPSIS
.PP
TP_formula \fIdest\fP \fIsrc-list\fP \fIformula-code\fP
.SH DESCRIPTION
.PP
TP_formula creates a formula that updates the global variable \fIdest\fP
whenever any of the global variables in \fIsrc-list\fP changes.  The
destination variable is defined to be the result of evaluating the
\fIformula-code\fP at the global level.
.PP
TP_formula returns a formula identifier which is reserved for later use in
extensions that allow the relaxation and deletion of formulas.
.SH NOTE
.PP
As a side effect, TP_formula executes the formula once when it is
established.  If the formula code cannot be executed (e.g., if some of the
variables have not yet been set) it catches the error and fails silently.  The
formula is still in place and will be evaluated the next time a source
variable changes.
.SH SEE ALSO
.PP
TclProp(n), TP_trigger(n), TP_makeVar(n), trace(n), tkvp(n)
.SH AUTHOR
.PP
Joseph A. Konstan (konstan@cs.umn.edu) 
.PP
Sunanda Iyengar (iyengar@cs.umn.edu)
.SH MAILING LIST
.PP
tclprop@cs.umn.edu 
.PP
subscription requests to tclprop-request@cs.umn.edu
