.TH "TP_trigger" n "August 3, 1995" "TclProp 1.1" "TclProp 1.1 Commands"
.SH NAME
TP_trigger - create a TclProp trigger 
.SH SYNOPSIS
.PP
TP_trigger \fIsrc-list\fP \fItrigger-code\fP
.SH DESCRIPTION
.PP
TP_trigger defines a trigger whose \fItrigger-code\fP is executed whenever one
of the variables in the \fIsrc-list\fP is updated.  It is an alternative to
trace that can be used when specific code, to be executed in the global
environment, should be attached to a change in a global variable.  TclProp
prevents the code from executing when the variable is set to the same value it
already has, and cuts off propagation loops.
.PP
TP_trigger returns a trigger identifier which is reserved for later use in
extensions that allow the relaxation and deletion of triggers and formulas.
.SH NOTE
.PP
As a side effect, TP_trigger executes the trigger once when it is
established.  If the trigger code cannot be executed (e.g., if some of the
variables have not yet been set) it catches the error and fails silently.  The
trigger is still in place and will be evaluated the next time a source
variable changes.
.SH SEE ALSO
.PP
TclProp(n), TP_formula(n), TP_makeVar(n), trace(n), tkvp(n)
.SH AUTHOR
.PP 
Joseph A. Konstan (konstan@cs.umn.edu) 
.PP 
Sunanda Iyengar (iyengar@cs.umn.edu)
.SH MAILING LIST
.PP
tclprop@cs.umn.edu 
.PP
subscription requests to tclprop-request@cs.umn.edu
