## *******************************************************************
## 
##  File "screen.tcl" contains the code which configures the screen 
##  for the game, "Video Poker".
##
## *******************************************************************

## *************  Initialization of program variables  ***************  

set status   {}
set credits 100
set bet_amt   0
set max_bet   5

                                        ; ##   Array indicating the status
for {set i 1} {$i <= 5} {incr i}  {     ; ##   of the cards in the player's 
     set hold($i) 0                     ; ##   hand.  hold($i) is set to 
}                                       ; ##   true if the ith card is
                                        ; ##   being held.

option add Tk*background "seashell3"


wm title    . "VIDEO POKER"             ; ##   Parent window configurations
wm geometry . =700x400
wm iconname . "Video Poker"


set screen .poker                       ; ##   Main frame configurations
frame $screen                \
      -height 400            \
      -width  700            \
      -relief ridge          \
      -borderwidth 3


## *******************************************************************
## *                Create Main Menubar and Menus                    *
## *******************************************************************

set options $screen.options     

frame $options               \
      -relief ridge          \
      -height 15             \
      -borderwidth 3 

menubutton $options.game                 	    \
      -background "seashell2"                       \
      -activebackground "Old lace"                  \
      -font "-Adobe-times-medium-r-normal--*-180*"  \
      -relief ridge                                 \
      -borderwidth 2                                \
      -menu $options.game.menu                      \
      -text "Poker"                                 \
      -anchor center                                \
      -padx 3 -pady 3

menu $options.game.menu                             \
     -background "seashell2"                        \
     -font "-Adobe-times-medium-r-normal--*-180*" 

$options.game.menu add command                      \
     -label " New Bankroll "                        \
     -font "-Adobe-times-medium-r-normal--*-180*"   \
     -command { set credits 100 }                   \
     -activebackground "Old lace"

$options.game.menu add separator

$options.game.menu add command                      \
     -label " Quit     "                            \
     -font "-Adobe-times-medium-r-normal--*-180*"   \
     -command {exit}                                \
     -activebackground "Old lace"

menubutton $options.payoffs                         \
      -background "seashell2"                       \
      -activebackground "Old lace"                  \
      -font "-Adobe-times-medium-r-normal--*-180*"  \
      -relief ridge                                 \
      -borderwidth 2                                \
      -menu $options.payoffs.menu                   \
      -text "Payoffs"                               \
      -anchor center                                \
      -padx 3 -pady 3

menu $options.payoffs.menu    \
     -background "seashell2"  \
     -font "-Adobe-times-medium-r-normal--*-180*"


$options.payoffs.menu add command                \
     -label "Royal Flush        500"             \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Straight Flush     100"             \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command               \
     -label "Four of a Kind      25"            \
     -font "-Adobe-times-bold-r-normal--*-140*" \
     -activebackground "Old lace"


$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Full House             9"           \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Flush                     6"        \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Straight                 4"         \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Three of a Kind     3"              \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Two Pair                2"          \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"


$options.payoffs.menu add separator

$options.payoffs.menu add command                \
     -label "Jacks or Better     1"              \
     -font "-Adobe-times-bold-r-normal--*-140*"  \
     -activebackground "Old lace"

## *******************************************************************
##                 Status bar and corresponding frame 
## *******************************************************************

frame $screen.status  

label $screen.status.statusbar                   \
     -font "-Adobe-times-bold-r-normal--*-180*"  \
     -borderwidth 5    \
     -relief ridge     \
     -width 70         \
     -height 1         \
     -foreground black \
     -text $status     \
     -textvariable status  

pack $screen.status.statusbar   \
     -side bottom               \
     -padx 10 -pady 10 

pack $screen.status  \
     -side bottom    \
     -fill x 
     

pack $options.game $options.payoffs   \
     -side left                       \
     -fill x                          \
     -expand true                     \
     -ipadx 3 -ipady 3                \
     -padx 2 -pady 2

pack $options        \
     -side top       \
     -padx 2 -pady 2 \
     -fill x


## *******************************************************************
## *   Create widgets to display the player's holdings (credits)     *
## *   and the current bet amount.                                   *
## *******************************************************************

set betstats $screen.bet

frame $betstats 

frame $betstats.bankroll  \
      -relief ridge       \
      -bd 3 

label $betstats.bankroll.header                    \
      -font  "-Adobe-times-bold-r-normal--*-140*"  \
      -anchor center           \
      -relief ridge            \
      -bd 3                    \
      -pady 3                  \
      -text "Bankroll"

label $betstats.bankroll.amount  \
      -background "seashell2"    \
      -font  "-Adobe-times-medium-r-normal--*-180*"  \
      -pady 3                    \
      -anchor center             \
      -text $credits             \
      -textvariable credits


frame $betstats.betamt  \
      -relief ridge     \
      -bd 3 

label $betstats.betamt.header  \
      -font  "-Adobe-times-bold-r-normal--*-140*"  \
      -anchor center           \
      -relief ridge            \
      -bd 3                    \
      -text "Amount Bet"

label $betstats.betamt.amount  \
      -background "seashell2"  \
      -font  "-Adobe-times-medium-r-normal--*-180*"  \
      -anchor center           \
      -text $bet_amt           \
      -textvariable bet_amt

button $betstats.betone              \
       -background "seashell2"       \
       -font  "-Adobe-times-medium-r-normal--*-180*"  \
       -text "Bet One"               \
       -padx 3 -pady 3               \
       -activebackground "Old lace"  \
       -relief raised                \
       -borderwidth 3                \
       -command { set bet_amt [incr bet_amt];
                  set credits [incr credits -1] }
     

button $betstats.betmax              \
       -background "seashell2"       \
       -font  "-Adobe-times-medium-r-normal--*-180*"  \
       -text "Bet Max"               \
       -padx 3 -pady 3               \
       -activebackground "Old lace"  \
       -relief raised                \
       -borderwidth 3                \
       -command {set_bet_amt}
     
pack $betstats.bankroll.header $betstats.bankroll.amount \
     -side top  \
     -fill x

pack $betstats.betamt.header $betstats.betamt.amount \
     -side top           \
     -ipadx 5 -ipady 3   \
     -fill x

pack $betstats.betmax $betstats.betone $betstats.betamt $betstats.bankroll \
     -side bottom     \
     -padx 5 -pady 10 \
     -fill x

pack $betstats    \
     -side right  \
     -fill y      \
     -anchor n
     
## *******************************************************************
## *             Create Display for Player's Hand                    *
## *******************************************************************
   
set playerhand  $screen.hand

frame $playerhand 

set cardstats $playerhand.deck

for {set i 1}  {$i <= 5}  {incr i}  {
       frame $cardstats$i  \
              -relief flat

       label $cardstats$i.card         \
             -relief ridge             \
             -background "OldLace"     \
             -borderwidth 3 

       button $cardstats$i.btn             \
              -background "seashell2"      \
              -activebackground "Old lace" \
              -font "-Adobe-times-medium-r-normal--*-180*"  \
              -textvariable btn$i          \
              -anchor center               \
              -relief raised               \
              -width 5                     \
              -command "set hold($i) 1"    \
              -padx 15                     \
              -pady  3                     \
              -borderwidth 2

       pack $cardstats$i.card $cardstats$i.btn  \
              -side top        \
              -padx 7 -pady 7  \
              -anchor s        \
              -fill y

       pack $cardstats$i   \
            -side left     \
            -anchor s      \
            -padx 3 -pady 3
}

## *******************************************************************
## *  Create Display for Game Options:  "Deal", "Stand", "Cancel",   *
## *  and "Draw".                                                    *
## *******************************************************************

set gameopts $screen.game

frame $gameopts

button $gameopts.deal  \
       -text "DEAL"    \
       -font "-Adobe-times-medium-r-normal--*-180*"  \
       -background "seashell2"       \
       -anchor center                \
       -relief raised                \
       -borderwidth 3                \
       -activebackground "Old lace"  \
       -command {set mode draw}      \
       -padx 4  

button $gameopts.stand  \
       -text "STAND"    \
       -font "-Adobe-times-medium-r-normal--*-180*"  \
       -background "seashell2"              \
       -anchor center                       \
       -relief raised                       \
       -borderwidth 3                       \
       -activebackground "Old lace"         \
       -command {hold_all ; set mode pay}   \
       -padx 4 

button $gameopts.cancel  \
       -text "CANCEL"    \
       -font "-Adobe-times-medium-r-normal--*-180*"  \
       -background "seashell2"       \
       -anchor center                \
       -relief raised                \
       -borderwidth 3                \
       -activebackground "Old lace"  \
       -padx  4                      \
       -command {clear_holds}   

button $gameopts.draw  \
       -text "DRAW"    \
       -font "-Adobe-times-medium-r-normal--*-180*"  \
       -background "seashell2"       \
       -anchor center                \
       -relief raised                \
       -borderwidth 3                \
       -activebackground "Old lace"  \
       -command {set mode pay}       \
       -padx 4 


pack $gameopts.deal $gameopts.stand $gameopts.cancel $gameopts.draw  \
     -side left        \
     -padx 25          \
     -ipadx 5 -ipady 5 \
     -anchor s



## *******************************************************************
## *                     Pack container frames                       *
## *******************************************************************

pack $playerhand     \
     -side top       \
     -anchor s       \
     -padx 5 -pady 5 \
     -fill y

pack $gameopts       \
     -side bottom    \
     -anchor n       \
     -padx 5 -pady 5 \
     -fill both

pack $screen       \
     -side top     \
     -expand true  \
     -fill both


## *******************************************************************
## *  Procedure to reset the values of the "hold" array to "nil"     *
## *  indicating that none of the cards in the player's hand are     *
## *  being held.                                                    * 
## *******************************************************************

proc clear_holds {}  {
     global hold

     for {set i 1} {$i <= 5} {incr i}  {
          set hold($i) 0 
     }
}


## *******************************************************************
## *  Procedure to set the values of the "hold" array to "t"         *
## *  indicating that all of the cards in the player's hand are      *
## *  being held.                                                    * 
## *******************************************************************

proc hold_all {}  {
     global hold

     for {set i 1} {$i <= 5} {incr i}  {
          set hold($i) 1 
     }
}

## *******************************************************************
## *  Procedure to set the amount bet.  This procedure is called     *
## *  when the "Bet Max" button is pressed.  The amount bet is       *
## *  determined by evaluating the current amount bet and the        *
## *  current amount of credits possessed by the player.             *
## *******************************************************************

proc set_bet_amt {}  {
     global max_bet
     global bet_amt
     global credits

     set temp_bet [expr $max_bet - $bet_amt]
     if {$temp_bet > $credits}  {
         set temp_bet $credits
     }
     set credits [expr $credits - $temp_bet]
     set bet_amt  [incr bet_amt $temp_bet]
}
