/*
 * oatInt.h --
 *
 *	Internal declarations for OAT - Object Attribute Trace
 *      extension to Tcl.
 *
 * Copyright (c) 1996 University of Minnesota.
 *
 * RCS: $Id: oatInt.h,v 1.3 1996/11/03 02:11:31 safonov Exp safonov $
 */

#ifndef _OATINT_H
#define _OATINT_H


#ifndef _TCL
#include <tcl.h>
#endif

/*
 * The following structure is allocated for each object attribute trace 
 * created. It is used to store operations for which C function pointed to
 * by `traceProc' should be invoked, and `clientData' argument to be 
 * passed to that function.
 */

typedef struct OatTrace {
  Oat_TraceProc *traceProc;  /* Procedure to call when operations given
			      * by flags are performed on object attr. */
  ClientData clientData;     /* Argument to pass to traceProc */
  int flags;		     /* What events the trace procedure is
			      * interested in:  OR-ed combination of
			      * TCL_TRACE_READS, TCL_TRACE_WRITES, and
			      * TCL_TRACE_UNSETS. */
  struct OatTrace *nextPtr;  /* Next in list of traces associated with
			      * a particular object and attribute. */
} OatTrace;

typedef struct OatTraceHeader {
  char* nameSpace;           /* name space where the traced object lives,
			      * such as the canvas name for a canvas item */
  char* objName;             /* name of the object on which trace is set */
  char* attrName;            /* name of the object attribute on which
			      * trace is set */
  int traceActive;           /* TRUE if a trace procedure is currently active 
			      * for this object and attribute */
  int refCount;              /* number of trace procedures active for this 
			      * trace */
  OatTrace *firstTracePtr;   /* First in list of traces associated
			      * with the particular object and attribute. */
} OatTraceHeader;

/*
 * When a variable trace is active (i.e. its associated procedure is
 * executing), one of the following structures is linked into a list
 * associated with the variable's interpreter.  The information in
 * the structure is needed in order for Tcl to behave reasonably
 * if traces are deleted while traces are active.
 */

typedef struct OatActiveTrace {
  OatTraceHeader* traceHeaderPtr;  /* object and attribute traced. */
  struct OatActiveTrace *nextPtr;  /* Next in list of all active object
				    * traces for the interpreter, or NULL
				    * if no more. */
  OatTrace *nextTracePtr;	   /* Next trace to check after current
				    * trace procedure returns;  if this
				    * trace gets deleted, must update pointer
				    * to avoid using free'd memory. */
} OatActiveTrace;


/*
 * Item in the list of traced attributes for a specific object; 
 * needed to clean up traces when objects get destroyed.
 */

typedef struct OatTracedAttr {
  char* attrName;
  struct OatTracedAttr* nextPtr;
} OatTracedAttr;


/*
 * Hash table used to provide access to object traces from C code.
 */

extern Tcl_HashTable oatHash;


/* 
 * first in the list of active object attribute traces
 * (this should be on the per-interpreter basis)
 */

extern OatActiveTrace* oatActiveTracePtr;


#endif   /* _OATINT_H */
