proc printcitem {canv item attr ops} {
  puts "$canv $item $attr $ops"
}

proc printcitemCoords {canv item attr ops} {
  puts "$canv $item $attr $ops [$canv coords $item]"
}

proc trackItem {canv item attr ops} {
  global gl

  set coords [$canv coords $item]
  set newcoords ""
  foreach x $coords {
    lappend newcoords [expr 2*$x + 100]
  }

  eval $canv coords $gl(line2) $newcoords
}

set c .c
catch {destroy $c}
pack [canvas $c]
set gl(line1) [$c create line 0 0 50 50]
set gl(line2) [$c create line 0 0 50 50]
update

$c itemcon $gl(line1)
trace citem $c $gl(line1) -fill w printcitem
$c itemconf $gl(line1) -fill blue
trace cinfo $c $gl(line1) -fill 

trace citem $c $gl(line1) coords w trackItem
$c coords $gl(line1) 10 10 100 100
puts [trace cinfo $c $gl(line1) coords]
