#!/project/biodb04/tcl/tk4.1/unix/wish

# RCS:  $Id: wtrace_demo.tcl,v 1.1 1996/11/03 22:48:59 safonov Exp safonov $

proc double_width {nameSpace widgName attrName ops} {
    set hgt [$widgName cget -height]
    $widgName conf -width [expr $hgt*2]
#    $widgName conf -height 20
}

proc half_height {nameSpace widgName attrName ops} {
    set wid [$widgName cget -width]
    $widgName conf -height [expr $wid/2]
}

proc restrict_height {nameSpace widgName attrName ops} {
    global gl

    set hgt [$widgName cget $attrName]
    if {$hgt > $gl(hmax)} {
	$widgName conf $attrName $gl(hmax)
    }
}

proc toggle_restrict_height {toggle} {
    global c gl
    global hinfobut

    if {$toggle} {
	trace widget  $c -height w restrict_height
	$gl(hrestent) conf -state normal
    } else {
	trace wdelete $c -height w restrict_height
	$gl(hrestent) conf -state disabled
    }

     set gl(hinfo) [trace winfo $c -height]
#    $hinfobut invoke
}

proc restrict_width {nameSpace widgName attrName ops} {
    global gl

    set hgt [$widgName cget $attrName]
    if {$hgt > $gl(wmax)} {
	$widgName conf $attrName $gl(wmax)
    }
}

proc toggle_restrict_width {toggle} {
    global c gl
    global winfobut

    if {$toggle} {
	trace widget  $c -width w restrict_width
	$gl(wrestent) conf -state normal
    } else {
	trace wdelete $c -width w restrict_width
	$gl(wrestent) conf -state disabled
    }

    set gl(winfo) [trace winfo $c -width]
#     $winfobut invoke
}

proc printit {nameSpace obj attr ops} {
    puts "$obj $attr is [$obj cget $attr]"
}

proc makeUI { } {
    global gl
    global c
    global hinfobut winfobut

    wm geom . 600x400

    set gl(hmax) 300
    set gl(wmax) 400

    catch {destroy .topframe}
    pack [frame .topframe] -expand 1 -fill both

    pack [frame .topframe.cframe -relief raised -bd 2] \
	-side top -expand 1 -fill both

    set c [canvas .topframe.cframe.c]
    $c conf -bg blue
    
# widget traces
    trace widget $c -height w double_width
    trace widget $c -width  w half_height
    
    $c conf -height 100
    pack $c -side top -expand 0

# control buttons etc.
    set butfr [frame .topframe.butfr -relief raised -bd 2]

     pack $butfr -side bottom -fill x
#     set hinfobut [button ${butfr}.hinfobut \
# 		      -text "Height Trace Info" \
# 		      -command {set gl(hinfo) [trace winfo $c -height]}]
#     pack $hinfobut -side left -fill x -expand 1
#     set winfobut [button ${butfr}.winfobut \
# 		      -text "Width Trace Info" \
# 		      -command {set gl(winfo) [trace winfo $c -width]}]
#     pack $winfobut -side left -fill x -expand 1
    set quitbut [button ${butfr}.quitbut \
		     -text "Quit" \
		     -command exit]
    pack $quitbut -side left -fill x -expand 1

    set entfr [frame .topframe.entfr -relief raised -bd 2]
    pack $entfr -side bottom -fill x
    set hinfoent [entry ${entfr}.hinfoent \
		      -textvariable gl(hinfo)]
    pack $hinfoent -side left -fill x -expand 1
    set winfoent [entry ${entfr}.winfoent \
		      -textvariable gl(winfo)]
    pack $winfoent -side left -fill x -expand 1

    set ctlfr [frame .topframe.ctlfr -relief raised -bd 2]
    pack $ctlfr -side bottom -fill x
    set gl(hrestrcbut) [checkbutton ${ctlfr}.hrestrbut \
			    -text "Restrict Height" \
			    -variable restrictHeight \
			    -command {toggle_restrict_height $restrictHeight}]
    pack $gl(hrestrcbut) -side left -fill x -expand 1
    set gl(hrestent) [entry ${ctlfr}.hrestent \
			  -textvariable gl(hmax) \
			  -state disabled]
    pack $gl(hrestent) -side left
    pack [label ${ctlfr}.label -text "     "] -side left


    set gl(wrestrcbut) [checkbutton ${ctlfr}.wrestrbut \
			    -text "Restrict Width" \
			    -variable restrictWidth \
			    -command {toggle_restrict_width $restrictWidth}]
    pack $gl(wrestrcbut) -side left -fill x -expand 1
    set gl(wrestent) [entry ${ctlfr}.wrestent \
			  -textvariable gl(wmax) \
			  -state disabled]
    pack $gl(wrestent) -side left

# bindings
    bind $c <Button-1> {ResizeHeightBegin %W %x %y}
    bind $c <B1-Motion> {ResizeHeight %W %x %y}
    bind $c <Shift-Button-1> {ResizeWidthBegin %W %x %y}
    bind $c <Shift-B1-Motion> {ResizeWidth %W %x %y}

# update status entries
#    $hinfobut invoke
#    $winfobut invoke
    set gl(hinfo) [trace winfo $c -height]
    set gl(winfo) [trace winfo $c -width]
}

proc ResizeHeightBegin {w x y} {
    global resize
    
    set resize(height) [$w cget -height]
    set resize(y) $y
}

proc ResizeHeight {w x y} {
    global resize

    if {![info exist resize(height)]} {
	return
    }
    
    set height [expr $resize(height) + ($y - $resize(y))]
    if {$height < 10} {
	set height 10
    }

    $w conf -height $height
}

proc ResizeWidthBegin {w x y} {
    global resize
    
    set resize(width) [$w cget -width]
    set resize(x) $x
}

proc ResizeWidth {w x y} {
    global resize

    if {![info exist resize(width)]} {
	return
    }
    
    set width [expr $resize(width) + ($x - $resize(x))]
    if {$width < 20} {
	set width 20
    }

    $w conf -width $width
}

makeUI

