# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   tdb_1.tcl
# Author: Richard Schwaninger
# Date:   22/07/1996
# System: chiron.standalone
# RCS:    $Id$

# [endfold]

# - INSTRUCTIONS -------------------------------------
# This is a first simple example of how to use tdb.

# Cd to the demo directory and start tdb with 
# 'tdb tdb_1.tcl' and begin debugging by clicking on 
# 'step'.

# You will see the debugger stepping through loading 
# of the code below and then call the 'main' function.

# When you continue to 'step' then tdb will enter 
# the function 'func1' then 'func2'. You may inspect
# both local and global variables (or the current 
# stack nesting). To see the current line both
# in its source and evaluated form click on the 'line'
# button.

# The programm will finally terminate with an error 
# at the unknown command 'puff'. Click on 'Errors'
# to see a backtrace of the error. If you click on 
# a location within the displayed backtrace then 
# the corresponding procedure will be shown in the 
# 'Procs' window.

# Replace the erronous command with 'puts' in your 
# favorite editor, save the file and enter 'info files'
# (or select it from the menu 'Info/On Files'). As
# you can see the debugger noticed the change in this
# file and will reload it automatically on the next
# 'source' command without arguments.

# Just type 'run' to reload/restart the programm.
# With 'go func2' the debugger will stop at the
# invocation of 'func2'. 'step' into the function
# and continue with 'next' until the previously
# erronous statement is executed.

# Use 'ret' to return from this subroutine without
# stopping at any intermediate statements. Clicking
# on 'line' (or 'info line') also shows the 
# functions return value.

# With 'set g "I don't like the old value, I use $x(a)"
# you change the value of the variable g, using on the
# fly variable substitution.

# Now click on 'cont' (or enter 'cont') to execute
# the programm until it exits.

# N.B. This code has one single advantage over code
# written by THE small and soft company: it contains
# just one error!
# ------------------------------------------------------

proc func2 { b } {
   set c "entered func2"
   puff "c is $c"
   append c " and now leaving it"
   return $c
}

proc func1 { a } {
   upvar 1 c k
   set c 17
   set x(a) 12
   set x(b) 13
   set f [expr $a+$c+$x(b)+$k]
   set g [func2 $f]
   return $f
}

# this function has to be defined if you use the
# default startup file 'tclstart.to' from the library.
proc main { args } {
   puts "hello to tdb's example No 1"
   set c 20
   set b "b=[func1 $c]"
   puts "we got '$b' from func1"
}

# all softWorks code calls this function automatically after
# loading the source file(s).
# main

# EOF