# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   tdb_2.tcl
# Author: Richard Schwaninger
# Date:   22/07/1996
# System: chiron.standalone
# RCS:    $Id$

# [endfold]

# - INSTRUCTIONS -------------------------------------
# This example demonstrates breakpoints.

# Cd to the demo directory and start tdb with 
# 'tdb tdb_2' and begin debugging using the
# command 'go main'.

# Click on the 'Procs' tab to see a list of defined
# procedures (note that this list will be 
# empty/incomplete before reaching 'main', as the
# procedures will be defined when reading the
# source file). You may also use the menu 
# 'Info/On Procedures' or the command 'info procs'.

# Selecting 'func2' by clicking on the name will show 
# you the corresponding definition.

# Now we set a (soft) breakpoint to the entry point
# of 'func2'. Enter 'break func2' and check this 
# with 'show break' or the menu 
# 'Breakpoints/ShowBreakpoints'.

# clicking on 'cont' will run the programm until exit
# or a breakpoint is reached. As you see the programm
# stops at the entry to 'func2'. Now we set another
# breakpoint to the call to function 'append' inside
# of 'func2' with 'break func2' and delete the old
# breakpoint with 'del Soft1' (the name of the
# breakpoint - this is just to show you the command,
# has no real use here).

# Again 'cont' stops at the new breakpoint. We could
# have reached this simple goal with another command,
# 'go'. To see how it works just say 'go puts' and
# the programm will be executed until the next
# 'puts' statement is reached - which happens to be
# the last statement in function 'main'.

# Now enter 'run tdb_2' to restart the programm and
# clear all breakpoints (if you just say 'run' then
# the (soft) breakpoints stay set).

# As you can see the most important drawback of soft
# breakpoints is that they don't denote just one
# location in code (if you set one break at 'puts'
# then tdb will happily stop at every 'puts' in your
# code).

# please see tdb_3 for hard breakpoints.

# N.B. If you think this code does something usefull 
# then you may sell it to B. G.
# ------------------------------------------------------

proc func2 { b } {
   set c "entered func2"
   puts "c is $c"
   append c " and now leaving it"
   return $c
}

proc func1 { a } {
   upvar 1 c k
   set c 17
   set x(a) 12
   set x(b) 13
   set f [expr $a+$c+$x(b)+$k]
   set g [func2 $f]
   return $f
}

# this function has to be defined if you use the
# default startup file 'tclstart.to' from the library.
proc main { args } {
   puts "hello to tdb's example No 2"
   set c 20
   set b "b=[func1 $c]"
   puts "we got '$b' from func1"
}

# all softWorks code calls this function automatically after
# loading the source file(s).
# main

# EOF
