# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   tdb_3.tcl
# Author: Richard Schwaninger
# Date:   22/07/1996
# System: chiron.standalone
# RCS:    $Id$

# [endfold]

# - INSTRUCTIONS -------------------------------------
# This example demonstrates breakpoints.

# Cd to the demo directory and start tdb with 
# 'tdb tdb_3' and just check the programm by entering
# the command 'cont'. The programm returns an error.

# You may suspect that the error is somewhere in the
# first 'if'-statement in 'func2'. So you set a
# breakpoint there - the easiest way to do so is to
# uncomment the corresponding line in the source file
# (note that the commerical version of the debugger
# has more comfortable features).

# now type 'run' and 'cont' to reload/restart the
# programm and see the debugger stop at your break-
# point. You may now inspect/change code and variables
# or just step ahead. Using 'next' you see that you
# have made an error in the expression, it should
# read 'set c [expr $b/16+2]' instead of '3'. 

# Change the code in your editor and type 
# 'source tdb_3 func2' to only reload 'func2'. You may
# check this with 'info proc func2'.

# Continue with 'cont' - the debugger will stop again 
# at your hard breakpoint. Step further and check that
# the value is correct. Remove the breakpoint with
# 'del Hard1' and finish the programm with 'cont'.

# You may set hard breakpoints at function entry points
# by just specifying 'break -hard func2' for example.

# You may set a breakpoint at the current line by
# specifying 'break' or 'break -hard'.

# please see tdb_2 for soft breakpoints.

# N.B. This code tries to calculate the answer to Life, the
# Universe and Everything, but as you certainly know it 
# should be 42 and therefore it is wrong even if it states
# otherwise.
# ------------------------------------------------------

proc func2 { b } {
   if { ($b%7)==0 } {
      # DbgBreak Hard1
      set c [expr $b/16+3]
   } else {
      set c [expr $b/32+1]
   }
   return $c
}

proc func1 { a } {
   upvar 1 c k
   set c 17
   set x(a) 1
   set x(b) 13
   set f 1
   for {set i $x(a)} { $i<$x(b) } {incr i} {
      set f [expr ($i+$c-$x(b)+$k)*[func2 $f]]
   }
   return $f
}

# this function has to be defined if you use the
# default startup file 'tclstart.to' from the library.
proc main { args } {
   puts "hello to tdb's example No 3"
   set c 20
   set b [func1 $c]
   if { $b!=540 } {
      puts "*** error, this value is wrong"
      error "computed value is wrong ($b)"
   } else {
      puts "correct value is $b"
   }
}

# all softWorks code calls this function automatically after
# loading the source file(s).
# main

# EOF
