# [[ Header ]]

# Copyright (c) 1996 by SoftWorks.  All Rights Reserved.
# File:   tdb_4.tcl
# Author: Richard Schwaninger
# Date:   22/07/1996
# System: chiron.standalone
# RCS:    $Id$

# [endfold]

# - INSTRUCTIONS -------------------------------------
# This example concentrates on features that
# didn't fit anywhere else.

# Cd to the demo directory and start tdb with 
# 'tdb tdb_4' and just check the programm by entering
# the command 'cont'. The programm returns an error.
# You guessed that, didn't you? (try moving the second
# slider)

# This example uses some of the object oriented extensions
# available from softWorks. Please ignore it if you have
# no experience with object orientation.

# If you have the commercial version you may try the call
# command: It may be used to print out complex data 
# structures (such as from objects). Note that 
# 'PrintAttributes' is a predefined method of 'Object'.
# 'cont' until the breakpoint that is already inserted
# and then do a 'call $bd PrintAttributes' which will
# print out the objects attributes to stdout.

# If you would like to display the evaluated values of the
# current line, you may switch to it with the 
# 'Options/Show Value' menu. 

# 'Options/Show Full Line' displays the complete current 
# statement, even if it contains more than one line (eg
# proc, if, foreach ...).

# If you use 'info files' or 'info path' then you see which
# files and libraries are loaded - the later shows complete
# pathnames in case you are not sure from where tdb loaded
# the corresponding files.

# N.B. this place may be rented. So if you have any ideas
# of your own and a little spare cash I will be happy
# to add your quote here (hehe).
# ------------------------------------------------------

Require Object 2

Class Dummy {
   Parents Object
   Public {
      IQ 60
      a 10
      b 20
   }
}

Method ShowIQ {} {
   puts "My IQ is $Self(IQ)"
}
Method LearnSomething { a } {
   lappend $Self(a) $a
   incr Self(IQ) 5
}

Class BigDummy {
   Parents Dummy
   Public {
      IQ 0
   }
}

Method LearnSomething { a } {
   $That LearnSomething $a
   incr Self(IQ) -3
}
Method SetIQ { a } {
   # you may set this breakpoint and watch both global 
   # and local variables
   DbgBreak ErrorHere
   global iq1 iq2
   set Self(IQ) [expr $a+$iq1]
   set iq2 $Self(IQ)
}

proc ShowIQ { d1 d2 } {
   Require txAppShell 5
   txAppShell .t -title "Demo 4"
   set w [.t subwidget frame]
   scale $w.s1 \
	 -label "IQ for Dummy:" \
	 -from 0 -to 180 \
	 -variable iq1 \
	 -orient horizontal \
	 -command "$d1 Set IQ"
   scale $w.s2 \
	 -label "IQ for BigDummy:" \
	 -from 0 -to 180 \
	 -variable iq2 \
	 -orient horizontal \
	 -command "$d2 SetIQ"
   pack $w.s1 $w.s2 -padx 5 -pady 5 -fill both -expand y
   .t show
}

proc main { args } {
   puts "hello to tdb's example No 4"
   set dummy [New Dummy]
   global iq1 iq2

   $dummy LearnSomething "The Hitchhikers Guide to the Galaxy"
   $dummy ShowIQ
   set iq1 [$dummy Get IQ]

   set bd [New BigDummy]
   $bd LearnSomething "The Hitchhikers Guide to the Galaxy"
   $bd LearnSomething "The Hitchhikers Guide to the Galaxy"
   $bd LearnSomething "The Hitchhikers Guide to the Galaxy"
   set iq2 [$bd Get IQ]
   ShowIQ $dummy $bd

   # in softWorks code this enters the event loop
   MainLoop
}

# all softWorks code calls this function automatically after
# loading the source file(s).
# main

# EOF
