set rcsId {$Id: bindings.tcl,v 1.2 1997/06/04 19:58:43 jfontain Exp $}

# provide a reliable binding mechanism: a new tag is created, inserted in the existing tags at a specified position and when
# deleted, all existing bndings for this tag are safely and completely removed

class bindings {
    proc bindings {this widget index} {
        set bindings::($this,widget) $widget
        bindtags $widget [linsert [bindtags $widget] $index bindings($this)]
    }
    proc ~bindings {this} {
        set tags [bindtags $bindings::($this,widget)]
        set index [lsearch -exact $tags bindings($this)]
        bindtags $bindings::($this,widget) [lreplace $tags $index $index]
        foreach tag [bind bindings($this)] {
            bind bindings($this) $tag {}
        }
    }
    proc add {this tag sequence} {
        bind bindings($this) $tag $sequence
    }
}
