set rcsId {$Id: stooop.tcl,v 3.22 1997/08/19 21:07:11 jfontain Exp $}

package provide stooop 3.0

catch {rename proc _proc}

namespace eval ::stooop {
    namespace export class virtual
}

if {[llength [info commands ::stooop::new]]==0} {

    namespace eval ::stooop {
        namespace export new delete classof
        if {![info exists newId]} {
            variable newId 0
        }
    }

    _proc ::stooop::new {classOrId args} {
        variable newId
        variable class

        if {[scan $classOrId %d dummy]==0} {
            set class([set id [incr newId]]) $classOrId
            uplevel ::${classOrId}::$classOrId $id $args
        } else {
            if {[catch {set class([set id [incr newId]]) $class($classOrId)}]} {
                error "invalid object identifier $classOrId"
            }
            uplevel ::$class($classOrId)::_copy $id $classOrId
        }
        return $id
    }

    _proc ::stooop::delete {args} {
        variable class

        foreach id $args {
            _delete $class($id) $id
            unset class($id)
        }
    }

    _proc ::stooop::_delete {class id} {
        uplevel 2 ::${class}::~$class $id
        foreach name [array names ::${class}:: $id,*] {
            unset ::${class}::($name)
        }
    }

    _proc ::stooop::classof {id} {
        variable class

        return $class($id)
    }

    _proc ::stooop::copy {class from to} {
        set index [string length $from]
        foreach name [array names ::${class}:: $from,*] {
            set ::${class}::($to[string range $name $index end]) [set ::${class}::($name)]
        }
    }

}

_proc ::stooop::class {args} {
    variable declaring
    variable declared

    set declaring [lindex $args 0]
    if {[string match *::* $declaring]} {
        error "class $declaring name must not be qualified"
    }
    uplevel namespace eval ::$declaring [list "::variable {}\n[lindex $args end]"]
    set declared($declaring) {}
    unset declaring
}

_proc ::stooop::virtual {keyword name arguments args} {
    variable declaring

    if {![regexp {^(::)?proc$} $keyword]} {
        error "virtual operator works only on proc, not $keyword"
    }
    if {[catch {set declaring} class]} {
        if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
            error "$name is not a valid member procedure name"
        }
    } else {
        set procedure $name
    }
    if {[string compare $class $procedure]==0} {
        error "cannot make class $class constructor virtual"
    }
    if {[string compare ~$class $procedure]==0} {
        error "cannot make class $class destructor virtual"
    }
    if {[string compare [lindex $arguments 0] this]!=0} {
        error "cannot make static procedure $procedure of class $class virtual"
    }
    variable pureVirtual
    set pureVirtual [expr {[llength $args]==0}]
    proc $name $arguments [lindex $args 0]
    unset pureVirtual
}

_proc proc {procedure arguments args} {
    if {
        [catch {set ::stooop::declaring} class]&&
        (![regexp {^([^:]+)::(.+)$} $procedure dummy class procedure]||![info exists ::stooop::declared($class)])
    } {
        uplevel _proc [list $procedure $arguments] $args
        return
    }

    if {[llength $args]==0} {
        error "missing body for ${class}::$procedure"
    }
    if {[string match *::* $procedure]} {
        error "${class}::$procedure procedure member part $procedure must not be qualified"
    }
    if {[string compare $class $procedure]==0} {
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class constructor first argument must be this"
        }
        if {[string compare [lindex $arguments 1] copy]==0} {
            if {[llength $arguments]!=2} {
                error "class $class copy constructor must have 2 arguments exactly"
            }
            if {[catch {info body ::${class}::$class}]} {
                error "class $class copy constructor defined before constructor"
            }
            eval ::stooop::constructorDeclaration $class 1 \{$arguments\} $args
        } else {
            eval ::stooop::constructorDeclaration $class 0 \{$arguments\} $args
            ::stooop::generateDefaultCopyConstructor $class
        }
    } elseif {[string compare ~$class $procedure]==0} {
        if {[llength $arguments]!=1} {
            error "class $class destructor must have 1 argument exactly"
        }
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class destructor argument must be this"
        }
        if {[catch {info body ::${class}::$class}]} {
            error "class $class destructor defined before constructor"
        }
        ::stooop::destructorDeclaration $class $arguments [lindex $args 0]
    } else {
        if {[catch {info body ::${class}::$class}]} {
            error "class $class member procedure $procedure defined before constructor"
        }
        ::stooop::memberProcedureDeclaration $class $procedure $arguments [lindex $args 0]
    }
}

_proc ::stooop::constructorDeclaration {class copy arguments args} {
    variable bases
    variable variable

    set number [llength $args]
    if {($number%2)==0} {
        error "bad $class constructor declaration, a base class, contructor arguments or body may be missing"
    }

    if {[string compare [lindex $arguments end] args]==0} {
        set variable($class) {}
    }
    if {!$copy} {
        set bases($class) {}
    }
    foreach {base baseArguments} [lrange $args 0 [expr {$number-2}]] {
        if {!$copy} {
            if {[lsearch -exact $bases($class) $base]>=0} {
                error "class $class directly inherits from class $base more than once"
            }
            lappend bases($class) $base
            catch {::${base}::$base}
        }
        regsub -all \n $baseArguments {} constructorArguments($base)
    }

    set constructorBody \
"::variable {}
"
    if {[llength $bases($class)]>0} {
        foreach base $bases($class) {
            if {[string compare $class $base]==0} {
                error "class $class cannot be derived from itself"
            }
            if {[catch {info body ::${base}::$base}]} {
                error "class $class constructor defined before base class $base constructor"
            }
        }
        if {[info exists variable($class)]} {
            foreach base $bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                if {[info exists variable($base)]&&([string first {$args} $constructorArguments($base)]>=0)} {
                    append constructorBody \
"::set _list \[::list $constructorArguments($base)\]
::eval ::${base}::$base \$this \[::lrange \$_list 0 \[::expr {\[::llength \$_list\]-2}\]\] \[::lindex \$_list end\]
::unset _list
::set ::${base}::(\$this,_derived) $class
"
                } else {
                    append constructorBody \
"::${base}::$base \$this $constructorArguments($base)
::set ::${base}::(\$this,_derived) $class
"
                }
            }
        } else {
            foreach base $bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                append constructorBody \
"::${base}::$base \$this $constructorArguments($base)
::set ::${base}::(\$this,_derived) $class
"
            }
        }
    }
    if {$copy} {
        append constructorBody \
"::catch {::set ::${class}::(\$this,_derived) \[::set ::${class}::(\$[::lindex $arguments 1],_derived)\]}
"
    }
    append constructorBody [lindex $args end]
    if {$copy} {
        _proc ::${class}::_copy $arguments $constructorBody
    } else {
        _proc ::${class}::$class $arguments $constructorBody
    }
}

_proc ::stooop::destructorDeclaration {class arguments body} {
    variable bases

    set body \
"::variable {}
$body
"
    for {set index [expr {[llength $bases($class)]-1}]} {$index>=0} {incr index -1} {
        set base [lindex $bases($class) $index]
        append body \
"::stooop::_delete $base \$this
"
    }
    _proc ::${class}::~$class $arguments $body
}

_proc ::stooop::memberProcedureDeclaration {class procedure arguments body} {
    variable pureVirtual

    if {[info exists pureVirtual]} {
        if {$pureVirtual} {
            _proc ::${class}::$procedure $arguments \
"::variable {}
::eval \$::${class}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]
"
        } else {
            _proc ::${class}::_$procedure $arguments \
"::variable {}
$body
"
            _proc ::${class}::$procedure $arguments \
"::variable {}
if {!\[::catch {::info body \$::${class}::(\$this,_derived)::$procedure}\]} {
::return \[::eval \$::${class}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]\]
}
::eval ::${class}::_$procedure \[::lrange \[::info level 0\] 1 end\]
"
        }
    } else {
        _proc ::${class}::$procedure $arguments \
"::variable {}
$body
"
    }
}

_proc ::stooop::generateDefaultCopyConstructor {class} {
    variable bases

    foreach base $bases($class) {
        append body \
"::${base}::_copy \$this \$sibling
"
    }
    append body \
"::stooop::copy $class \$sibling \$this
"
    _proc ::${class}::_copy {this sibling} $body
}
namespace import stooop::*
set rcsId {$Id: scwoop.tcl,v 2.11 1997/09/27 15:52:30 jfontain Exp $}

package provide scwoop 2.0

class widget {}

switch $tcl_platform(platform) {
    macintosh {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor systemButtonText default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor systemButtonFace default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor systemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground systemButtonText default,ChkradForeground DEF_BUTTON_FG default,ButtonFont system default,ButtonHeight 0 default,ButtonHighlightBackground systemWindowBody default,ButtonHighlight systemButtonFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 4 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 7 default,LabelCheckRadiusPadX 1 default,ButtonPadY 3 default,LabelCheckRadiusPadY 1 default,ButtonRelief flat default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor systemWindowBody default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground systemWindowBody default,CanvasHighlight Black default,CanvasHighlightWidth 3 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor systemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor systemWindowBody default,EntryBackgroundMono White default,EntryBorderWidth 1 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica 12" default,EntryForeground Black default,EntryHighlightBackground systemWindowBody default,EntryHighlight Black default,EntryHighlightWidth 0 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 1 default,EntryJustify left default,EntryRelief solid default,EntryScrollCommand {} default,EntrySelectColor systemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor systemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor systemWindowBody default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground systemWindowBody default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor systemWindowBody default,ListboxBackgroundMono White default,ListboxBorderWidth 1 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont application default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground systemWindowBody default,ListboxHighlight Black default,ListboxHighlightWidth 0 default,ListboxRelief solid default,ListboxScrollCommand {} default,ListboxSelectColor systemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 0 default,ListboxSelectForegroundColor systemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemMenuActive default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemMenuActiveText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemMenuDisabled default,MenuDisabledForegroundMono {} default,MenuFont system default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuActive default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor systemWindowBody default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont system default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground systemWindowBody default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify left default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor systemWindowBody default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont system default,MessageHighlightBackground systemWindowBody default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor systemWindowBody default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont system default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground systemWindowBody default,ScaleHighlight Black default,ScaleHighlightWidth 0 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor systemWindowBody default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground systemWindowBody default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief flat default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 16 default,TextBackgroundColor systemWindowBody default,TextBackgroundMono White default,TextBorderWidth 0 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier 12" default,TextHeight 24 default,TextHighlightBackground systemWindowBody default,TextHighlight Black default,TextHighlightWidth 3 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 1 default,TextPadX 1 default,TextPadY 1 default,TextRelief flat default,TextSelectColor systemHighlight default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor systemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief solid default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    unix {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor #ececec default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor Black default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor #d9d9d9 default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground Black default,ChkradForeground DEF_BUTTON_FG default,ButtonFont "Helvetica -12 bold" default,ButtonHeight 0 default,ButtonHighlightBackground #d9d9d9 default,ButtonHighlight Black default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 3m default,LabelCheckRadiusPadX 1 default,ButtonPadY 1m default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor #d9d9d9 default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground #d9d9d9 default,CanvasHighlight Black default,CanvasHighlightWidth 1 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor #c3c3c3 default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor #d9d9d9 default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica -12" default,EntryForeground Black default,EntryHighlightBackground #d9d9d9 default,EntryHighlight Black default,EntryHighlightWidth 1 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor #c3c3c3 default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor Black default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor #d9d9d9 default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground #d9d9d9 default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor #d9d9d9 default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "Helvetica -12 bold" default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground #d9d9d9 default,ListboxHighlight Black default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor #c3c3c3 default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor Black default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor #ececec default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 2 default,MenuActiveForegroundColor Black default,MenuActiveForegroundMono White default,MenuBackgroundColor #d9d9d9 default,MenuBackgroundMono White default,MenuBorderWidth 2 default,MenuCursor arrow default,MenuDisabledForegroundColor #a3a3a3 default,MenuDisabledForegroundMono {} default,MenuFont "Helvetica -12 bold" default,MenuForeground Black default,MenuPostCommand {} default,MenuRelief raised default,MenuSelectColor #b03060 default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor #d9d9d9 default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "Helvetica -12 bold" default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground #d9d9d9 default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor #d9d9d9 default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont "Helvetica -12 bold" default,MessageHighlightBackground #d9d9d9 default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor #d9d9d9 default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "Helvetica -12 bold" default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground #d9d9d9 default,ScaleHighlight Black default,ScaleHighlightWidth 1 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor #d9d9d9 default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 2 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground #d9d9d9 default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 1 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 15 default,TextBackgroundColor #d9d9d9 default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier -12" default,TextHeight 24 default,TextHighlightBackground #d9d9d9 default,TextHighlight Black default,TextHighlightWidth 1 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor #c3c3c3 default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor Black default,TextSelectForegroundMono White default,TextSelectRelief raised default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    windows {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor SystemButtonFace default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor SystemButtonText default,ChkradActiveForegroundColor SystemWindowText default,ButtonActiveForegroundMono White default,ButtonBackgroundColor SystemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor SystemDisabledText default,ButtonDisabledForegroundMono {} default,ButtonForeground SystemButtonText default,ChkradForeground SystemWindowText default,ButtonFont "{MS Sans Serif} 8" default,ButtonHeight 0 default,ButtonHighlightBackground SystemButtonFace default,ButtonHighlight SystemWindowFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 1 default,LabelCheckRadiusPadX 1 default,ButtonPadY 1 default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor SystemWindow default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor SystemButtonFace default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground SystemButtonFace default,CanvasHighlight SystemWindowFrame default,CanvasHighlightWidth 2 default,CanvasInsertBackground SystemButtonText default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor SystemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor SystemHighlightText default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor SystemWindow default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "{MS Sans Serif} 8" default,EntryForeground SystemWindowText default,EntryHighlightBackground SystemButtonFace default,EntryHighlight SystemWindowFrame default,EntryHighlightWidth 0 default,EntryInsertBackground SystemWindowText default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor SystemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 0 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor SystemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor SystemButtonFace default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground SystemButtonFace default,FrameHighlight SystemWindowFrame default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor SystemButtonFace default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "{MS Sans Serif} 8" default,ListboxForeground SystemButtonText default,ListboxHeight 10 default,ListboxHighlightBackground SystemButtonFace default,ListboxHighlight SystemWindowFrame default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor SystemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor SystemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemHighlight default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemHighlightText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemDisabledText default,MenuDisabledForegroundMono {} default,MenuFont "{MS Sans Serif} 8" default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuText default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor SystemButtonFace default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor SystemButtonText default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor SystemButtonFace default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor SystemDisabledText default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "{MS Sans Serif} 8" default,MenubuttonForeground SystemButtonText default,MenubuttonHeight 0 default,MenubuttonHighlightBackground SystemButtonFace default,MenubuttonHighlight SystemWindowFrame default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor SystemButtonFace default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground SystemButtonText default,MessageFont "{MS Sans Serif} 8" default,MessageHighlightBackground SystemButtonFace default,MessageHighlight SystemWindowFrame default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor SystemButtonFace default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor SystemButtonFace default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "{MS Sans Serif} 8" default,ScaleForegroundColor SystemButtonText default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground SystemButtonFace default,ScaleHighlight SystemWindowFrame default,ScaleHighlightWidth 2 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor SystemScrollbar default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor SystemButtonFace default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor SystemButtonFace default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground SystemButtonFace default,ScrollbarHighlight SystemWindowFrame default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor SystemScrollbar default,ScrollbarTroughMono White default,ScrollbarWidth 10 default,TextBackgroundColor SystemWindow default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground SystemWindowText default,TextExportSelection 1 default,TextFont "{MS Sans Serif} 8" default,TextHeight 24 default,TextHighlightBackground SystemButtonFace default,TextHighlight SystemWindowFrame default,TextHighlightWidth 0 default,TextInsertBackground SystemWindowText default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor SystemHighlight default,TextSelectMono Black default,TextSelectBorderColor 0 default,TextSelectBorderMono 0 default,TextSelectForegroundColor SystemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief flat default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
}

class widget {
    proc widget {this path args} {
        set widget::($this,path) $path
    }

    proc ~widget {this} {}

    virtual proc configure {this args} {
        return [eval $widget::($this,path) configure $args]
    }

    virtual proc cget {this args} {
        return [$widget::($this,path) cget $args]
    }
}


foreach class {button canvas entry frame label listbox menu menubutton message radiobutton scale scrollbar text toplevel} {
    class $class {
        proc $class {this parentPath args} widget "\[::$class \$parentPath.\$this\] \$args" {
            eval $widget::($this,path) configure $args
        }
        proc ~$class {this} {
            destroy $widget::($this,path)
        }
    }
}

class table {
    proc table {this parentPath args} widget {[::table $parentPath.$this] $args} {
        eval $widget::($this,path) configure $args
    }
    proc ~table {this} {
        destroy $widget::($this,path)
    }
}


class composite {}

proc composite::composite {this base args} widget {$widget::($base,path) $args} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    set composite::($this,base) $base
    set composite::($this,base,path) $widget::($base,path)
    set composite::($this,_children) {}
    set composite::($this,complete) 0
    set composite::($this,initialArguments) $args
}

proc composite::~composite {this} {
    eval delete [lsort -integer -decreasing $composite::($this,_children)] $composite::($this,base)
}

virtual proc composite::options {this}

proc composite::configure {this args} {
    if {[llength $args]==0} {
        return [descriptions $this]
    }
    if {![string match -* $args]} {
        return [eval widget::configure $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
    }
    foreach {option value} $args {
        if {![info exists composite::($this,$option)]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
    }
    if {[llength $args]==1} {
        return [description $this [lindex $args 0]]
    }
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    foreach {option value} $args {
        if {[string compare $composite::($this,$option) $value]!=0} {
            $composite::($this,_derived)::set$option $this [set composite::($this,$option) $value]
        }
    }
}

proc composite::manage {this args} {
    foreach {child name} $args {
        if {[string length $name]==0} {
            error "widget $child has no name"
        }
        if {[string match -* $name]} {
            error "widget $child name \"$name\" must not start with a dash character"
        }
        if {[info exists composite::($this,$name)]} {
            error "\"$name\" member name already exists in composite layer"
        }
        set composite::($this,$name) $child
        set composite::($this,$name,path) $widget::($child,path)
        lappend composite::($this,_children) $child
    }
}

proc composite::complete {this} {
    set path $widget::($this,path)
    foreach description [options $this] {
        set option [lindex $description 0]
        set composite::($this,$option) [set default [lindex $description 3]]
        if {[llength $description]<5} {
            set initialize($option) {}
        } elseif {[string compare $default [lindex $description 4]]!=0} {
            set composite::($this,$option) [lindex $description 4]
            set initialize($option) {}
        }
        set value [option get $path [lindex $description 1] [lindex $description 2]]
        if {([string length $value]>0)&&([string compare $value $default]!=0)} {
            set composite::($this,$option) $value
            set initialize($option) {}
        }
    }
    foreach {option value} $composite::($this,initialArguments) {
        if {[catch {string compare $composite::($this,$option) $value} different]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
        if {$different} {
            set composite::($this,$option) $value
            set initialize($option) {}
        }
    }
    unset composite::($this,initialArguments)
    foreach option [array names initialize] {
        $composite::($this,_derived)::set$option $this $composite::($this,$option)
    }
    set composite::($this,complete) 1
}

proc composite::cget {this args} {
    switch [llength $args] {
        0 {
            error "wrong # args: should be \"cget $this ?child? ?child? ... option\""
        }
        1 {
            if {![string match -* $args]||![info exists composite::($this,$args)]} {
                error "$composite::($this,_derived): unknown option \"$args\""
            }
            return $composite::($this,$args)
        }
        default {
            return [eval widget::cget $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
        }
    }
}

proc composite::try {this args} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    foreach {option value} $args {
        catch {widget::configure $composite::($this,base) $option $value}
        foreach child $composite::($this,_children) {
            catch {widget::configure $child $option $value}
        }
    }
}

proc composite::description {this option} {
    foreach description [options $this] {
        if {[string compare [lindex $description 0] $option]==0} {
            if {[llength $description]<5} {
                lappend description $composite::($this,$option)
                return $description
            } else {
                return [lreplace $description 4 4 $composite::($this,$option)]
            }
        }
    }
}

proc composite::descriptions {this} {
    set descriptions {}
    foreach description [options $this] {
        if {[llength $description]<5} {
            lappend description $composite::($this,[lindex $description 0])
            lappend descriptions $description
        } else {
            lappend descriptions [lreplace $description 4 4 $composite::($this,[lindex $description 0])]
        }
    }
    return $descriptions
}

proc composite::managingOrder {this name1 name2} {
    return [expr {$composite::($this,$name1)-$composite::($this,$name2)}]
}

proc composite::componentNames {this} {
    set names {}
    foreach index [array names composite:: $this,*,path] {
        if {[regexp {,(.+),path} $index dummy name]} {
            lappend names $name
        }
    }
    return [lsort -command "managingOrder $this" $names]
}
set rcsId {$Id: safeemul.tcl,v 1.11 1996/12/22 13:10:50 jfontain Exp $}

global embed_args
if {[info exists embed_args]} {


proc checkTopLevelDirectDescendant {path} {
    if {([string compare $path .]!=0)&&([string compare [winfo parent $path] [winfo toplevel $path]]!=0)} {
        error "window \"$path\" must be a direct descendant of toplevel \"[winfo toplevel $path]\""
    }
    return $path
}

proc toplevel {args} {
    return [checkTopLevelDirectDescendant [eval frame $args]]
}

proc wm {args} {
    set path [checkTopLevelDirectDescendant [lindex $args 1]]
    switch [lindex $args 0] {
        deiconify {
            if {[llength [place info $path]]==0} {
                place $path -width {} -height {}
            }
        }
        geometry {
            set geometry [string trimleft [lindex $args 2] =]
            if {[scan $geometry %dx%d width height]==2} {
                place $path -width $width -height $height
                regsub {^[0-9]+x[0-9]+} $geometry {} geometry
            }
            if {[scan $geometry %d%d x y]==2} {
                incr x -[winfo rootx [winfo parent $path]]
                incr y -[winfo rooty [winfo parent $path]]
                place $path -bordermode ignore -x $x -y $y
            }
        }
        withdraw {
            place forget $path
        }
    }
}

set grabWindow {}
set grabEvents {
    <ButtonPress> <ButtonPress-1> <ButtonPress-2> <ButtonPress-3> <ButtonRelease> <ButtonRelease-1> <ButtonRelease-2>
    <ButtonRelease-3> <KeyPress> <KeyRelease>
}

proc grab {args} {
    global grabWindow grabEvents

    switch -- [lindex $args 0] {
        current - status {}
        release {
            if {[string compare [lindex $args end] $grabWindow]==0} {
                foreach event $grabEvents {
                    bind all $event {}
                }
                set grabWindow {}
            }
        }
        default {
            set grabWindow [lindex $args end]
            foreach event $grabEvents {
                set sequence [bind $grabWindow $event]
                if {[string length $sequence]>0} {
                    bind all $event "if {\[string compare %W $grabWindow\]!=0} {eval $sequence}"
                }
            }
        }
    }
}

}
set rcsId {$Id: bindings.tcl,v 1.2 1997/06/04 19:58:43 jfontain Exp $}


class bindings {
    proc bindings {this widget index} {
        set bindings::($this,widget) $widget
        bindtags $widget [linsert [bindtags $widget] $index bindings($this)]
    }
    proc ~bindings {this} {
        set tags [bindtags $bindings::($this,widget)]
        set index [lsearch -exact $tags bindings($this)]
        bindtags $bindings::($this,widget) [lreplace $tags $index $index]
        foreach tag [bind bindings($this)] {
            bind bindings($this) $tag {}
        }
    }
    proc add {this tag sequence} {
        bind bindings($this) $tag $sequence
    }
}
set rcsId {$Id: widgetip.tcl,v 1.24 1997/09/30 17:53:20 jfontain Exp $}

class topLabel {}

proc topLabel::topLabel {this parentPath args} composite {
    [new toplevel $parentPath -highlightbackground black -highlightthickness 1] $args
} {
    composite::manage $this [new label $widget::($this,path)] label
    composite::complete $this
    pack $composite::($this,label,path)
    wm overrideredirect $widget::($this,path) 1
}

proc topLabel::~topLabel {this} {}

proc topLabel::options {this} {
    return [list\
        [list -bordercolor borderColor BorderColor Black Black]\
        [list -borderwidth borderWidth BorderWidth 1 1]\
        [list -background background Background $widget::(default,ButtonBackgroundColor) $widget::(default,ButtonBackgroundColor)]\
        [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
        [list -foreground foreground Foreground $widget::(default,ButtonForeground) $widget::(default,ButtonForeground)]\
        [list -text text Text {} {}]\
    ]
}

foreach option {-background -font -foreground -text} {
    proc topLabel::set$option {this value} "\$composite::(\$this,label,path) configure $option \$value"
}

proc topLabel::set-bordercolor {this value} {
    $widget::($this,path) configure -highlightbackground $value
}

proc topLabel::set-borderwidth {this value} {
    $widget::($this,path) configure -highlightthickness $value
}

class widgetTip {}

if {![info exists widgetTip::(label)]} {
    set widgetTip::(label) [new topLabel . -font {Helvetica -12 normal} -background #FFFFBF]
    set widgetTip::(path) $widget::($widgetTip::(label),path)
    wm withdraw $widget::($widgetTip::(label),path)
    bind all <ButtonPress> {widgetTip::globalEvent %W}
    bind all <KeyPress> {widgetTip::globalEvent %W}
    set widgetTip::(xLast) -1
    set widgetTip::(yLast) -1
}

proc widgetTip::widgetTip {this ignore args} composite {[new widget $widgetTip::(path)] $args} {
    composite::complete $this
}

proc widgetTip::~widgetTip {this} {
    disable $this
    catch {delete $widgetTip::($this,bindings)}
}

proc widgetTip::options {this} {
    return [list\
        [list -text text Text {} {}]\
        [list -path path path {} {}]\
    ]
}

proc widgetTip::set-path {this value} {
    if {$composite::($this,complete)} {
        error {option -path cannot be set dynamically}
    }
    if {![winfo exists $value]} {
        error "invalid widget: \"$value\""
    }
    set bindings [new bindings $value 0]
    bindings::add $bindings <Enter> "widgetTip::enable $this"
    bindings::add $bindings <Leave> "widgetTip::disable $this"
    bindings::add $bindings <Destroy> "delete $this"
    set widgetTip::($this,bindings) $bindings
}

proc widgetTip::set-text {this value} {}

proc widgetTip::globalEvent {widget} {
    if {![catch {string first $composite::($widgetTip::(active),-path) $widget} value]&&($value==0)} {
        disable $widgetTip::(active)
    }
}

proc widgetTip::show {this x y} {
    set path $widgetTip::(path)
    widget::configure $widgetTip::(label) -text $composite::($this,-text)
    update idletasks
    wm geometry $path +$x+$y
    wm deiconify $path
    raise $path
}

proc widgetTip::enable {this} {
    set x [winfo pointerx $widgetTip::(path)]
    set y [winfo pointery $widgetTip::(path)]
    if {($x==$widgetTip::(xLast))&&($y==$widgetTip::(yLast))} {
        widgetTip::show $this [expr {$x+7}] [expr {$y+10}]
    } else {
        set widgetTip::(xLast) $x
        set widgetTip::(yLast) $y
        set widgetTip::(event) [after 500 "widgetTip::enable $this"]
    }
    set widgetTip::(active) $this
}

proc widgetTip::disable {this} {
    catch {after cancel $widgetTip::(event)}
    catch {unset widgetTip::(active)}
    wm withdraw $widgetTip::(path)
}
set rcsId {$Id: scroller.tcl,v 1.19 1997/07/13 12:32:30 jfontain Exp $}

proc minimum {a b} {return [expr {$a<$b?$a:$b}]}

class scroller {}

proc scroller::scroller {this parentPath args} composite {[new frame $parentPath] $args} {
    set path $widget::($this,path)
    composite::manage $this\
        [new canvas $path] canvas [new scrollbar $path -orient horizontal] horizontal [new scrollbar $path] vertical\
        [new frame $path] filler
    widget::configure $composite::($this,canvas)\
        -xscrollcommand "scroller::horizontalScroll $this" -yscrollcommand "scroller::verticalScroll $this"
    widget::configure $composite::($this,horizontal) -command "$composite::($this,canvas,path) xview"
    widget::configure $composite::($this,vertical) -command "$composite::($this,canvas,path) yview"

    grid $composite::($this,canvas,path) -sticky nsew
    grid rowconfigure $path 0 -weight 1
    grid columnconfigure $path 0 -weight 1

    composite::complete $this
}

proc scroller::~scroller {this} {}

proc scroller::options {this} {
    return [list\
        [list -height height Height 0 0]\
        [list -width width Width 0 0]\
        [list\
            -xscrollincrement xScrollIncrement ScrollIncrement\
            $widget::(default,CanvasXScrollIncrement) $widget::(default,CanvasXScrollIncrement)\
        ]\
        [list\
            -yscrollincrement yScrollIncrement ScrollIncrement\
            $widget::(default,CanvasYScrollIncrement) $widget::(default,CanvasYScrollIncrement)\
        ]\
    ]
}

proc scroller::display {this path} {
    if {[string length $path]==0} {
        $composite::($this,canvas,path) delete all
        catch {unset scroller::($this,displayed) scroller::($this,viewWidth) scroller::($this,viewHeight)}
        return
    }
    if {[info exists scroller::($this,displayed)]} {
        error "scroller \"$this\" already displays widget \"$scroller::($this,displayed)\""
    }
    if {[string compare $widget::($this,path) [winfo parent $path]]!=0} {
        error "displayed widget \"$path\" must be a child of scroller \"$this\" path"
    }
    set scroller::($this,displayed) $path
    raise $path $composite::($this,canvas,path)
    lower $path $composite::($this,horizontal,path)
    $composite::($this,canvas,path) create window 0 0 -window $path -anchor nw
    bind $path <Configure> "scroller::resize $this %w %h"
    set scroller::($this,viewWidth) 0
    set scroller::($this,viewHeight) 0
    resize $this [winfo reqwidth $path] [winfo reqheight $path]
}

proc scroller::resize {this width height} {
    if {($width==$scroller::($this,viewWidth))&&($height==$scroller::($this,viewHeight))} {
        return
    }
    set canvas $composite::($this,canvas)
    set scroller::($this,viewWidth) $width
    set scroller::($this,viewHeight) $height
    widget::configure $canvas -scrollregion "0 0 $width $height"
    if {$composite::($this,-width)==0} {
        widget::configure $canvas -width [minimum $width [winfo screenwidth $widget::($this,path)]]
    }
    if {$composite::($this,-height)==0} {
        widget::configure $canvas -height [minimum $height [winfo screenheight $widget::($this,path)]]
    }
}

proc scroller::horizontalScroll {this first last} {
    if {($last-$first)<1} {
        if {[llength [grid info $composite::($this,horizontal,path)]]==0} {
            grid $composite::($this,horizontal,path) -row 1 -sticky nsew
            if {[llength [grid info $composite::($this,vertical,path)]]>0} {
                grid $composite::($this,filler,path) -sticky nsew -column 1 -row 1
            }
        }
        $composite::($this,horizontal,path) set $first $last
    } else {
        grid forget $composite::($this,horizontal,path)
        grid forget $composite::($this,filler,path)
    }
}

proc scroller::verticalScroll {this first last} {
    if {($last-$first)<1} {
        if {[llength [grid info $composite::($this,vertical,path)]]==0} {
            grid $composite::($this,vertical,path) -column 1 -row 0 -sticky nsew
            if {[llength [grid info $composite::($this,horizontal,path)]]>0} {
                grid $composite::($this,filler,path) -sticky nsew -column 1 -row 1
            }
        }
        $composite::($this,vertical,path) set $first $last
    } else {
        grid forget $composite::($this,vertical,path)
        grid forget $composite::($this,filler,path)
    }
}

proc scroller::set-width {this value} {
    if {[winfo fpixels $widget::($this,path) $value]==0} {
        if {[info exists scroller::($this,displayed)]} {
            widget::configure $composite::($this,canvas) -width\
                [minimum $scroller::($this,viewWidth) [winfo screenwidth $widget::($this,path)]]
        }
    } else {
        widget::configure $composite::($this,canvas) -width $value
    }
}

proc scroller::set-height {this value} {
    if {[winfo fpixels $widget::($this,path) $value]==0} {
        if {[info exists scroller::($this,displayed)]} {
            widget::configure $composite::($this,canvas) -height\
                [minimum $scroller::($this,viewHeight) [winfo screenheight $widget::($this,path)]]
        }
    } else {
        widget::configure $composite::($this,canvas) -height $value
    }
}

proc scroller::set-xscrollincrement {this value} {
    widget::configure $composite::($this,canvas) -xscrollincrement $value
}

proc scroller::set-yscrollincrement {this value} {
    widget::configure $composite::($this,canvas) -yscrollincrement $value
}
set rcsId {$Id: confint.tcl,v 1.26 1997/07/13 12:32:30 jfontain Exp $}


class configurationInterface {}

proc configurationInterface::configurationInterface {this parentPath args} composite {[new frame $parentPath] $args} {
    composite::manage $this\
        [new frame $parentPath] top [new frame $parentPath -background black -height 1] separator [new frame $parentPath] bottom
    pack $composite::($this,top,path) -fill both -expand 1
    pack $composite::($this,separator,path) -fill x
    pack $composite::($this,bottom,path) -fill both
    new widgetTip . -path $composite::($this,bottom,path) -text {enter component options}
    composite::manage $this\
        [new listbox $composite::($this,top,path) -font {Helvetica -11 bold} -height 0 -selectmode single] names\
        [new frame $composite::($this,top,path) -background white -highlightbackground black -highlightthickness 1] container
    new widgetTip . -path $composite::($this,names,path) -text {select component(class)}
    pack $composite::($this,names,path) -side left -anchor nw
    pack $composite::($this,container,path) -padx 2 -pady 2 -fill both -expand 1
    composite::manage $this [new scroller $composite::($this,bottom,path)] scroller
    pack $composite::($this,scroller,path) -fill both

    composite::complete $this
}

proc configurationInterface::~configurationInterface {this} {}

proc configurationInterface::options {this} {}

proc configurationInterface::manage {this widget} {
    if {[info exists configurationInterface::($this,managed)]} {
        error "a widget \"$widget\" of class [classof $widget] is managed already"
    }
    set configurationInterface::($this,managed) $widget
    set list this([classof $widget])
    foreach name [composite::componentNames $widget] {
        lappend list $name\([classof $composite::($widget,$name)]\)
    }
    set path $composite::($this,names,path)
    eval $path insert 0 $list
    $path selection set 0
    bind $path <ButtonRelease-1> "configurationInterface::update $this"
    bind $path <KeyRelease-space> "configurationInterface::update $this"
    update $this
}

proc configurationInterface::update {this} {
    set selection [$composite::($this,names,path) curselection]
    if {[llength $selection]==0} {
        return
    }
    scan [lindex [$composite::($this,names,path) get $selection] 0] {%[^(]} name
    set managed $configurationInterface::($this,managed)
    if {[string compare $name this]==0} {
        updateOptionEntries $this $managed
    } else {
        updateOptionEntries $this $composite::($managed,$name)
        ::update idletasks
        flashHighlight $this $composite::($managed,$name,path)
    }
}

proc configurationInterface::updateOptionEntries {this widget {columns 2}} {
    if {[info exists configurationInterface::($this,entriesPath)]} {
        scroller::display $composite::($this,scroller) {}
        destroy $configurationInterface::($this,entriesPath)
    }
    set configurationInterface::($this,entriesPath) [set frame [frame $composite::($this,scroller,path).entries]]
    set columns [expr {2*$columns}]
    set column 0
    set row 0
    foreach description [widget::configure $widget] {
        if {[llength $description]<4} {
            continue
        }
        set option [string trimleft [lindex $description 0] -]
        set label [label $frame.${column}_$row -font {Helvetica -11} -text $option:]
        grid $label -column $column -row $row -sticky e
        incr column
        set entry [entry $frame.${column}_$row -width 12 -font {Helvetica -11 bold}]
        $entry insert 0 [widget::cget $widget -$option]
        bind $entry <Return> "
            $entry configure -background red
            ::update idletasks
            widget::configure $widget -$option \[$entry get\]
            $entry configure -background [$entry cget -background]
        "
        bind $entry <KP_Enter> [bind $entry <Return>]
        grid $entry -column $column -row $row -sticky ew
        if {[incr column]>=$columns} {
            set column 0
            incr row
        }
    }
    for {set column 1} {$column<$columns} {incr column 2} {
        grid columnconfigure $frame $column -weight 1
    }
    scroller::display $composite::($this,scroller) $frame
}

proc configurationInterface::flashHighlight {this path} {
    global highlightEvent

    if {[winfo exists .highlight]} {
        after cancel $highlightEvent
        destroy .highlight
    }
    toplevel .highlight -background {} -highlightthickness 1\
        -highlightbackground red -width [expr {[winfo width $path]+2}] -height [expr {[winfo height $path]+2}]
    wm overrideredirect .highlight 1
    wm geometry .highlight +[expr {[winfo rootx $path]-1}]+[expr {[winfo rooty $path]-1}]
    set highlightEvent [after 2000 {catch {destroy .highlight}}]
}

proc configurationInterface::container {this} {
    return $composite::($this,container,path)
}
set rcsId {$Id: arrowbut.tcl,v 1.31 1997/09/19 09:50:23 jfontain Exp $}

proc maximum {a b} {return [expr {$a>$b?$a:$b}]}

class arrowButton {}

proc arrowButton::arrowButton {this parentPath args} composite {
    [new canvas $parentPath\
        -relief raised -background $widget::(default,ButtonBackgroundColor)\
        -borderwidth $widget::(default,ButtonBorderWidth) -height $widget::(default,ScrollbarWidth)\
        -highlightbackground $widget::(default,ButtonHighlightBackground) -highlightcolor $widget::(default,ButtonHighlight)\
        -highlightthickness $widget::(default,ButtonHighlightWidth) -width $widget::(default,ScrollbarWidth)\
    ] $args
} {
    set path $widget::($this,path)
    set arrowButton::($this,triangle) [$path create polygon 0 0 0 0 0 0]
    bind $path <Configure> "arrowButton::redraw $this %w %h"
    set arrowButton::($this,active) 0
    composite::complete $this
}

proc arrowButton::~arrowButton {this} {}

proc arrowButton::options {this} {
    return [list\
        [list\
            -activebackground activeBackground Foreground\
            $widget::(default,ButtonActiveBackgroundColor) $widget::(default,ButtonActiveBackgroundColor)\
        ]\
        [list -background background Background $widget::(default,ButtonBackgroundColor) $widget::(default,ButtonBackgroundColor)]\
        [list -borderwidth borderWidth BorderWidth $widget::(default,ButtonBorderWidth) $widget::(default,ButtonBorderWidth)]\
        [list -command command Command {} {}]\
        [list -direction direction Direction down]\
        [list\
            -disabledforeground disabledForeground DisabledForeground\
            $widget::(default,ButtonDisabledForegroundColor) $widget::(default,ButtonDisabledForegroundColor)\
        ]\
        [list -foreground foreground Foreground $widget::(default,ButtonForeground) $widget::(default,ButtonForeground)]\
        [list -height height Height $widget::(default,ScrollbarWidth) $widget::(default,ScrollbarWidth)]\
        [list\
            -highlightbackground highlightBackground HighlightBackground\
            $widget::(default,ButtonHighlightBackground) $widget::(default,ButtonHighlightBackground)\
        ]\
        [list -highlightcolor highlightColor HighlightColor $widget::(default,ButtonHighlight) $widget::(default,ButtonHighlight)]\
        [list\
            -highlightthickness highlightThickness HighlightThickness\
            $widget::(default,ButtonHighlightWidth) $widget::(default,ButtonHighlightWidth)\
        ]\
        [list -repeatdelay repeatDelay RepeatDelay 0 0]\
        [list -state state State normal]\
        [list -takefocus takeFocus TakeFocus 1]\
        [list -width width Width $widget::(default,ScrollbarWidth) $widget::(default,ScrollbarWidth)]\
    ]
}

proc arrowButton::set-activebackground {this value} {}

proc arrowButton::set-state {this value} {
    set path $widget::($this,path)
    switch $value {
        normal {
            $path itemconfigure $arrowButton::($this,triangle)\
                -fill $composite::($this,-foreground) -outline $composite::($this,-foreground)
            bind $path <Enter> "arrowButton::activate $this"
            bind $path <Leave> "arrowButton::deactivate $this; arrowButton::raise $this"
            bind $path <ButtonPress-1>\
                "set arrowButton::($this,buttonPressed) 1; arrowButton::sink $this; arrowButton::startTimer $this"
            bind $path <ButtonRelease-1>\
                "arrowButton::raise $this; arrowButton::invoke $this 0; set arrowButton::($this,buttonPressed) 0"
            if {$composite::($this,-takefocus)} {
                bind $path <KeyPress-space> "arrowButton::sink $this"
                bind $path <KeyRelease-space> "arrowButton::raise $this; arrowButton::invoke $this 1"
            } else {
                bind $path <KeyPress-space> {}
                bind $path <KeyRelease-space> {}
            }
        }
        disabled {
            $widget::($this,path) itemconfigure $arrowButton::($this,triangle)\
                -fill $composite::($this,-disabledforeground) -outline $composite::($this,-disabledforeground)
            bind $path <Enter> {}
            bind $path <Leave> {}
            bind $path <ButtonPress-1> {}
            bind $path <ButtonRelease-1> {}
            bind $path <KeyPress-space> {}
            bind $path <KeyRelease-space> {}
        }
        default {
            error "bad state value \"$value\": must be normal or disabled"
        }
    }
}

foreach option {-background -borderwidth -height -highlightbackground -highlightcolor -highlightthickness -width} {
    proc arrowButton::set$option {this value} "\$widget::(\$this,path) configure $option \$value"
}

foreach option {-disabledforeground -foreground} {
    proc arrowButton::set$option {this value} {set-state $this $composite::($this,-state)}
}

proc arrowButton::set-command {this value} {}

proc arrowButton::set-direction {this value} {
    if {\
        ([string first $value down]!=0)&&([string first $value up]!=0)&&\
        ([string first $value left]!=0)&&([string first $value right]!=0)\
    } {
        error "bad direction value \"$value\": must be down, up, left or right (or any abbreviation)"
    }
    redraw $this [winfo width $widget::($this,path)] [winfo height $widget::($this,path)]
}

proc arrowButton::set-takefocus {this value} {
    if {![regexp {^0|1$} $value]} {
        error "bad takefocus value \"$value\": must be 0 or 1"
    }
    $widget::($this,path) configure -takefocus $value
    set-state $this $composite::($this,-state)
}

proc arrowButton::set-repeatdelay {this value} {}

proc arrowButton::redraw {this width height} {
    set insideWidth [expr {$width-2*($composite::($this,-borderwidth)+$composite::($this,-highlightthickness))}]
    set insideHeight [expr {$height-2*($composite::($this,-borderwidth)+$composite::($this,-highlightthickness))}]
    switch -glob $composite::($this,-direction) {
        d* {
            set insideWidth [maximum [expr {$insideWidth/4}] 1]
            $widget::($this,path) coords $arrowButton::($this,triangle) 0 0 [expr {2*$insideWidth}] 0 $insideWidth $insideWidth
        }
        u* {
            set insideWidth [maximum [expr {$insideWidth/4}] 1]
            $widget::($this,path) coords $arrowButton::($this,triangle) 0 0 [expr {2*$insideWidth}] 0 $insideWidth -$insideWidth
        }
        l* {
            set insideHeight [maximum [expr {$insideHeight/4}] 1]
            $widget::($this,path) coords $arrowButton::($this,triangle) 0 0 0 [expr {2*$insideHeight}] -$insideHeight $insideHeight
        }
        r* {
            set insideHeight [maximum [expr {$insideHeight/4}] 1]
            $widget::($this,path) coords $arrowButton::($this,triangle) 0 0 0 [expr {2*$insideHeight}] $insideHeight $insideHeight
        }
    }
    centerTriangle $this $width $height
}

proc arrowButton::centerTriangle {this width height} {
    set box [$widget::($this,path) bbox $arrowButton::($this,triangle)]
    $widget::($this,path) move $arrowButton::($this,triangle)\
        [expr {($width-[lindex $box 2]-[lindex $box 0])/2}] [expr {($height-[lindex $box 3]-[lindex $box 1])/2}]
}

proc arrowButton::activate {this} {
    $widget::($this,path) configure -background $composite::($this,-activebackground)
    set arrowButton::($this,active) 1
}

proc arrowButton::deactivate {this} {
    $widget::($this,path) configure -background $composite::($this,-background)
    set arrowButton::($this,active) 0
}

proc arrowButton::sink {this} {
    set path $widget::($this,path)
    $path configure -relief sunken
    centerTriangle $this [winfo width $path] [winfo height $path]
    $path move $arrowButton::($this,triangle) 1 1
}

proc arrowButton::raise {this} {
    set path $widget::($this,path)
    $path configure -relief raised
    centerTriangle $this [winfo width $path] [winfo height $path]
    if {[info exists arrowButton::($this,event)]} {
        after cancel $arrowButton::($this,event)
        unset arrowButton::($this,event)
    }
}

proc arrowButton::invoke {this fromKey} {
    if {([string length $composite::($this,-command)]>0)&&($arrowButton::($this,active)||$fromKey)} {
        uplevel #0 $composite::($this,-command)
    }
}

proc arrowButton::startTimer {this} {
    if {$composite::($this,-repeatdelay)>0} {
        set arrowButton::($this,event) [after $composite::($this,-repeatdelay) "arrowButton::processTimer $this"]
    }
}

proc arrowButton::processTimer {this} {
    if {$arrowButton::($this,buttonPressed)} {
        startTimer $this
        invoke $this 0
    } else {
        unset arrowButton::($this,event)
    }
}
set rcsId {$Id: scrolist.tcl,v 1.23 1997/09/07 20:07:30 jfontain Exp $}

class scrollList {}

proc scrollList::scrollList {this parentPath args} composite {
    [new frame $parentPath -highlightthickness $widget::(default,ButtonHighlightWidth)] $args
} {
    composite::manage $this [new listbox $widget::($this,path) -highlightthickness 0] listbox
    set listboxPath $composite::($this,listbox,path)

    bind $widget::($this,path) <FocusIn> "focus $listboxPath"
    bind $listboxPath <Button2-Motion> break
    pack $listboxPath -fill both -expand 1

    composite::manage $this\
        [new scrollbar $widget::($this,path) -command "$listboxPath yview" -highlightthickness 0 -takefocus 0] scrollbar
    widget::configure $composite::($this,listbox) -yscrollcommand "scrollList::updateScrollbar $this"

    composite::complete $this
}

proc scrollList::~scrollList {this} {}

proc scrollList::options {this} {
    return [list\
        [list -font font Font $widget::(default,ListboxFont) $widget::(default,ListboxFont)]\
        [list -height height Height $widget::(default,ListboxHeight) $widget::(default,ListboxHeight)]\
        [list -list list List {} {}]\
        [list -selectmode selectMode SelectMode $widget::(default,ListboxSelectMode) $widget::(default,ListboxSelectMode)]\
        [list -width width Width $widget::(default,ListboxWidth) $widget::(default,ListboxWidth)]\
    ]
}

proc scrollList::set-list {this value} {
    set listboxPath $composite::($this,listbox,path)
    $listboxPath delete 0 end
    eval $listboxPath insert 0 $value
    $listboxPath activate 0
}

foreach option {-font -height -selectmode -width} {
    proc scrollList::set$option {this value} "\$composite::(\$this,listbox,path) configure $option \$value"
}

foreach command {activate bbox curselection delete get index insert nearest scan see selection size} {
    proc scrollList::$command {this args} "eval \$composite::(\$this,listbox,path) $command \$args"
}

proc scrollList::updateScrollbar {this first last} {
    if {($last-$first)<1} {
        $composite::($this,scrollbar,path) set $first $last
        pack $composite::($this,scrollbar,path) -fill y -before $composite::($this,listbox,path) -side right
    } else {
        pack forget $composite::($this,scrollbar,path)
    }
}
set rcsId {$Id: combobut.tcl,v 1.37 1997/06/04 19:58:43 jfontain Exp $}

class comboButton {}

proc comboButton::comboButton {this parentPath args} composite {
    [new arrowButton $parentPath -command "comboButton::popupListBox $this"] $args
} {
    composite::manage $this [new toplevel [winfo toplevel $parentPath] -cursor right_ptr] shell
    set shellPath $composite::($this,shell,path)
    if {$widget::(default,MenuBorderWidth)==0} {
        $shellPath configure -highlightbackground black -highlightthickness 1
    } else {
        $shellPath configure -relief $widget::(default,MenuRelief) -borderwidth $widget::(default,MenuBorderWidth)
    }
    bind $shellPath <Escape> "comboButton::unpopListBox $this"
    bind $shellPath <Any-ButtonRelease> "comboButton::unpopListBox $this"
    wm overrideredirect $shellPath 1
    wm withdraw $shellPath

    composite::manage $this [new scrollList $shellPath] scroll
    widget::configure $composite::($this,scroll) base -highlightthickness 0
    widget::configure $composite::($this,scroll) listbox -borderwidth 0
    pack $composite::($this,scroll,path) -fill both -expand 1

    set listboxPath $composite::($composite::($this,scroll),listbox,path)
    set sequence "comboButton::invokeCommand $this; comboButton::unpopListBox $this"
    bind $listboxPath <ButtonRelease-1> $sequence
    bind $listboxPath <KeyRelease-space> $sequence
    bind $listboxPath <Return> $sequence
    bind $listboxPath <KP_Enter> $sequence

    bindtags $composite::($composite::($this,scroll),scrollbar,path) Scrollbar

    composite::complete $this
}

proc comboButton::~comboButton {this} {}

proc comboButton::options {this} {
    return [list\
        [list -command command Command {} {}]\
        [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
        [list -list list List {}]\
        [list -listheight listheight Height 3]\
        [list -reference reference Reference {} {}]\
        [list -state state State normal]\
        [list -takefocus takeFocus TakeFocus {} {}]\
    ]
}

proc comboButton::set-command {this value} {}

proc comboButton::set-font {this value} {
    widget::configure $composite::($this,scroll) -font $value
}

proc comboButton::set-list {this value} {
    if {[llength $value]==0} {
        widget::configure $composite::($this,base) -state disabled
    } else {
        widget::configure $composite::($this,base) -state normal
    }
    widget::configure $composite::($this,scroll) -list $value
}

foreach option {-state -takefocus} {
    proc comboButton::set$option {this value} "widget::configure \$composite::(\$this,base) $option \$value"
}

proc comboButton::set-listheight {this value} {
    widget::configure $composite::($this,scroll) -height $value
}

proc comboButton::set-reference {this value} {}

proc comboButton::set-borderwidth {this value} {
    widget::configure $composite::($this,base) -borderwidth $value
}

proc comboButton::popupListBox {this} {
    set shellPath $composite::($this,shell,path)
    if {[winfo exists $composite::($this,-reference)]} {
        set path $composite::($this,-reference)
        set border 0
        catch {set border [$path cget -highlightthickness]}
        set x [expr {[winfo rootx $path]+$border}]
        wm geometry $shellPath [expr {[winfo width $path]-(2*$border)}]x[winfo reqheight $shellPath]
    } else {
        set path $widget::($this,path)
        set x [expr {[winfo rootx $path]+[winfo width $path]-[winfo reqwidth $shellPath]}]
    }
    if {$x<0} {
        set x 0
    }
    wm geometry $shellPath +$x+[expr {[winfo rooty $path]+[winfo height $path]}]
    wm deiconify $shellPath
    raise $shellPath
    grab -global $shellPath
    set comboButton::($this,focus) [focus]
    focus $composite::($this,scroll,path)
}

proc comboButton::unpopListBox {this} {
    set path $composite::($this,shell,path)
    if {![winfo ismapped $path]} {
        return
    }
    wm withdraw $path
    grab release $path
    focus $comboButton::($this,focus)
    unset comboButton::($this,focus)
}

proc comboButton::invokeCommand {this} {
    if {[string length $composite::($this,-command)]==0} {
        return
    }
    set selection [scrollList::curselection $composite::($this,scroll)]
    if {[string length $selection]==0} {
        uplevel #0 $composite::($this,-command) [list {}]
    } else {
        uplevel #0 $composite::($this,-command) [list [scrollList::get $composite::($this,scroll) $selection]]
    }
}

. configure -background black -borderwidth 1
set options [new configurationInterface .]
set button [new comboButton [configurationInterface::container $options] -list {{first choice} {second choice} {third choice}}]
pack $widget::($button,path) -anchor ne -padx 10
configurationInterface::manage $options $button

