set rcsId {$Id: combobut.tcl,v 1.37 1997/06/04 19:58:43 jfontain Exp $}

class comboButton {}

proc comboButton::comboButton {this parentPath args} composite {
    [new arrowButton $parentPath -command "comboButton::popupListBox $this"] $args
} {
    composite::manage $this [new toplevel [winfo toplevel $parentPath] -cursor right_ptr] shell
    set shellPath $composite::($this,shell,path)
    if {$widget::(default,MenuBorderWidth)==0} {               ;# use a thin black border for popup window, such as in windows menus
        $shellPath configure -highlightbackground black -highlightthickness 1
    } else {                                                                                       ;# use a border, such as in motif
        $shellPath configure -relief $widget::(default,MenuRelief) -borderwidth $widget::(default,MenuBorderWidth)
    }
    bind $shellPath <Escape> "comboButton::unpopListBox $this"
    bind $shellPath <Any-ButtonRelease> "comboButton::unpopListBox $this"         ;# allow any mouse click outside shell to unpop it
    wm overrideredirect $shellPath 1                                                                ;# no window manager decorations
    wm withdraw $shellPath                                                                           ;# list is invisible by default

    composite::manage $this [new scrollList $shellPath] scroll
    # disallow focus display and listbox border so as to behave as a menu pane
    widget::configure $composite::($this,scroll) base -highlightthickness 0
    widget::configure $composite::($this,scroll) listbox -borderwidth 0
    pack $composite::($this,scroll,path) -fill both -expand 1

    set listboxPath $composite::($composite::($this,scroll),listbox,path)
    # a button release or a space bar hit within the listbox means a selection
    set sequence "comboButton::invokeCommand $this; comboButton::unpopListBox $this"
    bind $listboxPath <ButtonRelease-1> $sequence
    bind $listboxPath <KeyRelease-space> $sequence
    bind $listboxPath <Return> $sequence
    bind $listboxPath <KP_Enter> $sequence

    # just keep class bindings for scrollbar so that mouse action does not unpop the scrolled list
    bindtags $composite::($composite::($this,scroll),scrollbar,path) Scrollbar

    composite::complete $this
}

proc comboButton::~comboButton {this} {}

proc comboButton::options {this} {                                            ;# force initialization on list and listheight options
    return [list\
        [list -command command Command {} {}]\
        [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
        [list -list list List {}]\
        [list -listheight listheight Height 3]\
        [list -reference reference Reference {} {}]\
        [list -state state State normal]\
        [list -takefocus takeFocus TakeFocus {} {}]\
    ]
}

proc comboButton::set-command {this value} {}                                ;# do nothing, command is stored at the composite level

proc comboButton::set-font {this value} {
    widget::configure $composite::($this,scroll) -font $value
}

proc comboButton::set-list {this value} {
    if {[llength $value]==0} {
        widget::configure $composite::($this,base) -state disabled
    } else {
        widget::configure $composite::($this,base) -state normal
    }
    widget::configure $composite::($this,scroll) -list $value
}

foreach option {-state -takefocus} {
    proc comboButton::set$option {this value} "widget::configure \$composite::(\$this,base) $option \$value"
}

proc comboButton::set-listheight {this value} {
    widget::configure $composite::($this,scroll) -height $value
}

proc comboButton::set-reference {this value} {}                     ;# do nothing, reference widget is stored at the composite level

proc comboButton::set-borderwidth {this value} {
    widget::configure $composite::($this,base) -borderwidth $value
}

proc comboButton::popupListBox {this} {
    set shellPath $composite::($this,shell,path)
    if {[winfo exists $composite::($this,-reference)]} {
        set path $composite::($this,-reference)
        set border 0                           ;# use reference widget width eventually without including highlight border thickness
        catch {set border [$path cget -highlightthickness]}
        set x [expr {[winfo rootx $path]+$border}]
        wm geometry $shellPath [expr {[winfo width $path]-(2*$border)}]x[winfo reqheight $shellPath]
    } else {
        set path $widget::($this,path)
        set x [expr {[winfo rootx $path]+[winfo width $path]-[winfo reqwidth $shellPath]}]
    }
    if {$x<0} {
        set x 0
    }
#    global embed_args
#    if {[info exists embed_args]} {
#        # work around winfo root? plug-in bug
#        place $shellPath -bordermode ignore -in [winfo parent $path]\
#            -x [expr {$x-[winfo rootx $path]+[winfo x $path]}] -y [expr {[winfo height $path]+[winfo y $path]}]
#    } else {
#        wm geometry $shellPath +$x+[expr {[winfo rooty $path]+[winfo height $path]}]
#    }
    wm geometry $shellPath +$x+[expr {[winfo rooty $path]+[winfo height $path]}]
    wm deiconify $shellPath
    raise $shellPath
    grab -global $shellPath
    set comboButton::($this,focus) [focus]
    focus $composite::($this,scroll,path)
}

proc comboButton::unpopListBox {this} {
    set path $composite::($this,shell,path)
    if {![winfo ismapped $path]} {                                                                               ;# already unpopped
        return
    }
    wm withdraw $path
    grab release $path
    focus $comboButton::($this,focus)                               ;# restore focus (only useful within safe interpreter emulation)
    unset comboButton::($this,focus)
}

proc comboButton::invokeCommand {this} {
    if {[string length $composite::($this,-command)]==0} {
        return
    }
    set selection [scrollList::curselection $composite::($this,scroll)]
    if {[string length $selection]==0} {
        uplevel #0 $composite::($this,-command) [list {}]                  ;# always invoke command at global level as tk buttons do
    } else {
        uplevel #0 $composite::($this,-command) [list [scrollList::get $composite::($this,scroll) $selection]]
    }
}
