if {[catch {package require stooop 3.0}]} {                                               ;# in case stooop package is not installed
    source stooop.tcl
}
namespace import stooop::*
if {[catch {package require scwoop 2.0}]} {                                               ;# in case scwoop package is not installed
    source scwoop.tcl
    source arrowbut.tcl
    source combobut.tcl
    source comboent.tcl
    source scrolist.tcl
    source bindings.tcl
    source widgetip.tcl
    source notebook.tcl
    source scroller.tcl
    source labelfra.tcl
    source spinent.tcl
    source panner.tcl
    source optimenu.tcl
}

set book [new notebook . -columns 6]
pack $widget::($book,path) -fill both -expand 1

set frame [notebook::newPage $book arrowButton]
$frame configure -width 300 -height 300
set widget [new arrowButton $frame]
place $widget::($widget,path) -x 10 -y 10
set widget [new arrowButton $frame -width 20]
place $widget::($widget,path) -x 10 -y 100
set widget [new arrowButton $frame -width 50]
place $widget::($widget,path) -x 100 -y 10
set widget [new arrowButton $frame -width 30]
place $widget::($widget,path) -x 100 -y 100
set widget [new arrowButton $frame -width 40]
place $widget::($widget,path) -x 200 -y 200

set frame [notebook::newPage $book comboButton]
$frame configure -width 300 -height 300
set widget [new comboButton $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new comboButton $frame -list {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -x 160 -y 100
set widget [new comboButton $frame -list {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 140

set frame [notebook::newPage $book comboEntry]
$frame configure -width 300 -height 300
set widget [new comboEntry $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new comboEntry $frame -list {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -y 60
set widget [new comboEntry $frame -list {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 140

set frame [notebook::newPage $book scrollList]
$frame configure -width 300 -height 300
set list [new scrollList $frame -list {0 1 2 3 4 5 6 7 8 9}]
place $widget::($list,path) -x 10 -y 10 -width 80 -height 50
set list [new scrollList $frame -list {10 11 12 13}]
place $widget::($list,path) -x 100 -y 20
set list [new scrollList $frame -list {20 21 22 23 24 25 26 27 28 29}]
place $widget::($list,path) -x 140 -y 50 -width 100 -height 80

set frame [notebook::newPage $book scroller]
set scroll [new scroller $frame -width 300 -height 200]
pack $widget::($scroll,path) -fill both -expand 1
scroller::display $scroll [\
    message $widget::($scroll,path).message -aspect 100 -text {\
Question 1.1.  What is Linux ?

Linux is a Unix clone written from scratch by Linus Torvalds with assistance from a loosely-knit team of hackers across the Net.  It aims towards POSIX compliance.

It has all the features you would expect in a modern fully-fledged Unix, including true multitasking, virtual memory, shared libraries, demand loading, shared copy-on-write executables, proper memory management and TCP/IP networking.

It runs mainly on 386/486/586-based PCs, using the hardware facilities of the 386 processor family (TSS segments et al) to implement these features. Ports to other architectures are underway [Q1.4 `What ports to other processors are there ?'].

See the Linux INFO-SHEET [Q2.1 `Where can I get the HOWTOs and other documentation ?'] for more details.

The Linux kernel is distributed under the GNU General Public License - see Q1.6 `Is Linux PD ?  Copyrighted ?' for more details.
    }\
]

set frame [notebook::newPage $book widgetTip]
pack [label $frame.label -text {rest you mouse on top of this} -relief sunken -borderwidth 1 -padx 10 -pady 10]
new widgetTip . -path $frame.label -text {some help}

set frame [notebook::newPage $book spinEntry]
$frame configure -width 300 -height 300
set widget [new spinEntry $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 50
set widget [new spinEntry $frame -range {0 1 .05}]
place $widget::($widget,path) -x 10 -y 100
set widget [new spinEntry $frame -range {0 100 1} -width 3 -justify center -editable 0]
place $widget::($widget,path) -x 100 -y 160

set frame [notebook::newPage $book labelledFrame]
$frame configure -width 300 -height 300
set widget [new labelledFrame $frame -text choices]
place $widget::($widget,path) -x 10 -y 10
set choice 1
pack [radiobutton $widget::($widget,path).1 -variable choice -value 1 -text {first choice}] -anchor nw
pack [radiobutton $widget::($widget,path).2 -variable choice -value 2 -text {second choice}] -anchor nw
pack [radiobutton $widget::($widget,path).3 -variable choice -value 3 -text {third choice}] -anchor nw
set widget [new labelledFrame $frame -text choices -anchor s]
place $widget::($widget,path) -x 150 -y 150
pack [checkbutton $widget::($widget,path).4 -text {fourth choice}] -anchor nw
pack [checkbutton $widget::($widget,path).5 -text {fifth choice}] -anchor nw
pack [checkbutton $widget::($widget,path).6 -text {sixth choice}] -anchor nw

set frame [notebook::newPage $book panner]
set widget [new panner $frame -panes 3]
pack $widget::($widget,path) -fill both -expand 1
pack [frame $panner::($widget,frame1).w -width 200 -height 70 -background cyan -relief raised -bd 1] -fill both -expand 1
pack [frame $panner::($widget,frame2).w -width 200 -height 70 -background yellow -relief raised -bd 1] -fill both -expand 1
pack [frame $panner::($widget,frame3).w -width 200 -height 70 -background magenta -relief raised -bd 1] -fill both -expand 1

set frame [notebook::newPage $book optionMenu]
$frame configure -width 300 -height 300
set widget [new optionMenu $frame -choices {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new optionMenu $frame -choices {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -x 160 -y 100
set widget [new optionMenu $frame -choices {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 200

set frame [notebook::newPage $book notebook]
pack [label $frame.label -text {did you say recursion?}]
set widget [new notebook $frame]
pack $widget::($widget,path)
set frame [notebook::newPage $widget red]
pack [canvas $frame.canvas -background red -width 100 -height 100]
set frame [notebook::newPage $widget green]
pack [canvas $frame.canvas -background green -width 100 -height 100]
set frame [notebook::newPage $widget blue]
pack [canvas $frame.canvas -background blue -width 100 -height 100]
