set rcsId {$Id: optimenu.tcl,v 1.24 1997/07/13 12:32:30 jfontain Exp $}

class optionMenu {}

proc optionMenu::optionMenu {this parentPath args} composite {[new button $parentPath -state disabled] $args} {
    set path $widget::($this,path)
    grid rowconfigure $path 0 -weight 1
    grid columnconfigure $path 0 -weight 1
    composite::manage $this [new label $path] label
    grid $composite::($this,label,path) -column 0 -row 0 -sticky nsew
    # separate label from stub with border width value so that shell when popped does not hide part of the stub
    grid columnconfigure $path 1 -minsize $widget::(default,ButtonBorderWidth)
    # use a frame instead of a button which does not accept pixel sizes
    composite::manage $this [new frame $path\
        -background $widget::(default,ButtonBackgroundColor) -relief $widget::(default,ButtonRelief)\
        -borderwidth $widget::(default,ButtonBorderWidth) -width 12 -height 8\
    ] stub
    set stubPath $composite::($this,stub,path)
    grid $stubPath -column 2 -row 0
    grid columnconfigure $path 3 -minsize 8

    # setup bindings for activation highlighting
    bind $path <Enter> "if {!\$tk_strictMotif} {$stubPath configure -background $widget::(default,ButtonActiveBackgroundColor)}"
    bind $path <Leave> "if {!\$tk_strictMotif} {$stubPath configure -background $widget::(default,ButtonBackgroundColor)}"

    composite::manage $this [new toplevel [winfo toplevel $parentPath] -cursor right_ptr] shell
    set shellPath $composite::($this,shell,path)
    if {$widget::(default,MenuBorderWidth)==0} {               ;# use a thin black border for popup window, such as in windows menus
        $shellPath configure -highlightbackground black -highlightthickness 1
    } else {                                                                                       ;# use a border, such as in motif
        $shellPath configure -relief $widget::(default,MenuRelief) -borderwidth $widget::(default,MenuBorderWidth)
    }
    wm overrideredirect $shellPath 1                              ;# no window manager decorations, choices are invisible by default
    wm withdraw $shellPath

    global embed_args
    if {[info exists embed_args]} {
        # running in the plug-in environment, menu emulation is not possible since grab command is not yet available
        set sequence <ButtonRelease-1>
    } else {       ;# if not running in the plug-in environment, act as a menu and allow button press in label to pop up the choices
        set sequence <ButtonPress-1>
        bind $composite::($this,label,path) $sequence "optionMenu::popChoices $this"
    }
    bind $path $sequence "optionMenu::popChoices $this"
    bind $composite::($this,stub,path) $sequence "optionMenu::popChoices $this"
    set optionMenu::($this,selectedLabelIndex) 0
    composite::complete $this
}

proc optionMenu::~optionMenu {this} {}

proc optionMenu::options {this} {
    return [list\
        [list -choices choices Choices {} {}]\
        [list -command command Command {} {}]\
        [list -font font Font $widget::(default,MenuFont) $widget::(default,MenuFont)]\
        [list -takefocus takeFocus TakeFocus 1]\
        [list -text text Text {} {}]\
    ]
}

proc optionMenu::set-command {this value} {}

proc optionMenu::set-font {this value} {
    $composite::($this,label,path) configure -font $value
    set-choices $this $composite::($this,-choices)                      ;# geometry management must be updated according to new font
}

proc optionMenu::set-text {this value} {
    $composite::($this,label,path) configure -text $value    
}

proc optionMenu::set-choices {this value} {
    set path $composite::($this,shell,path)
    foreach label [winfo children $path] {                                                           ;# destroy current labels first
        destroy $label
    }
    set index 0
    set width 0
    foreach choice $composite::($this,-choices) {
        set label [label $path.$index -text $choice -relief $widget::(default,MenubuttonRelief) -font $composite::($this,-font)]
        if {[winfo reqwidth $label]>$width} {
            set width [winfo reqwidth $label]
        }
        bind $label <Enter> "optionMenu::select $this $index"
        pack $label -fill x
        incr index
    }
    grid columnconfigure $widget::($this,path) 0 -minsize $width                 ;# find maximum width and apply it to visible label
    wm geometry $path 0x0                                       ;# make sure sizes will be correct the first time choices are popped
    wm deiconify $path
    update idletasks
    wm withdraw $path
    wm geometry $path {}
}

proc optionMenu::set-takefocus {this value} {
    set path $widget::($this,path)
    switch $value {
        0 {
            bind $path <space> {}
            bind $path <Return> {}
            bind $path <KP_Enter> {}
            bind $path <Up> {}
            bind $path <Down> {}
            bind $path <Escape> {}
        }
        1 {
            bind $path <space> "optionMenu::processSpaceKey $this"
            bind $path <Return> "optionMenu::unpopChoices $this; optionMenu::checkSelection $this"
            bind $path <KP_Enter> [bind $path <Return>]
            bind $path <Up> "optionMenu::selectPrevious $this"
            bind $path <Down> "optionMenu::selectNext $this"
            bind $path <Escape> "optionMenu::unpopChoices $this"
        }
        default {
            error "bad takefocus value \"$value\": must be 0 or 1"
        }
    }
    $path configure -takefocus $value
}

proc optionMenu::popChoices {this} {
    if {[llength $composite::($this,-choices)]==0} {
        return
    }
    update idletasks                                                                                  ;# make sure sizes are correct
    set shellPath $composite::($this,shell,path)

    set choicesLabel [lindex [winfo children $composite::($this,shell,path)] $optionMenu::($this,selectedLabelIndex)]
    $choicesLabel configure -relief $widget::(default,MenuRelief)

    set labelPath $composite::($this,label,path)  ;# position selected label center at the same abscissa of the display label center
    set x [expr {[winfo rootx $labelPath]-$widget::(default,MenuBorderWidth)}]
    if {$x<0} {
        set x 0
    }
    set y [expr {[winfo rooty $labelPath]+(([winfo height $labelPath]-[winfo height $choicesLabel])/2)-[winfo y $choicesLabel]}]
    if {$y<0} {
        set y 0
    }
#    global embed_args
#    if {[info exists embed_args]} {
#        # work around winfo root? plug-in bug
#        place $shellPath -bordermode ignore -in [winfo parent $labelPath]\
#            -x [expr {$x-[winfo rootx $labelPath]+[winfo x $labelPath]}]\
#            -y [expr {$y-[winfo rooty $labelPath]+[winfo y $labelPath]}]
#    } else {
#        wm geometry $shellPath +$x+$y
#    }
    wm geometry $shellPath +$x+$y
    # make sure choices width is identical to label width
    wm geometry $shellPath [expr {[winfo width $labelPath]+(2*$widget::(default,MenuBorderWidth))}]x[winfo reqheight $shellPath]
    wm deiconify $shellPath
    raise $shellPath
    update idletasks

    global embed_args
    if {[info exists embed_args]} {                    ;# running in the plug-in environment, grab does not work yet and is emulated
        bind $shellPath <ButtonRelease-1> "optionMenu::unpopChoices $this; optionMenu::checkSelection $this"
        grab $shellPath
    } else {
        # add a small delay before allowing a button release to unpop the shell so that a rapid press / release sequence leaves the
        # shell popped to emulate the Motif behavior
        after 300 "bind $shellPath <ButtonRelease-1> {optionMenu::unpopChoices $this; optionMenu::checkSelection $this}"
        grab -global $shellPath
    }
}

proc optionMenu::unpopChoices {this} {
    set path $composite::($this,shell,path)
    if {![winfo ismapped $path]} {
        return                                                                                                   ;# already unpopped
    }
    wm withdraw $path
    grab release $path
    bind $path <ButtonRelease-1> {}
}

proc optionMenu::checkSelection {this} {
    set selection {}
    foreach label [winfo children $composite::($this,shell,path)] {
        if {[string compare [$label cget -relief] $widget::(default,MenuRelief)]==0} {
            set selection [$label cget -text]
            break
        }
    }
    if {[string length $selection]>0} {
        composite::configure $this -text $selection                        ;# use composite layer so that cget returns current value
        invokeCommand $this $selection
    }
}

proc optionMenu::invokeCommand {this choice} {
    if {[string length $composite::($this,-command)]>0} {
        uplevel #0 $composite::($this,-command) [list $choice]             ;# always invoke command at global level as tk buttons do
    }
}

proc optionMenu::configureChoices {this args} {
    foreach label [winfo children $composite::($this,shell,path)] {
        eval $label configure $option $args
    }
}

proc optionMenu::select {this index} {
    if {![winfo ismapped $composite::($this,shell,path)]} {
        return                                                           ;# no selection should be allowed if choices are not posted
    }
    set labels [winfo children $composite::($this,shell,path)]
    if {$index<0} {
        set index 0
    } elseif {$index>=[llength $labels]} {
        set index [expr {[llength $labels]-1}]
    }
    [lindex $labels $optionMenu::($this,selectedLabelIndex)] configure -background $widget::(default,MenuBackgroundColor)\
        -foreground $widget::(default,MenuForeground) -relief $widget::(default,MenubuttonRelief)
    [lindex $labels $index] configure -background $widget::(default,MenuActiveBackgroundColor)\
        -foreground $widget::(default,MenuActiveForegroundColor) -relief $widget::(default,MenuRelief)
    set optionMenu::($this,selectedLabelIndex) $index
}

proc optionMenu::selectPrevious {this} {
    select $this [expr {$optionMenu::($this,selectedLabelIndex)-1}]
}

proc optionMenu::selectNext {this} {
    select $this [expr {$optionMenu::($this,selectedLabelIndex)+1}]
}

proc optionMenu::processSpaceKey {this} {
    if {[winfo ismapped $composite::($this,shell,path)]} {
        unpopChoices $this
        checkSelection $this
    } else {
        popChoices $this
    }
}
